/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application.grid;

import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.GridEvent;
import com.extjs.gxt.ui.client.widget.BoxComponent;
import com.extjs.gxt.ui.client.widget.grid.ColumnHeader;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridView;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Element;

class ExtendedGridView
extends GridView {
    ExtendedGridView() {
    }

    protected ColumnHeader newColumnHeader() {
        this.header = new ColumnHeader((BoxComponent)this.grid, this.cm){

            protected ComponentEvent createColumnEvent(ColumnHeader pHeader, int column, Menu componentMenu) {
                GridEvent event = new GridEvent(ExtendedGridView.this.grid);
                event.setColIndex(column);
                event.setMenu(componentMenu);
                return event;
            }

            protected Menu getContextMenu(int column) {
                return ExtendedGridView.this.createContextMenu(column);
            }

            protected void onColumnSplitterMoved(int colIndex, int pWidth) {
                super.onColumnSplitterMoved(colIndex, pWidth);
                ExtendedGridView.this.onColumnSplitterMoved(colIndex, pWidth);
            }

            protected void onHeaderClick(ComponentEvent ce, int column) {
                super.onHeaderClick(ce, column);
                if (ce.isShiftKey()) {
                    ExtendedGridView.this.onHeaderClickWithShift((Grid<ModelData>)ExtendedGridView.this.grid, column);
                } else {
                    ExtendedGridView.this.onHeaderClick(ExtendedGridView.this.grid, column);
                }
            }
        };
        this.header.setSplitterWidth(this.splitterWidth);
        this.header.setMinColumnWidth(this.grid.getMinColumnWidth());
        this.header.setTitle("[Click] to sort, [SHIFT+Click] to adjust the width");
        return this.header;
    }

    protected void onHeaderClickWithShift(Grid<ModelData> pGrid, int column) {
        int margin = 10;
        pGrid.getColumnModel().setColumnWidth(column, this.calculateWidthWithScroll(pGrid, column) + margin);
    }

    private int calculateWidthWithScroll(Grid<ModelData> pGrid, int column) {
        GridView view = pGrid.getView();
        Element headerCell = (Element)view.getHeaderCell(this.calculateHeaderCellIndex(pGrid, column));
        headerCell = (Element)headerCell.getFirstChildElement();
        headerCell.getStyle().setWidth(0.0, Style.Unit.PX);
        int max = headerCell.getScrollWidth();
        headerCell.getStyle().setProperty("width", "auto");
        int i = 0;
        while (i < pGrid.getStore().getCount()) {
            Element cell = (Element)view.getCell(i, column).getFirstChildElement();
            cell.getStyle().setWidth(0.0, Style.Unit.PX);
            int width = cell.getScrollWidth();
            cell.getStyle().setProperty("width", "auto");
            if (width > max) {
                max = width;
            }
            ++i;
        }
        return max;
    }

    private int calculateHeaderCellIndex(Grid<ModelData> pGrid, int column) {
        int headerCellIndex = column;
        int i = 0;
        while (i < column) {
            if (pGrid.getColumnModel().getColumn(i).isHidden()) {
                --headerCellIndex;
            }
            ++i;
        }
        return headerCellIndex;
    }
}

