/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.dbmigration;

import ch.systemsx.cisd.common.reflection.AbstractHashable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SimpleTableMetaData
extends AbstractHashable {
    private final String tableName;
    private final String tableFileName;
    private final List<String> columnNames;

    public SimpleTableMetaData(String tableName, String tableFileName, List<String> columnNames) {
        this.tableName = tableName.toUpperCase();
        this.tableFileName = tableFileName;
        this.columnNames = Collections.unmodifiableList(this.convertToUpperCase(columnNames));
    }

    private List<String> convertToUpperCase(List<String> names) {
        ArrayList<String> list = new ArrayList<String>();
        for (String columnName : names) {
            list.add(columnName.toUpperCase());
        }
        return list;
    }

    public final String getTableName() {
        return this.tableName;
    }

    public final String getTableFileName() {
        return this.tableFileName;
    }

    public final List<String> getColumnNames() {
        return this.columnNames;
    }

    public int getIndexOfColumn(String columnName) {
        return this.columnNames.indexOf(columnName.toUpperCase());
    }
}

