/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.etlserver.DelegatingStorageProcessorWithDropbox;
import ch.systemsx.cisd.openbis.dss.generic.shared.IPostRegistrationDatasetHandler;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.AbstractDatasetDropboxHandler;
import java.io.File;
import java.util.Properties;

public class StorageProcessorWithDropbox
extends DelegatingStorageProcessorWithDropbox {
    public static final String DROPBOX_INCOMING_DIRECTORY_PROPERTY = "dropbox-dir";

    public StorageProcessorWithDropbox(Properties properties) {
        super(properties);
    }

    @Override
    public IPostRegistrationDatasetHandler createPostRegistrationDataSetHandler() {
        return new DatasetDropboxHandler(this.properties);
    }

    private static class DatasetDropboxHandler
    extends AbstractDatasetDropboxHandler {
        private static final long serialVersionUID = 1L;
        private final File dropboxIncomingDir;

        public DatasetDropboxHandler(Properties properties) {
            super(properties);
            this.dropboxIncomingDir = this.tryGetDirectory(StorageProcessorWithDropbox.DROPBOX_INCOMING_DIRECTORY_PROPERTY, properties);
        }

        @Override
        protected File tryGetDropboxDir(File originalData, DataSetInformation dataSetInformation) {
            return this.dropboxIncomingDir;
        }

        @Override
        protected String createDropboxDestinationFileName(DataSetInformation dataSetInformation, File incomingDataSetDirectory) {
            return DatasetDropboxHandler.createDropboxDestinationFileName(dataSetInformation, incomingDataSetDirectory, this.datasetCodeSeparator);
        }

        private static String createDropboxDestinationFileName(DataSetInformation dataSetInformation, File incomingDataSetDirectory, String datasetCodeSeparator) {
            String dataSetCode = dataSetInformation.getDataSetCode();
            String originalName = incomingDataSetDirectory.getName();
            String newFileName = String.valueOf(DatasetDropboxHandler.stripFileName(originalName)) + datasetCodeSeparator + dataSetCode + DatasetDropboxHandler.stripFileExtension(originalName);
            return newFileName;
        }

        private static String stripFileExtension(String originalName) {
            int ix = originalName.lastIndexOf(".");
            if (ix == -1) {
                return "";
            }
            return originalName.substring(ix);
        }

        private static String stripFileName(String originalName) {
            int ix = originalName.lastIndexOf(".");
            if (ix == -1) {
                return originalName;
            }
            return originalName.substring(0, ix);
        }
    }
}

