/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.framework;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDisplaySettingsGetter;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ColumnSetting;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailViewConfiguration;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DisplaySettings;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityVisit;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PortletConfiguration;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RealNumberFormatingParameters;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SortInfo;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.WebClientConfiguration;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.displaysettings.ColumnDisplaySettingsUpdate;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.displaysettings.IDisplaySettingsUpdate;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.ColumnModelEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.util.DelayedTask;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class DisplaySettingsManager {
    private static final int QUITE_TIME_BEFORE_SETTINGS_SAVED_MS = 10000;
    private final DisplaySettings displaySettings;
    private final IDisplaySettingsDelayedUpdater updater;
    private final WebClientConfiguration webClientConfiguration;

    public DisplaySettingsManager(DisplaySettings displaySettings, IDisplaySettingsUpdater settingsUpdater, IViewContext<?> viewContext) {
        this(displaySettings, DisplaySettingsManager.createDelayedUpdater(settingsUpdater, viewContext), viewContext.getModel().getApplicationInfo().getWebClientConfiguration());
    }

    private static IDisplaySettingsDelayedUpdater createDelayedUpdater(final IDisplaySettingsUpdater settingsUpdater, IViewContext<?> viewContext) {
        if (!viewContext.getModel().isDisplaySettingsSaving()) {
            return new IDisplaySettingsDelayedUpdater(){

                @Override
                public void executeDelayed(int delayMs) {
                }

                @Override
                public void executeDelayed(IDisplaySettingsUpdate update, int delayMs) {
                }
            };
        }
        return new IDisplaySettingsDelayedUpdater(){

            @Override
            public void executeDelayed(int delayMs) {
                new DelayedTask((Listener)new Listener<BaseEvent>(){

                    public void handleEvent(BaseEvent event) {
                        settingsUpdater.execute();
                    }
                }).delay(delayMs);
            }

            @Override
            public void executeDelayed(final IDisplaySettingsUpdate update, int delayMs) {
                new DelayedTask((Listener)new Listener<BaseEvent>(){

                    public void handleEvent(BaseEvent event) {
                        settingsUpdater.execute(update);
                    }
                }).delay(delayMs);
            }
        };
    }

    public DisplaySettingsManager(DisplaySettings displaySettings, IDisplaySettingsDelayedUpdater updater, WebClientConfiguration webClientConfiguration) {
        if (displaySettings == null) {
            throw new IllegalArgumentException("Unspecified display manager.");
        }
        this.displaySettings = displaySettings;
        this.webClientConfiguration = webClientConfiguration;
        this.updater = updater;
    }

    public <C> void registerGridSettingsChangesListener(final String displayTypeID, final IDisplaySettingsGetter grid) {
        Listener<ColumnModelEvent> listener = new Listener<ColumnModelEvent>(){

            public void handleEvent(ColumnModelEvent event) {
                if (event.getType() == Events.ColumnMove) {
                    int newIndexInTrimmedModel = event.getColIndex();
                    ColumnModel trimmedModel = event.getColumnModel();
                    ColumnConfig movedColumn = trimmedModel.getColumn(newIndexInTrimmedModel);
                    this.updateColumnOrderInFullModel(movedColumn, newIndexInTrimmedModel);
                } else if (this.isFakeWidthChangeEvent(event)) {
                    return;
                }
                DisplaySettingsManager.this.storeSettings(displayTypeID, grid, true);
            }

            private void updateColumnOrderInFullModel(ColumnConfig movedColumn, int newIndexInTrimmedModel) {
                int oldIndexInFullModel = 0;
                int newIndexInFullModel = 0;
                int index = 0;
                int visibleIndex = 0;
                for (ColumnConfig c : grid.getColumnModel().getColumns()) {
                    if (c.equals(movedColumn)) {
                        oldIndexInFullModel = index;
                    }
                    if (!c.isHidden()) {
                        if (visibleIndex == newIndexInTrimmedModel) {
                            newIndexInFullModel = index;
                        }
                        ++visibleIndex;
                    }
                    ++index;
                }
                if (oldIndexInFullModel < newIndexInFullModel) {
                    ++newIndexInFullModel;
                }
                grid.getColumnModel().moveColumn(oldIndexInFullModel, newIndexInFullModel);
            }

            private boolean isFakeWidthChangeEvent(ColumnModelEvent event) {
                List<ColumnSetting> colSettings;
                if (event.getType() == Events.WidthChange && (colSettings = DisplaySettingsManager.this.getColumnSettings(displayTypeID)) != null && colSettings.get(event.getColIndex()) != null) {
                    int newWidth;
                    int oldWidth = colSettings.get(event.getColIndex()).getWidth();
                    return oldWidth == (newWidth = event.getWidth());
                }
                return false;
            }
        };
        ColumnModel columnModel = grid.getColumnModel();
        columnModel.addListener(Events.WidthChange, (Listener)listener);
    }

    public GridDisplaySettings tryApplySettings(String displayTypeID, ColumnModel columnModel, List<String> filteredColumnIds, SortInfo sortInfo) {
        List<ColumnSetting> columnSettings = this.getColumnSettings(displayTypeID);
        if (columnSettings == null) {
            return null;
        }
        return DisplaySettingsManager.tryApplySettings(columnSettings, columnModel, filteredColumnIds, sortInfo);
    }

    private static GridDisplaySettings tryApplySettings(List<ColumnSetting> columnSettings, ColumnModel columnModel, List<String> filteredColumnIds, SortInfo sortInfo) {
        boolean refreshNeeded = false;
        ArrayList<ColumnConfig> newColumnConfigList = new ArrayList<ColumnConfig>();
        HashSet<String> ids = new HashSet<String>();
        ArrayList<String> newFilteredColumnIds = new ArrayList<String>();
        String sortField = sortInfo == null ? null : (sortInfo.getSortField() == null ? null : sortInfo.getSortField());
        SortInfo.SortDir sortDirection = sortInfo == null ? null : sortInfo.getSortDir();
        int i = 0;
        while (i < columnSettings.size()) {
            ColumnConfig columnConfig;
            ColumnSetting columnSetting = columnSettings.get(i);
            String columnID = columnSetting.getColumnID();
            SortInfo.SortDir settingSortDirection = columnSetting.getSortDir();
            if (settingSortDirection != null) {
                sortField = columnID;
                sortDirection = settingSortDirection;
            }
            if ((columnConfig = columnModel.getColumnById(columnID)) != null) {
                if (i != columnModel.getIndexById(columnID)) {
                    refreshNeeded = true;
                }
                ids.add(columnID);
                boolean hidden = columnSetting.isHidden();
                if (columnConfig.isHidden() != hidden) {
                    columnConfig.setHidden(hidden);
                    refreshNeeded = true;
                }
                int width = columnSetting.getWidth();
                if (columnConfig.getWidth() != width) {
                    columnConfig.setWidth(width);
                    refreshNeeded = true;
                }
                newColumnConfigList.add(columnConfig);
                if (columnSetting.hasFilter()) {
                    newFilteredColumnIds.add(columnID);
                }
                if (!(settingSortDirection == null || sortInfo != null && settingSortDirection == sortInfo.getSortDir() && columnID.equals(sortInfo.getSortField()))) {
                    refreshNeeded = true;
                }
            } else {
                ColumnStyle columnStyle = new ColumnStyle();
                columnStyle.setHidden(columnSetting.isHidden());
                columnStyle.setHasFilter(columnSetting.hasFilter());
                columnConfig = new ColumnConfig();
                columnConfig.setColumnStyleName(ColumnStyle.format(columnStyle));
                columnConfig.setId(columnSetting.getColumnID());
                columnConfig.setWidth(columnSetting.getWidth());
                columnConfig.setHidden(true);
                newColumnConfigList.add(columnConfig);
            }
            ++i;
        }
        i = 0;
        while (i < columnModel.getColumnCount()) {
            ColumnConfig column = columnModel.getColumn(i);
            if (!ids.contains(column.getId())) {
                newColumnConfigList.add(column);
            }
            ++i;
        }
        if (!newFilteredColumnIds.equals(filteredColumnIds)) {
            refreshNeeded = true;
        }
        if (refreshNeeded) {
            return new GridDisplaySettings(newColumnConfigList, newFilteredColumnIds, sortField, sortDirection);
        }
        if (sortDirection != null) {
            return new GridDisplaySettings(null, null, sortField, sortDirection);
        }
        return null;
    }

    public void storeSettings(String displayTypeID, IDisplaySettingsGetter grid, boolean delayed) {
        int delayMs = delayed ? 10000 : 1;
        this.storeSettings(displayTypeID, grid.getColumnModel(), grid.getFilteredColumnIds(), grid.getModifier(), grid.getSortState(), delayMs);
    }

    public void storeActiveTabSettings(String tabGroupDisplayID, String selectedTabDisplayID, Object modifier) {
        this.updateActiveTabSettings(tabGroupDisplayID, selectedTabDisplayID, modifier);
        this.updater.executeDelayed(10000);
    }

    private <C> void storeSettings(String displayTypeID, ColumnModel columnModel, List<String> filteredColumnIds, Object modifier, SortInfo sortInfo, int delayMs) {
        List<ColumnSetting> columnSettings = DisplaySettingsManager.createColumnsSettings(columnModel, filteredColumnIds, sortInfo);
        this.updateColumnSettings(displayTypeID, columnSettings, modifier);
        this.updater.executeDelayed(new ColumnDisplaySettingsUpdate(displayTypeID, columnSettings), delayMs);
    }

    public void storeDropDownSettings(String dropDownSettingsID, String newValue) {
        this.updateDropDownSettings(dropDownSettingsID, newValue);
        this.updater.executeDelayed(10000);
    }

    public void storeSettings() {
        this.updater.executeDelayed(1);
    }

    private static List<ColumnSetting> createColumnsSettings(ColumnModel columnModel, List<String> filteredColumnIdsList, SortInfo sortInfo) {
        HashSet<String> filteredColumnIds = new HashSet<String>(filteredColumnIdsList);
        ArrayList<ColumnSetting> columnSettings = new ArrayList<ColumnSetting>();
        int i = 0;
        while (i < columnModel.getColumnCount()) {
            ColumnConfig columnConfig = columnModel.getColumn(i);
            ColumnSetting columnSetting = new ColumnSetting();
            columnSetting.setColumnID(columnConfig.getId());
            columnSetting.setWidth(columnConfig.getWidth());
            ColumnStyle columnStyle = ColumnStyle.parse(columnConfig.getColumnStyleName());
            if (columnStyle != null) {
                columnSetting.setHidden(columnStyle.isHidden());
                columnSetting.setHasFilter(columnStyle.isHasFilter());
            } else {
                columnSetting.setHidden(columnConfig.isHidden());
                columnSetting.setHasFilter(filteredColumnIds.contains(columnConfig.getId()));
            }
            if (sortInfo != null && sortInfo.getSortField() != null && columnSetting.getColumnID().equals(sortInfo.getSortField())) {
                columnSetting.setSortDir(sortInfo.getSortDir());
            }
            columnSettings.add(columnSetting);
            ++i;
        }
        return columnSettings;
    }

    @Deprecated
    public final Serializable tryGetTechnologySpecificSettings(String technologyName) {
        return this.displaySettings.getTechnologySpecificSettings().get(technologyName);
    }

    @Deprecated
    public final void setTechnologySpecificSettings(String technologyName, Serializable newSettings) {
        this.displaySettings.getTechnologySpecificSettings().put(technologyName, newSettings);
    }

    public final List<ColumnSetting> getColumnSettings(String gridDisplayTypeID) {
        return this.displaySettings.getColumnSettings().get(gridDisplayTypeID);
    }

    public final void updateColumnSettings(String gridDisplayTypeID, List<ColumnSetting> newSettings, Object modifier) {
        this.displaySettings.getColumnSettings().put(gridDisplayTypeID, newSettings);
    }

    public final String getActiveTabSettings(String tabGroupDisplayTypeID) {
        return this.displaySettings.getTabSettings().get(tabGroupDisplayTypeID);
    }

    public final DetailViewConfiguration tryGetDetailViewSettings(String entityDetailViewID) {
        Map<String, DetailViewConfiguration> views = this.webClientConfiguration.getViews();
        for (Map.Entry<String, DetailViewConfiguration> entry : views.entrySet()) {
            String keyPattern = entry.getKey();
            if (!entityDetailViewID.matches(keyPattern)) continue;
            return entry.getValue();
        }
        return null;
    }

    private final void updateActiveTabSettings(String tabGroupDisplayID, String selectedTabDisplayID, Object modifier) {
        this.displaySettings.getTabSettings().put(tabGroupDisplayID, selectedTabDisplayID);
    }

    public final Boolean tryGetPanelCollapsedSetting(String panelId) {
        return this.displaySettings.getPanelCollapsedSettings().get(panelId);
    }

    public final void updatePanelCollapsedSetting(String panelId, Boolean value) {
        this.displaySettings.getPanelCollapsedSettings().put(panelId, value);
    }

    public final Integer tryGetPanelSizeSetting(String panelId) {
        return this.displaySettings.getPanelSizeSettings().get(panelId);
    }

    public final void updatePanelSizeSetting(String panelId, Integer value) {
        this.displaySettings.getPanelSizeSettings().put(panelId, value);
    }

    public final boolean isUseWildcardSearchMode() {
        return this.displaySettings.isUseWildcardSearchMode();
    }

    public final void updateUseWildcardSearchMode(Boolean newValue) {
        this.displaySettings.setUseWildcardSearchMode(newValue);
    }

    public final boolean isDebuggingModeEnabled() {
        return this.displaySettings.isDebuggingModeEnabled();
    }

    public final void setDebuggingModeEnabled(boolean isDebugging) {
        this.displaySettings.setDebuggingModeEnabled(isDebugging);
    }

    public final boolean isReopenLastTabOnLogin() {
        return !this.displaySettings.isIgnoreLastHistoryToken();
    }

    public final void setReopenLastTabOnLogin(boolean isReopen) {
        this.displaySettings.setIgnoreLastHistoryToken(!isReopen);
    }

    public final String getDefaultProject() {
        return this.displaySettings.getDefaultProject();
    }

    public final void setDefaultProject(String defaultProject) {
        this.displaySettings.setDefaultProject(defaultProject);
    }

    public final boolean isLegacyMedadataUIEnabled() {
        return this.displaySettings.isLegacyMedadataUIEnabled();
    }

    public final void setLegacyMedadataUIEnabled(boolean legacyMedadataUIEnabled) {
        this.displaySettings.setLegacyMedadataUIEnabled(legacyMedadataUIEnabled);
    }

    public final RealNumberFormatingParameters getRealNumberFormatingParameters() {
        return this.displaySettings.getRealNumberFormatingParameters();
    }

    public String getDropDownSettings(String dropDownID) {
        return this.displaySettings.getDropDownSettings().get(dropDownID);
    }

    private void updateDropDownSettings(String dropDownSettingsID, String newValue) {
        this.displaySettings.getDropDownSettings().put(dropDownSettingsID, newValue);
    }

    public void rememberVisit(EntityVisit visit) {
        this.displaySettings.addEntityVisit(visit);
    }

    public List<EntityVisit> getVisits() {
        return this.displaySettings.getVisits();
    }

    public void addPortlet(PortletConfiguration portletConfiguration) {
        this.displaySettings.addPortlet(portletConfiguration);
    }

    public Map<String, PortletConfiguration> getPortletConfigurations() {
        return this.displaySettings.getPortletConfigurations();
    }

    private static class ColumnStyle {
        private static final String SEPARATOR = "&&";
        private boolean hidden;
        private boolean hasFilter;

        private ColumnStyle() {
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public void setHidden(boolean hidden) {
            this.hidden = hidden;
        }

        public boolean isHasFilter() {
            return this.hasFilter;
        }

        public void setHasFilter(boolean hasFilter) {
            this.hasFilter = hasFilter;
        }

        public static String format(ColumnStyle styleObject) {
            if (styleObject == null) {
                return null;
            }
            return String.valueOf(styleObject.isHidden()) + SEPARATOR + styleObject.isHasFilter();
        }

        public static ColumnStyle parse(String styleString) {
            if (styleString == null) {
                return null;
            }
            String[] parts = styleString.split(SEPARATOR);
            if (parts.length == 2) {
                ColumnStyle styleObject = new ColumnStyle();
                styleObject.setHidden(Boolean.valueOf(parts[0]));
                styleObject.setHasFilter(Boolean.valueOf(parts[1]));
                return styleObject;
            }
            return null;
        }
    }

    public static class GridDisplaySettings {
        private List<ColumnConfig> columnConfigs;
        private List<String> filteredColumnIds;
        private String sortField;
        private SortInfo.SortDir sortDir;

        public GridDisplaySettings(List<ColumnConfig> columnConfigs, List<String> filteredColumnIds, String sortField, SortInfo.SortDir sortDirection) {
            this.columnConfigs = columnConfigs;
            this.filteredColumnIds = filteredColumnIds;
            this.sortField = sortField;
            this.sortDir = sortDirection;
        }

        public List<ColumnConfig> getColumnConfigs() {
            return this.columnConfigs;
        }

        public void setColumnConfigs(List<ColumnConfig> columnConfigs) {
            this.columnConfigs = columnConfigs;
        }

        public List<String> getFilteredColumnIds() {
            return this.filteredColumnIds;
        }

        public void setFilteredColumnIds(List<String> filteredColumnIds) {
            this.filteredColumnIds = filteredColumnIds;
        }

        public String getSortField() {
            return this.sortField;
        }

        public void setSortField(String sortField) {
            this.sortField = sortField;
        }

        public SortInfo.SortDir getSortDir() {
            return this.sortDir;
        }

        public void setSortDir(SortInfo.SortDir sortDir) {
            this.sortDir = sortDir;
        }
    }

    public static interface IDisplaySettingsDelayedUpdater {
        public void executeDelayed(int var1);

        public void executeDelayed(IDisplaySettingsUpdate var1, int var2);
    }

    public static interface IDisplaySettingsUpdater {
        public void execute();

        public void execute(IDisplaySettingsUpdate var1);
    }
}

