/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.menu;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.SearchWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ComponentProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.IActionMenuItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.InfoButton;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.TrashButton;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.administration.AdministrationMenu;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.modules.ModulesMenu;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.top.BrowseMenu;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.top.ImportMenu;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.top.NewMenu;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.user.LoggedUserMenu;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.layout.FlowLayout;
import com.extjs.gxt.ui.client.widget.toolbar.FillToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.SeparatorToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.user.client.Element;

public class TopMenu
extends LayoutContainer {
    public static final String ID = "openbis_top-menu";
    private final ToolBar toolBar;
    private final IViewContext<ICommonClientServiceAsync> viewContext;
    private final ComponentProvider componentProvider;

    public TopMenu(IViewContext<ICommonClientServiceAsync> viewContext, ComponentProvider componentProvider) {
        this.viewContext = viewContext;
        this.componentProvider = componentProvider;
        this.setId(ID);
        this.setLayout((Layout)new FlowLayout());
        this.setBorders(true);
        this.toolBar = new ToolBar();
        this.add((Component)this.toolBar);
    }

    final void refresh() {
        this.toolBar.removeAll();
        this.toolBar.add((Component)new BrowseMenu(this.viewContext, this.componentProvider));
        this.toolBar.add((Component)new NewMenu(this.viewContext, this.componentProvider));
        this.toolBar.add((Component)new ImportMenu(this.viewContext, this.componentProvider));
        this.toolBar.add((Component)new ModulesMenu(this.viewContext, this.viewContext.getClientPluginFactoryProvider(), this.componentProvider));
        this.toolBar.add((Component)new FillToolItem());
        this.toolBar.add((Component)new SearchWidget(this.viewContext));
        this.toolBar.add((Component)new SeparatorToolItem());
        this.toolBar.add((Component)new InfoButton(this.viewContext));
        if (this.viewContext.getModel().getApplicationInfo().getWebClientConfiguration().getEnableTrash()) {
            TrashButton trash = new TrashButton(this.viewContext, this.componentProvider);
            trash.setId("trash-button");
            this.toolBar.add((Component)trash);
        }
        this.toolBar.add((Component)new AdministrationMenu(this.viewContext, this.componentProvider));
        this.toolBar.add((Component)new LoggedUserMenu(this.viewContext, this.componentProvider));
    }

    protected void onRender(Element parent, int pos) {
        super.onRender(parent, pos);
        this.refresh();
    }

    public static enum ActionMenuKind implements IActionMenuItem
    {
        ADMINISTRATION_MENU_MANAGE_GROUPS,
        ADMINISTRATION_MENU_MANAGE_TYPES,
        ADMINISTRATION_MENU_MANAGE_PROPERTY_TYPES,
        ADMINISTRATION_MENU_MANAGE_AUTHORIZATION,
        AUTHORIZATION_MENU_USERS,
        AUTHORIZATION_MENU_ROLES,
        AUTHORIZATION_MENU_AUTHORIZATION_GROUPS,
        LOGGING_CONSOLE,
        DATA_SET_MENU_SEARCH,
        DATA_SET_MENU_TYPES,
        DATA_SET_MENU_FILE_FORMATS,
        DATA_SET_MENU_UPLOAD,
        DATA_SET_MENU_UPLOAD_CLIENT,
        DATA_SET_MENU_MASS_UPDATE,
        EXPERIMENT_MENU_BROWSE,
        EXPERIMENT_MENU_NEW,
        EXPERIMENT_MENU_IMPORT,
        EXPERIMENT_MENU_MASS_UPDATE,
        EXPERIMENT_MENU_TYPES,
        MATERIAL_MENU_BROWSE,
        MATERIAL_MENU_IMPORT,
        MATERIAL_MENU_MASS_UPDATE,
        MATERIAL_MENU_TYPES,
        SAMPLE_MENU_SEARCH,
        SAMPLE_MENU_BROWSE,
        SAMPLE_MENU_NEW,
        SAMPLE_MENU_IMPORT,
        SAMPLE_MENU_MASS_UPDATE,
        SAMPLE_MENU_TYPES,
        SCRIPT_MENU_BROWSE,
        SCRIPT_MENU_NEW,
        PROJECT_MENU_BROWSE,
        PROJECT_MENU_NEW,
        METAPROJECT_MENU_BROWSE,
        PROPERTY_TYPES_MENU_BROWSE_PROPERTY_TYPES,
        PROPERTY_TYPES_MENU_BROWSE_ASSIGNMENTS,
        PROPERTY_TYPES_MENU_NEW_PROPERTY_TYPES,
        PROPERTY_TYPES_MENU_ASSIGN_TO_EXPERIMENT_TYPE,
        PROPERTY_TYPES_MENU_ASSIGN_TO_MATERIAL_TYPE,
        PROPERTY_TYPES_MENU_ASSIGN_TO_DATA_SET_TYPE,
        PROPERTY_TYPES_MENU_ASSIGN_TO_SAMPLE_TYPE,
        USER_MENU_CHANGE_SETTINGS,
        USER_MENU_LOGOUT,
        USER_MENU_LOGIN,
        USER_MENU_ABOUT_BOX,
        VOCABULARY_MENU_BROWSE,
        VOCABULARY_MENU_NEW,
        GENERAL_IMPORT_MENU,
        CUSTOM_IMPORT_MENU,
        ACTIVE_USERS_COUNT;


        @Override
        public String getMenuId() {
            return "openbis_top-menu_" + this.name();
        }

        @Override
        public String getMenuText(IMessageProvider messageProvider) {
            return messageProvider.getMessage(this.name(), new Object[0]);
        }
    }
}

