/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl;

import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.reflection.AbstractHashable;
import ch.systemsx.cisd.hcs.Geometry;
import ch.systemsx.cisd.openbis.dss.etl.AbstractImageStorageProcessor;
import ch.systemsx.cisd.openbis.dss.etl.AcquiredSingleImage;
import ch.systemsx.cisd.openbis.dss.etl.HCSContainerDatasetInfo;
import ch.systemsx.cisd.openbis.dss.etl.HCSImageDatasetInfo;
import ch.systemsx.cisd.openbis.dss.etl.HCSImageDatasetUploader;
import ch.systemsx.cisd.openbis.dss.etl.ImageFileExtractionResult;
import ch.systemsx.cisd.openbis.dss.etl.ImageValidator;
import ch.systemsx.cisd.openbis.dss.etl.dataaccess.IImagingQueryDAO;
import ch.systemsx.cisd.openbis.dss.etl.dto.ImageDatasetInfo;
import ch.systemsx.cisd.openbis.dss.etl.dto.ImageLibraryInfo;
import ch.systemsx.cisd.openbis.dss.etl.dto.ImageZoomLevel;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ThumbnailsStorageFormat;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.FeatureVectorDataSetInformation;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.ImageDataSetInformation;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.ThumbnailsInfo;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.Size;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public final class PlateStorageProcessor
extends AbstractImageStorageProcessor {
    static final String CHANNELS_PER_EXPERIMENT_PROPERTY = "define-channels-per-experiment";
    protected static final String NOTIFY_IF_INCOMPLETE_PROPERTY = "notify-if-incomplete";
    private final boolean globalStoreChannelsOnExperimentLevel;
    private final boolean notifyIfPlateIncomplete;

    public PlateStorageProcessor(Properties properties) {
        super(properties);
        this.globalStoreChannelsOnExperimentLevel = PropertyUtils.getBoolean((Properties)properties, (String)CHANNELS_PER_EXPERIMENT_PROPERTY, (boolean)true);
        this.notifyIfPlateIncomplete = PropertyUtils.getBoolean((Properties)properties, (String)NOTIFY_IF_INCOMPLETE_PROPERTY, (boolean)true);
    }

    @Override
    protected boolean validateImages(DatasetOwnerInformation dataSetInformation, IMailClient mailClient, File incomingDataSetDirectory, ImageFileExtractionResult extractionResult) {
        ImageValidator validator = new ImageValidator(dataSetInformation, mailClient, incomingDataSetDirectory, extractionResult, operationLog, notificationLog, this.notifyIfPlateIncomplete);
        return validator.validateImages();
    }

    private void checkDataSetInformation(ImageDatasetOwnerInformation dataSetInformation) {
        assert (dataSetInformation != null) : "Unspecified data set information";
        assert (dataSetInformation.getSampleIdentifier() != null) : "Unspecified sample identifier";
        ExperimentIdentifier experimentIdentifier = dataSetInformation.getExperimentIdentifier();
        assert (experimentIdentifier != null) : "Unspecified experiment identifier";
        assert (dataSetInformation.tryGetExperiment() != null) : "experiment not set";
        PlateStorageProcessor.checkExperimentIdentifier(experimentIdentifier);
    }

    private static final void checkExperimentIdentifier(ExperimentIdentifier experimentIdentifier) {
        assert (experimentIdentifier.getSpaceCode() != null) : "Space code is null";
        assert (experimentIdentifier.getExperimentCode() != null) : "Experiment code is null";
        assert (experimentIdentifier.getProjectCode() != null) : "Project code is null";
    }

    @Override
    protected void storeInDatabase(IImagingQueryDAO dao, ImageDatasetOwnerInformation dataSetInformation, ImageFileExtractionResult extractedImages, boolean thumbnailsOnly) {
        this.checkDataSetInformation(dataSetInformation);
        Experiment experiment = dataSetInformation.tryGetExperiment();
        assert (experiment != null) : "experiment is null";
        List<AcquiredSingleImage> images = extractedImages.getImages();
        boolean storeChannelsOnExperimentLevel = this.globalStoreChannelsOnExperimentLevel;
        if (extractedImages.tryStoreChannelsOnExperimentLevel() != null) {
            storeChannelsOnExperimentLevel = extractedImages.tryStoreChannelsOnExperimentLevel();
        }
        HCSImageDatasetInfo info = this.createImageDatasetInfo(experiment, dataSetInformation, images, extractedImages.getTileGeometry(), extractedImages.tryGetImageLibrary(), storeChannelsOnExperimentLevel);
        HCSImageDatasetUploader.upload(dao, info, images, extractedImages.getChannels());
    }

    private HCSImageDatasetInfo createImageDatasetInfo(Experiment experiment, ImageDatasetOwnerInformation dataSetInformation, List<AcquiredSingleImage> acquiredImages, Geometry tileGeometry, ImageLibraryInfo imageLibraryInfoOrNull, boolean storeChannelsOnExperimentLevel) {
        HCSContainerDatasetInfo info = HCSContainerDatasetInfo.createScreeningDatasetInfo(dataSetInformation);
        boolean hasImageSeries = PlateStorageProcessor.hasImageSeries(acquiredImages);
        ImageDatasetInfo imageDatasetInfo = new ImageDatasetInfo(tileGeometry.getRows(), tileGeometry.getColumns(), hasImageSeries, imageLibraryInfoOrNull, dataSetInformation.getImageZoomLevels());
        return new HCSImageDatasetInfo(info, imageDatasetInfo, storeChannelsOnExperimentLevel);
    }

    public static class DatasetOwnerInformation
    extends AbstractHashable {
        private final Experiment experiment;
        private final SampleIdentifier sampleIdentifier;
        private final ExperimentIdentifier experimentIdentifier;
        private final Sample sample;
        private final String dataSetCode;
        private final IEntityProperty[] sampleProperties;

        public static DatasetOwnerInformation create(DataSetInformation dataSetInformation) {
            String datasetCode = dataSetInformation instanceof FeatureVectorDataSetInformation ? ((FeatureVectorDataSetInformation)dataSetInformation).tryGetContainerDatasetPermId() : dataSetInformation.getDataSetCode();
            return new DatasetOwnerInformation(datasetCode, dataSetInformation);
        }

        protected DatasetOwnerInformation(String dataSetCode, DataSetInformation dataSetOwner) {
            this(dataSetCode, dataSetOwner.tryGetContainerDataSet(), dataSetOwner.tryToGetSample(), dataSetOwner.getSampleIdentifier(), dataSetOwner.getSampleProperties(), dataSetOwner.tryToGetExperiment(), dataSetOwner.getExperimentIdentifier());
        }

        private DatasetOwnerInformation(String dataSetCode, AbstractExternalData containerOrNull, Sample sampleOrNull, SampleIdentifier sampleIdentifier, IEntityProperty[] sampleProperties, Experiment experiment, ExperimentIdentifier experimentIdentifier) {
            this.dataSetCode = dataSetCode;
            if (sampleOrNull != null) {
                this.sample = sampleOrNull;
                this.sampleIdentifier = sampleIdentifier;
                this.sampleProperties = sampleProperties;
            } else if (containerOrNull != null) {
                this.sample = containerOrNull.getSample();
                this.sampleIdentifier = SampleIdentifierFactory.parse((String)this.sample.getIdentifier());
                this.sampleProperties = this.sample.getProperties().toArray(new IEntityProperty[this.sample.getProperties().size()]);
            } else {
                this.sample = null;
                this.sampleIdentifier = null;
                this.sampleProperties = null;
            }
            this.experiment = experiment;
            this.experimentIdentifier = experimentIdentifier;
        }

        public String getDataSetCode() {
            return this.dataSetCode;
        }

        public SampleIdentifier getSampleIdentifier() {
            return this.sampleIdentifier;
        }

        public Sample tryGetSample() {
            return this.sample;
        }

        public IEntityProperty[] getSampleProperties() {
            return this.sampleProperties;
        }

        public Experiment tryGetExperiment() {
            return this.experiment;
        }

        public ExperimentIdentifier getExperimentIdentifier() {
            return this.experimentIdentifier;
        }
    }

    public static class ImageDatasetOwnerInformation
    extends DatasetOwnerInformation {
        private final List<ImageZoomLevel> imageZoomLevels;

        public static ImageDatasetOwnerInformation create(String containerDatasetPermId, DataSetInformation originalDataset, ThumbnailsInfo thumbnailsInfosOrNull) {
            return new ImageDatasetOwnerInformation(containerDatasetPermId, originalDataset, thumbnailsInfosOrNull);
        }

        private ImageDatasetOwnerInformation(String containerDatasetPermId, DataSetInformation originalDataset, ThumbnailsInfo thumbnailsInfosOrNull) {
            super(containerDatasetPermId, originalDataset);
            this.imageZoomLevels = ImageDatasetOwnerInformation.createZoomLevels(originalDataset, thumbnailsInfosOrNull);
        }

        private static Integer nullifyIfZero(int value) {
            return value == 0 ? null : Integer.valueOf(value);
        }

        private static List<ImageZoomLevel> createZoomLevels(DataSetInformation originalDataset, ThumbnailsInfo thumbnailsInfosOrNull) {
            ArrayList<ImageZoomLevel> zoomLevels = new ArrayList<ImageZoomLevel>();
            Integer width = null;
            Integer height = null;
            boolean original = true;
            Integer colorDepth = null;
            if (originalDataset instanceof ImageDataSetInformation) {
                ImageDataSetInformation imageDataSet = (ImageDataSetInformation)originalDataset;
                width = ImageDatasetOwnerInformation.nullifyIfZero(imageDataSet.getMaximumImageWidth());
                height = ImageDatasetOwnerInformation.nullifyIfZero(imageDataSet.getMaximumImageHeight());
                original = !imageDataSet.getRegisterAsOverviewImageDataSet();
                colorDepth = imageDataSet.getColorDepth();
            }
            if (original) {
                ImageZoomLevel originalZoomLevel = new ImageZoomLevel(originalDataset.getDataSetCode(), original, "", width, height, colorDepth, null, Collections.EMPTY_MAP);
                zoomLevels.add(originalZoomLevel);
            }
            if (thumbnailsInfosOrNull != null) {
                for (String permId : thumbnailsInfosOrNull.getThumbnailPhysicalDatasetsPermIds()) {
                    width = null;
                    height = null;
                    Size dimension = thumbnailsInfosOrNull.tryGetDimension(permId);
                    if (dimension != null) {
                        width = dimension.getWidth();
                        height = dimension.getHeight();
                    }
                    colorDepth = thumbnailsInfosOrNull.tryGetColorDepth(permId);
                    String fileTypeString = null;
                    ThumbnailsStorageFormat.FileFormat fileType = thumbnailsInfosOrNull.getFileType(permId);
                    if (fileType != null) {
                        fileTypeString = fileType.getFileExtension();
                    }
                    String rootPath = thumbnailsInfosOrNull.getRootPath(permId);
                    ImageZoomLevel thumbnailZoomLevel = new ImageZoomLevel(permId, false, rootPath, width, height, colorDepth, fileTypeString, thumbnailsInfosOrNull.getTransformations(permId));
                    zoomLevels.add(thumbnailZoomLevel);
                }
            }
            return zoomLevels;
        }

        public List<ImageZoomLevel> getImageZoomLevels() {
            return this.imageZoomLevels;
        }
    }
}

