/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.dto.api;

import ch.systemsx.cisd.openbis.dss.etl.dto.api.ImageIdentifier;
import org.apache.commons.lang.StringUtils;

public class ImageMetadata {
    private String channelCode;
    private int tileNumber;
    private String well;
    private Float timepointOrNull;
    private Float depthOrNull;
    private Integer seriesNumberOrNull;
    private ImageIdentifier imageIdentifierOrNull;

    public String getChannelCode() {
        return this.channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public int getTileNumber() {
        return this.tileNumber;
    }

    public void setTileNumber(int tileNumber) {
        this.tileNumber = tileNumber;
    }

    public String getWell() {
        return this.well;
    }

    public void setWell(String well) {
        this.well = well;
    }

    public void setTimepoint(Float value) {
        this.timepointOrNull = value;
    }

    public void setDepth(Float value) {
        this.depthOrNull = value;
    }

    public void setSeriesNumber(Integer value) {
        this.seriesNumberOrNull = value;
    }

    public void setImageIdentifier(ImageIdentifier imageIdentifier) {
        this.imageIdentifierOrNull = imageIdentifier;
    }

    public Float tryGetTimepoint() {
        return this.timepointOrNull;
    }

    public Float tryGetDepth() {
        return this.depthOrNull;
    }

    public Integer tryGetSeriesNumber() {
        return this.seriesNumberOrNull;
    }

    public ImageIdentifier tryGetImageIdentifier() {
        return this.imageIdentifierOrNull;
    }

    public void ensureValid(boolean isMicroscopy) {
        if (this.tileNumber <= 0) {
            throw new IllegalStateException("Tile number has to be > 0, but is " + this.tileNumber);
        }
        if (StringUtils.isBlank((String)this.channelCode)) {
            throw new IllegalStateException("Channel code is not specified");
        }
        if (StringUtils.isBlank((String)this.well) && !isMicroscopy) {
            throw new IllegalStateException("Well is not specified");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ImageMetadata [channelCode=" + this.channelCode + ", tileNumber=" + this.tileNumber + ", well=" + this.well);
        if (this.timepointOrNull != null) {
            sb.append(", timepointOrNull =" + this.timepointOrNull);
        }
        if (this.depthOrNull != null) {
            sb.append(", depthOrNull=" + this.depthOrNull);
        }
        if (this.seriesNumberOrNull != null) {
            sb.append(", seriesNumberOrNull=" + this.seriesNumberOrNull);
        }
        if (this.imageIdentifierOrNull != null) {
            sb.append(", imageIdentifierOrNull=" + this.imageIdentifierOrNull);
        }
        sb.append("]");
        return sb.toString();
    }
}

