/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins;

import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.AbstractTableModelReportingPlugin;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.screening.server.util.FeatureVectorLoaderMetadataProviderFactory;
import ch.systemsx.cisd.openbis.dss.shared.DssScreeningUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeNormalizer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CodeAndLabel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DoubleTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IntegerTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.StringTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.util.SimpleTableModelBuilder;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.PlateUtils;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.FeatureValue;
import ch.systemsx.cisd.openbis.plugin.screening.shared.dto.FeatureTableRow;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.FeatureVectorLoader;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.IImagingReadonlyQueryDAO;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ImageAnalysisMergedRowsReportingPlugin
extends AbstractTableModelReportingPlugin {
    private static final long serialVersionUID = 1L;
    private static final String DATA_SET_CODE_TITLE = "Data Set Code";
    private static final String PLATE_IDENTIFIER_TITLE = "Plate Identifier";
    private static final String ROW_TITLE = "Row";
    private static final String COLUMN_TITLE = "Column";
    private static final ISerializableComparable EMPTY_CELL = new StringTableCell("");
    private IEncapsulatedOpenBISService service;
    private IImagingReadonlyQueryDAO dao;

    public ImageAnalysisMergedRowsReportingPlugin(Properties properties, File storeRoot) {
        this(properties, storeRoot, null, null);
    }

    ImageAnalysisMergedRowsReportingPlugin(Properties properties, File storeRoot, IEncapsulatedOpenBISService service, IImagingReadonlyQueryDAO dao) {
        super(properties, storeRoot);
        this.service = service;
        this.dao = dao;
    }

    public TableModel createReport(List<DatasetDescription> datasets, DataSetProcessingContext context) {
        List<String> datasetCodes = ImageAnalysisMergedRowsReportingPlugin.extractDatasetCodes(datasets);
        ArrayList<String> featureCodes = new ArrayList<String>();
        FeatureVectorLoader.WellFeatureCollection<FeatureTableRow> featuresCollection = FeatureVectorLoader.fetchDatasetFeatures(datasetCodes, featureCodes, this.getDAO(), this.getMetadataProvider(datasetCodes));
        List<CodeAndLabel> codeAndLabels = featuresCollection.getFeatureCodesAndLabels();
        List<FeatureTableRow> rows = featuresCollection.getFeatures();
        SimpleTableModelBuilder builder = new SimpleTableModelBuilder(true);
        builder.addHeader(DATA_SET_CODE_TITLE, CodeNormalizer.normalize((String)DATA_SET_CODE_TITLE));
        builder.addHeader(PLATE_IDENTIFIER_TITLE, CodeNormalizer.normalize((String)PLATE_IDENTIFIER_TITLE));
        builder.addHeader(ROW_TITLE, CodeNormalizer.normalize((String)ROW_TITLE));
        builder.addHeader(COLUMN_TITLE, CodeNormalizer.normalize((String)COLUMN_TITLE));
        for (CodeAndLabel codeAndLabel : codeAndLabels) {
            builder.addHeader(codeAndLabel.getLabel(), "feature-" + codeAndLabel.getCode());
        }
        for (FeatureTableRow row : rows) {
            FeatureValue[] featureValues;
            ArrayList<Object> values = new ArrayList<Object>();
            values.add(new StringTableCell(row.getDataSetCode()));
            values.add(new StringTableCell(row.getPlateIdentifier().toString()));
            values.add(new StringTableCell(PlateUtils.translateRowNumberIntoLetterCode(row.getWellLocation().getRow())));
            values.add(new IntegerTableCell((long)row.getWellLocation().getColumn()));
            FeatureValue[] featureValueArray = featureValues = row.getFeatureValues();
            int n = featureValues.length;
            int n2 = 0;
            while (n2 < n) {
                FeatureValue value = featureValueArray[n2];
                values.add(ImageAnalysisMergedRowsReportingPlugin.createCell(value));
                ++n2;
            }
            builder.addRow(values);
        }
        return builder.getTableModel();
    }

    private static ISerializableComparable createCell(FeatureValue value) {
        if (value.isFloat()) {
            float floatValue = value.asFloat();
            if (Float.isNaN(floatValue)) {
                return EMPTY_CELL;
            }
            return new DoubleTableCell((double)floatValue);
        }
        if (value.isVocabularyTerm()) {
            String term = value.tryAsVocabularyTerm();
            if (term == null) {
                return EMPTY_CELL;
            }
            return new StringTableCell(term);
        }
        throw new IllegalStateException("unknown value");
    }

    private static List<String> extractDatasetCodes(List<DatasetDescription> datasets) {
        ArrayList<String> datasetCodes = new ArrayList<String>();
        for (DatasetDescription datasetDescription : datasets) {
            datasetCodes.add(datasetDescription.getDataSetCode());
        }
        return datasetCodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IImagingReadonlyQueryDAO getDAO() {
        ImageAnalysisMergedRowsReportingPlugin imageAnalysisMergedRowsReportingPlugin = this;
        synchronized (imageAnalysisMergedRowsReportingPlugin) {
            if (this.dao == null) {
                this.dao = DssScreeningUtils.getQuery();
            }
        }
        return this.dao;
    }

    private FeatureVectorLoader.IMetadataProvider getMetadataProvider(List<String> datasetCodes) {
        if (this.service == null) {
            this.service = ServiceProvider.getOpenBISService();
        }
        return FeatureVectorLoaderMetadataProviderFactory.createMetadataProvider(this.service, datasetCodes);
    }
}

