/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;

public class StructureDataW
extends StructureData {
    protected Map<StructureMembers.Member, Array> memberData = new HashMap<StructureMembers.Member, Array>();

    public StructureDataW(StructureMembers members) {
        super(members);
    }

    public StructureDataW(StructureData from) {
        this(from.getStructureMembers());
        List<StructureMembers.Member> members = this.getMembers();
        for (StructureMembers.Member m : members) {
            Array data = from.getArray(m);
            this.setMemberData(m, data.copy());
        }
    }

    public void setMemberData(StructureMembers.Member m, Array data) {
        if (data == null) {
            throw new IllegalArgumentException("data cant be null");
        }
        this.memberData.put(m, data);
    }

    public void setMemberData(String memberName, Array data) {
        StructureMembers.Member m = this.members.findMember(memberName);
        if (m == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        this.setMemberData(m, data);
    }

    public Array getArray(StructureMembers.Member m) {
        return this.memberData.get(m);
    }

    public double getScalarDouble(String memberName) {
        Array data = this.getArray(memberName);
        return data.getDouble(Array.scalarIndex);
    }

    public double getScalarDouble(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return data.getDouble(Array.scalarIndex);
    }

    public double[] getJavaArrayDouble(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return (double[])data.getStorage();
    }

    public float getScalarFloat(String memberName) {
        Array data = this.getArray(memberName);
        return data.getFloat(Array.scalarIndex);
    }

    public float getScalarFloat(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return data.getFloat(Array.scalarIndex);
    }

    public float[] getJavaArrayFloat(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return (float[])data.getStorage();
    }

    public byte getScalarByte(String memberName) {
        Array data = this.getArray(memberName);
        return data.getByte(Array.scalarIndex);
    }

    public byte getScalarByte(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return data.getByte(Array.scalarIndex);
    }

    public byte[] getJavaArrayByte(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return (byte[])data.getStorage();
    }

    public int getScalarInt(String memberName) {
        Array data = this.getArray(memberName);
        return data.getInt(Array.scalarIndex);
    }

    public int getScalarInt(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return data.getInt(Array.scalarIndex);
    }

    public int[] getJavaArrayInt(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return (int[])data.getStorage();
    }

    public short getScalarShort(String memberName) {
        Array data = this.getArray(memberName);
        return data.getShort(Array.scalarIndex);
    }

    public short getScalarShort(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return data.getShort(Array.scalarIndex);
    }

    public short[] getJavaArrayShort(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return (short[])data.getStorage();
    }

    public long getScalarLong(String memberName) {
        Array data = this.getArray(memberName);
        return data.getLong(Array.scalarIndex);
    }

    public long getScalarLong(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return data.getLong(Array.scalarIndex);
    }

    public long[] getJavaArrayLong(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return (long[])data.getStorage();
    }

    public char getScalarChar(String memberName) {
        Array data = this.getArray(memberName);
        return data.getChar(Array.scalarIndex);
    }

    public char getScalarChar(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return data.getChar(Array.scalarIndex);
    }

    public char[] getJavaArrayChar(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return (char[])data.getStorage();
    }

    public String getScalarString(String memberName) {
        return this.getScalarString(this.findMember(memberName));
    }

    public String getScalarString(StructureMembers.Member m) {
        if (m.getDataType() == DataType.STRING) {
            Array data = this.getArray(m);
            return (String)data.getObject(0);
        }
        byte[] ba = this.getJavaArrayByte(m);
        int count = 0;
        for (int i = 0; i < ba.length && 0 != ba[i]; ++i) {
            ++count;
        }
        return new String(ba, 0, count);
    }

    public String[] getJavaArrayString(StructureMembers.Member m) {
        if (m.getDataType() == DataType.STRING) {
            Array data = this.getArray(m);
            int n = m.getSize();
            String[] result = new String[n];
            for (int i = 0; i < result.length; ++i) {
                result[i] = (String)data.getObject(i);
            }
            return result;
        }
        if (m.getDataType() == DataType.CHAR) {
            ArrayChar data = (ArrayChar)this.getArray(m);
            ArrayChar.StringIterator iter = data.getStringIterator();
            String[] result = new String[iter.getNumElems()];
            int count = 0;
            while (iter.hasNext()) {
                result[count++] = iter.next();
            }
            return result;
        }
        throw new IllegalArgumentException("getJavaArrayString: not String DataType :" + m.getDataType());
    }

    public StructureData getScalarStructure(String memberName) {
        return this.getScalarStructure(this.findMember(memberName));
    }

    public StructureData getScalarStructure(StructureMembers.Member m) {
        ArrayStructure data = (ArrayStructure)this.getArray(m);
        return data.getStructureData(0);
    }

    public ArrayStructure getArrayStructure(StructureMembers.Member m) {
        return (ArrayStructure)this.getArray(m);
    }
}

