/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application.utils;

import com.google.gwt.i18n.client.DateTimeFormat;
import java.util.Date;

public final class DateTimeUtils {
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final String DEFAULT_DATE_TIME_FORMAT = "yyyy-MM-dd";
    public static final String FULL_DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final DateTimeFormat defaultDateTimeFormat = DateTimeFormat.getFormat((String)"yyyy-MM-dd");

    private DateTimeUtils() {
    }

    public static final String formatDate(Date date) {
        return DateTimeUtils.formatDate(date, null);
    }

    public static final String formatDate(Date date, String pattern) {
        assert (date != null) : "Undefined date.";
        DateTimeFormat dateTimeFormat = pattern == null || pattern.equals(DEFAULT_DATE_TIME_FORMAT) ? defaultDateTimeFormat : DateTimeFormat.getFormat((String)pattern);
        return dateTimeFormat.format(date);
    }

    private static final String padWithZerosIfNeeded(String value) {
        assert (value != null) : "Missing value";
        return value.length() == 1 ? "0" + value : value;
    }

    public static final String formatDuration(long millis) {
        long durationMillis = millis;
        int hours = (int)(durationMillis / 3600000L);
        int minutes = (int)((durationMillis -= (long)hours * 3600000L) / 60000L);
        int seconds = (int)((durationMillis -= (long)minutes * 60000L) / 1000L);
        durationMillis -= (long)seconds * 1000L;
        StringBuffer buffer = new StringBuffer();
        buffer.append(DateTimeUtils.padWithZerosIfNeeded(Integer.toString(hours))).append(":");
        buffer.append(DateTimeUtils.padWithZerosIfNeeded(Integer.toString(minutes))).append(":");
        buffer.append(DateTimeUtils.padWithZerosIfNeeded(Integer.toString(seconds)));
        return buffer.toString();
    }
}

