/*
 * Decompiled with CFR 0.152.
 */
package eu.basysbio.cisd.dss;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

class DataSetTypeTranslator {
    static final String DATA_SET_TYPES_KEY = "data-set-types";
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, DataSetTypeTranslator.class);
    private final Map<String, String> map = new LinkedHashMap<String, String>();

    DataSetTypeTranslator(Properties properties) {
        String[] types;
        String sequence = PropertyUtils.getMandatoryProperty((Properties)properties, (String)DATA_SET_TYPES_KEY);
        String[] stringArray = types = PropertyParametersUtil.parseItemisedProperty((String)sequence, (String)DATA_SET_TYPES_KEY);
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            String translatedType = properties.getProperty(type);
            if (translatedType == null) {
                translatedType = type.toUpperCase();
                operationLog.warn((Object)("No translation found for data set type '" + type + "' using default translation '" + translatedType + "'."));
            }
            this.map.put(type, translatedType);
            ++n2;
        }
    }

    String translate(String type) {
        String translatedType = this.map.get(type);
        if (translatedType == null) {
            throw new UserFailureException("Unknown data set type: " + type);
        }
        return translatedType;
    }

    Collection<String> getTranslatedDataSetTypes() {
        return this.map.values();
    }
}

