/*
 * Decompiled with CFR 0.152.
 */
package eu.basysbio.cisd.dss;

import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.AbstractTableModelReportingPlugin;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.StringTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewProperty;
import ch.systemsx.cisd.openbis.generic.shared.util.SimpleTableModelBuilder;
import eu.basysbio.cisd.dss.HeaderUtils;
import eu.basysbio.cisd.dss.TimeSeriesPropertyType;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class TimeSeriesPropertiesReportingPlugin
extends AbstractTableModelReportingPlugin {
    private static final long serialVersionUID = 1L;

    public TimeSeriesPropertiesReportingPlugin(Properties properties, File storeRoot) {
        super(properties, storeRoot);
    }

    public TableModel createReport(List<DatasetDescription> datasets, DataSetProcessingContext context) {
        ArrayList<String> headers = new ArrayList<String>();
        SimpleTableModelBuilder builder = new SimpleTableModelBuilder();
        TimeSeriesPropertiesReportingPlugin.addHeader(builder, headers, "CODE");
        TimeSeriesPropertyType[] timeSeriesPropertyTypeArray = HeaderUtils.TIME_SERIES_HEADER_PROPERTIES;
        int n = HeaderUtils.TIME_SERIES_HEADER_PROPERTIES.length;
        int n2 = 0;
        while (n2 < n) {
            TimeSeriesPropertyType pt = timeSeriesPropertyTypeArray[n2];
            TimeSeriesPropertiesReportingPlugin.addHeader(builder, headers, pt.name());
            ++n2;
        }
        for (DatasetDescription dataset : datasets) {
            ArrayList<ISerializableComparable> row = new ArrayList<ISerializableComparable>();
            int i = 0;
            int n3 = headers.size();
            while (i < n3) {
                row.add((ISerializableComparable)new StringTableCell(""));
                ++i;
            }
            TimeSeriesPropertiesReportingPlugin.addTableCellValue(row, headers, "CODE", dataset.getDataSetCode());
            File file = this.getDataSubDir(context.getDirectoryProvider(), dataset);
            List<NewProperty> properies = HeaderUtils.extractHeaderProps(file, true, false, true, new TimeSeriesPropertyType[0]);
            for (NewProperty p : properies) {
                TimeSeriesPropertiesReportingPlugin.addTableCellValue(row, headers, p.getPropertyCode(), p.getValue());
            }
            builder.addRow(row);
        }
        return builder.getTableModel();
    }

    private static void addTableCellValue(List<ISerializableComparable> row, List<String> headers, String key, String value) {
        row.set(headers.indexOf(key), (ISerializableComparable)new StringTableCell(value));
    }

    private static void addHeader(SimpleTableModelBuilder builder, List<String> headers, String title) {
        builder.addHeader(title);
        headers.add(title);
    }
}

