/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.yeastx.mzxml.dto;

import ch.systemsx.cisd.yeastx.mzxml.dto.MzPeaksDTO;
import ch.systemsx.cisd.yeastx.mzxml.dto.MzPrecursorDTO;
import ch.systemsx.cisd.yeastx.utils.XmlUtils;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;

public class MzScanDTO {
    private int number;
    private int level;
    private int peaksCount;
    private String peakPositions;
    private String peakIntensities;
    private String polarity;
    private String scanType;
    private String retentionTime;
    private Double collisionEnergy;
    private Double lowMz;
    private Double highMz;
    private List<MzPrecursorDTO> precursors;
    private MzPeaksDTO peaks;

    @XmlAttribute(name="num", required=true)
    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    @XmlAttribute(name="msLevel", required=true)
    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    @XmlAttribute(name="peaksCount", required=true)
    public int getPeaksCount() {
        return this.peaksCount;
    }

    public void setPeaksCount(int peaksCount) {
        this.peaksCount = peaksCount;
    }

    @XmlAttribute(name="polarity")
    public String getPolarity() {
        return this.polarity;
    }

    public void setPolarity(String polarity) {
        this.polarity = polarity;
    }

    @XmlAttribute(name="scanType")
    public String getScanType() {
        return this.scanType;
    }

    public void setScanType(String scanType) {
        this.scanType = scanType;
    }

    @XmlAttribute(name="retentionTime")
    public String getRetentionTime() {
        return this.retentionTime;
    }

    public void setRetentionTime(String retentionTime) {
        this.retentionTime = retentionTime;
    }

    @XmlAttribute(name="collisionEnergy")
    public Double getCollisionEnergy() {
        return this.collisionEnergy;
    }

    public void setCollisionEnergy(Double collisionEnergy) {
        this.collisionEnergy = collisionEnergy;
    }

    @XmlAttribute(name="lowMz")
    public Double getLowMz() {
        return this.lowMz;
    }

    public void setLowMz(Double lowMz) {
        this.lowMz = lowMz;
    }

    @XmlAttribute(name="highMz")
    public Double getHighMz() {
        return this.highMz;
    }

    public void setHighMz(Double highMz) {
        this.highMz = highMz;
    }

    @XmlElement(name="precursorMz", namespace="http://sashimi.sourceforge.net/schema_revision/mzXML_3.1")
    public List<MzPrecursorDTO> getPrecursors() {
        return this.precursors;
    }

    public void setPrecursors(List<MzPrecursorDTO> precursors) {
        this.precursors = precursors;
    }

    @XmlElement(name="peaks", namespace="http://sashimi.sourceforge.net/schema_revision/mzXML_3.1")
    public MzPeaksDTO getPeaksBytes() {
        return this.peaks;
    }

    public void setPeaksBytes(MzPeaksDTO peaks) {
        this.peaks = peaks;
    }

    public Double getRetentionTimeInSeconds() {
        return XmlUtils.tryAsSeconds(this.retentionTime);
    }

    public final String getPeakPositions() {
        this.initPeaks();
        return this.peakPositions;
    }

    public final String getPeakIntensities() {
        this.initPeaks();
        return this.peakIntensities;
    }

    private void initPeaks() {
        if (this.peakPositions == null) {
            float[] floats = XmlUtils.asFloats(this.peaks.getPeaks());
            StringBuilder positions = new StringBuilder();
            StringBuilder intensities = new StringBuilder();
            int i = 0;
            while (i < floats.length) {
                if (i % 2 == 0) {
                    this.addTo(positions, floats[i]);
                } else {
                    this.addTo(intensities, floats[i]);
                }
                ++i;
            }
            this.peakPositions = positions.toString();
            this.peakIntensities = intensities.toString();
        }
    }

    private void addTo(StringBuilder builder, float value) {
        if (builder.length() > 0) {
            builder.append(", ");
        }
        builder.append(value);
    }
}

