/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.utils;

import ch.systemsx.cisd.common.properties.ExtendedProperties;
import ch.systemsx.cisd.common.servlet.AbstractCrossOriginFilter;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DssPropertyParametersUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DssCrossOriginFilter
extends AbstractCrossOriginFilter {
    private List<String> ownDomains;
    private List<String> trustedDomains;

    @Override
    protected List<String> getOwnDomains() {
        this.initializeIfNeeded();
        return Collections.unmodifiableList(this.ownDomains);
    }

    @Override
    protected List<String> getConfiguredTrustedDomains() {
        this.initializeIfNeeded();
        return Collections.unmodifiableList(this.trustedDomains);
    }

    private void initializeIfNeeded() {
        if (this.ownDomains != null) {
            return;
        }
        ExtendedProperties properties = DssPropertyParametersUtil.loadServiceProperties();
        String dssUrl = DssPropertyParametersUtil.getDownloadUrl(properties);
        String openBisUrl = DssPropertyParametersUtil.getOpenBisServerUrl(properties);
        this.ownDomains = Arrays.asList(openBisUrl, dssUrl);
        this.trustedDomains = ServiceProvider.getOpenBISService().getTrustedCrossOriginDomains();
    }
}

