/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.parser;

import ch.systemsx.cisd.common.collection.CollectionStyle;
import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.parser.ParserException;
import java.util.Set;

public final class MandatoryPropertyMissingException
extends ParserException {
    private static final String MISSING_PROPERTY_COLUMN = "Mandatory column(s) %s are missing (mandatory columns are %s).";
    private static final String MISSING_PROPERTY_VALUE = "Missing value for the mandatory column '%s'.";
    private static final long serialVersionUID = 1L;

    public MandatoryPropertyMissingException(String propertyField) {
        super(String.format(MISSING_PROPERTY_VALUE, propertyField));
    }

    public MandatoryPropertyMissingException(Set<String> mandatoryFields, Set<String> missingMandatoryProperties) {
        super(MandatoryPropertyMissingException.createMessage(missingMandatoryProperties, mandatoryFields));
    }

    private static final String createMessage(Set<String> missingMandatoryProperties, Set<String> mandatoryFields) {
        assert (missingMandatoryProperties != null) : "Missing mandatory properties can not be null.";
        assert (missingMandatoryProperties.size() > 0) : "No reason to throw this exception.";
        return String.format(MISSING_PROPERTY_COLUMN, MandatoryPropertyMissingException.toString(missingMandatoryProperties), MandatoryPropertyMissingException.toString(mandatoryFields));
    }

    static final String toString(Set<String> set) {
        return CollectionUtils.abbreviate(set, -1, CollectionStyle.SINGLE_QUOTE_BOUNDARY);
    }
}

