/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.translator;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseInstance;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PersonRole;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PersonRoles;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.dto.RoleAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.translator.DatabaseInstanceTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.SpaceTranslator;
import java.util.ArrayList;
import java.util.Collection;

public class PersonRolesTranslator {
    private PersonRolesTranslator() {
    }

    public static final PersonRoles translate(Collection<RoleAssignmentPE> roleAssignments) {
        ArrayList<PersonRole> personRoles = new ArrayList<PersonRole>();
        if (roleAssignments != null) {
            for (RoleAssignmentPE roleAssignment : roleAssignments) {
                PersonRole personRole = PersonRolesTranslator.translate(roleAssignment);
                if (personRole == null) continue;
                personRoles.add(personRole);
            }
        }
        return new PersonRoles(personRoles);
    }

    private static final PersonRole translate(RoleAssignmentPE roleAssignment) {
        RoleWithHierarchy role;
        if (roleAssignment == null) {
            return null;
        }
        if (roleAssignment.getDatabaseInstance() != null) {
            role = RoleWithHierarchy.valueOf(RoleWithHierarchy.RoleLevel.INSTANCE, roleAssignment.getRole());
        } else if (roleAssignment.getSpace() != null) {
            role = RoleWithHierarchy.valueOf(RoleWithHierarchy.RoleLevel.SPACE, roleAssignment.getRole());
        } else {
            throw new IllegalArgumentException("Database instance and space cannot be both null");
        }
        DatabaseInstance databaseInstance = DatabaseInstanceTranslator.translate(roleAssignment.getDatabaseInstance());
        Space space = SpaceTranslator.translate(roleAssignment.getSpace());
        return new PersonRole(role, databaseInstance, space);
    }
}

