/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.io;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;

public class PropertyIOUtils {
    public static void loadAndAppendProperties(Properties properties, File propertiesFile) {
        List<String> lines = FileUtilities.loadToStringList(propertiesFile);
        int i = 0;
        while (i < lines.size()) {
            String line = lines.get(i);
            if (line.length() != 0 && !line.startsWith("#")) {
                int indexOfEqualSymbol = line.indexOf(61);
                if (indexOfEqualSymbol < 0) {
                    throw new UserFailureException("Missing '=' in line " + (i + 1) + " of properties file '" + propertiesFile + "': " + line);
                }
                String key = line.substring(0, indexOfEqualSymbol).trim();
                String value = line.substring(indexOfEqualSymbol + 1).trim();
                properties.setProperty(key, value);
            }
            ++i;
        }
    }

    public static Properties loadProperties(File propertiesFile) {
        Properties properties = new Properties();
        PropertyIOUtils.loadAndAppendProperties(properties, propertiesFile);
        return properties;
    }

    public static final Properties loadProperties(InputStream is, String resourceName) {
        assert (is != null) : "No input stream specified";
        Properties properties = new Properties();
        try {
            properties.load(is);
            PropertyUtils.trimProperties(properties);
            Properties properties2 = properties;
            return properties2;
        }
        catch (Exception ex) {
            String msg = String.format("Could not load the properties from given resource '%s'.", resourceName);
            throw new ConfigurationFailureException(msg, ex);
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }

    public static final Properties loadProperties(String propertiesFilePath) {
        try {
            return PropertyIOUtils.loadProperties(new FileInputStream(propertiesFilePath), propertiesFilePath);
        }
        catch (FileNotFoundException ex) {
            String msg = String.format("Properties file '%s' not found.", propertiesFilePath);
            throw new ConfigurationFailureException(msg, ex);
        }
    }

    public static void saveProperties(File propertiesFile, Properties properties) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            builder.append(key);
            builder.append(" = ");
            builder.append(value);
            builder.append('\n');
        }
        FileUtilities.writeToFile(propertiesFile, builder.toString());
    }
}

