/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.parser;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.common.parser.ILine;
import ch.systemsx.cisd.common.parser.Line;
import ch.systemsx.cisd.common.parser.filter.AlwaysAcceptLineFilter;
import ch.systemsx.cisd.common.parser.filter.ILineFilter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;

public final class ParserUtilities {
    private ParserUtilities() {
    }

    public static final ILine<String> tryGetFirstAcceptedLine(String content, ILineFilter lineFilterOrNull) {
        LineSplitter splitter = new LineSplitter(content, lineFilterOrNull);
        try {
            ILine<String> iLine = splitter.tryNextLine();
            return iLine;
        }
        finally {
            splitter.close();
        }
    }

    public static final ILine<String> tryGetFirstAcceptedLine(File file, ILineFilter lineFilterOrNull) {
        LineSplitter splitter = new LineSplitter(file, lineFilterOrNull);
        try {
            ILine<String> iLine = splitter.tryNextLine();
            return iLine;
        }
        finally {
            splitter.close();
        }
    }

    public static class LineSplitter
    implements Closeable {
        private final LineIterator lineIterator;
        private final ILineFilter lineFilter;
        private int lineNumber;

        public LineSplitter(String content) {
            this(content, null);
        }

        public LineSplitter(String content, ILineFilter lineFilterOrNull) {
            assert (content != null) : "Unspecified context.";
            StringReader reader = new StringReader(content);
            this.lineIterator = IOUtils.lineIterator(reader);
            this.lineFilter = LineSplitter.getLineFilter(lineFilterOrNull);
        }

        public LineSplitter(File file) throws IOExceptionUnchecked {
            this(file, null);
        }

        public LineSplitter(File file, ILineFilter lineFilterOrNull) throws IOExceptionUnchecked {
            assert (file != null) : "Given file must not be null.";
            try {
                this.lineIterator = FileUtils.lineIterator(file);
                this.lineFilter = LineSplitter.getLineFilter(lineFilterOrNull);
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        }

        private static final ILineFilter getLineFilter(ILineFilter lineFilterOrNull) {
            return lineFilterOrNull == null ? AlwaysAcceptLineFilter.INSTANCE : lineFilterOrNull;
        }

        @Override
        public void close() {
            this.lineIterator.close();
        }

        public ILine<String> tryNextLine() {
            int line = this.lineNumber;
            while (this.lineIterator.hasNext()) {
                String nextLine = this.lineIterator.nextLine();
                Line ret = new Line(line, nextLine);
                if (this.lineFilter.acceptLine(ret)) {
                    this.lineNumber = line + 1;
                    return ret;
                }
                ++line;
            }
            return null;
        }
    }
}

