/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.string;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LogUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

class ReflectionStringTraverser {
    private static final Logger log = LogFactory.getLogger(LogCategory.OPERATION, ReflectionStringTraverser.class);
    private static final Set<Class<?>> primitiveTypes = new HashSet<Class>(Arrays.asList(Boolean.class, Boolean.TYPE, Character.class, Character.TYPE, Byte.class, Byte.TYPE, Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE, Void.class, Void.TYPE, Date.class));
    private final ReflectionFieldVisitor visitor;
    private final boolean isDeep;
    private final Set<Object> seenObjects = new HashSet<Object>();

    public static void traverseDeep(Object object, ReflectionFieldVisitor fieldVisitor) {
        Class<?> clazz = object.getClass();
        new ReflectionStringTraverser(fieldVisitor, true).traverseMutable(object, clazz);
    }

    public static void traverseShallow(Object object, ReflectionFieldVisitor fieldVisitor) {
        Class<?> clazz = object.getClass();
        new ReflectionStringTraverser(fieldVisitor, false).traverseMutable(object, clazz);
    }

    private void traverseMutable(Object object, Class<?> clazz) {
        if (this.seenObjects.contains(object)) {
            return;
        }
        this.seenObjects.add(object);
        if (this.isPrimitive(clazz)) {
            return;
        }
        if (!this.isMutable(object)) {
            LogUtils.logErrorWithFailingAssertion(log, "Cannot traverse primitive collections or primitives " + object);
            return;
        }
        if (ReflectionStringTraverser.isArrayList(object)) {
            this.traverseArrayList(object);
        } else if (clazz.isArray()) {
            this.traverseArray(clazz);
        } else if (ReflectionStringTraverser.isCollection(object)) {
            this.traverseMutableCollection((Collection)object);
        } else {
            this.traverseFields(object, clazz);
        }
    }

    private boolean isPrimitive(Class<?> clazz) {
        return primitiveTypes.contains(clazz);
    }

    private ReflectionStringTraverser(ReflectionFieldVisitor fieldVisitor, boolean isDeep) {
        this.visitor = fieldVisitor;
        this.isDeep = isDeep;
    }

    private void traverseFields(Object object, Class<?> clazz) {
        Field[] fields;
        if (object == null) {
            return;
        }
        Field[] fieldArray = fields = this.getAllFields(clazz);
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            int modifiers = field.getModifiers();
            if (!Modifier.isFinal(modifiers) && !Modifier.isStatic(modifiers)) {
                try {
                    this.traverseField(object, field);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    LogUtils.logErrorWithFailingAssertion(log, "Failed accessing field <" + field.getName() + "> of " + object.getClass() + ":\n\t" + object);
                }
            }
            ++n2;
        }
    }

    private Field[] getAllFields(Class<?> clazz) {
        HashSet<Field> result = new HashSet<Field>();
        Class<?> currentClass = clazz;
        while (currentClass != null) {
            Field[] fieldArray = currentClass.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                result.add(field);
                ++n2;
            }
            currentClass = currentClass.getSuperclass();
        }
        return result.toArray(new Field[result.size()]);
    }

    private void traverseField(Object object, Field field) throws IllegalAccessException {
        if (log.isDebugEnabled()) {
            log.debug("Traverse field <" + field.getName() + "> of " + object.getClass() + ":\n\t" + object);
        }
        field.setAccessible(true);
        Object fieldValue = field.get(object);
        if (fieldValue == null) {
            return;
        }
        Class<?> clazz = fieldValue.getClass();
        if (clazz.isArray() && this.isDeep) {
            this.traverseArray(fieldValue);
        } else if (ReflectionStringTraverser.isCollection(fieldValue) && this.isDeep) {
            this.traverseCollectionField(object, field, (Collection)fieldValue);
        } else {
            if (this.isPrimitive(clazz)) {
                return;
            }
            if (ReflectionStringTraverser.isString(fieldValue)) {
                String newValue = this.visitor.tryVisit((String)fieldValue, object, field);
                if (newValue != null) {
                    field.set(object, newValue);
                }
            } else if (this.isDeep) {
                if (this.seenObjects.contains(fieldValue)) {
                    return;
                }
                this.seenObjects.add(fieldValue);
                this.traverseFields(fieldValue, clazz);
            }
        }
    }

    private void traverseCollectionField(Object object, Field field, Collection<?> collection) throws IllegalArgumentException, IllegalAccessException {
        if (collection.size() == 0) {
            return;
        }
        Class<?> componentType = ReflectionStringTraverser.tryFigureElementClass(collection);
        if (componentType == null || componentType.isPrimitive()) {
            return;
        }
        if (ReflectionStringTraverser.isStringClass(componentType)) {
            Collection<String> newCollection = this.visitStringCollection(collection);
            field.set(object, newCollection);
        } else {
            this.traverseMutableCollection(collection);
        }
    }

    private void traverseMutableCollection(Collection<?> collection) {
        for (Object element : collection) {
            this.traverseMutable(element, element.getClass());
        }
    }

    private boolean isMutable(Object element) {
        return !ReflectionStringTraverser.isString(element) && !element.getClass().isPrimitive() && (!ReflectionStringTraverser.isStringCollection(element) || ReflectionStringTraverser.isArrayList(element));
    }

    private Collection<String> visitStringCollection(Object collection) {
        Collection<String> castedSource = ReflectionStringTraverser.asStringCollection(collection);
        Collection<String> newCollection = ReflectionStringTraverser.createEmptyCollection(castedSource);
        for (String element : castedSource) {
            String newElement = this.tryVisitString(element);
            newCollection.add(newElement != null ? newElement : element);
        }
        return newCollection;
    }

    private void traverseArray(Object array) {
        int length = Array.getLength(array);
        Class<?> componentType = array.getClass().getComponentType();
        if (componentType.isPrimitive()) {
            return;
        }
        int index = 0;
        while (index < length) {
            Object element = Array.get(array, index);
            if (element != null) {
                if (ReflectionStringTraverser.isString(element)) {
                    this.visitStringArrayElement(array, index, (String)element, componentType);
                } else if (ReflectionStringTraverser.isStringCollection(element)) {
                    this.visitStringCollectionArrayElement(array, index, element);
                } else {
                    this.traverseMutable(element, componentType);
                }
            }
            ++index;
        }
    }

    private void traverseArrayList(Object arrayListObject) {
        ArrayList arrayList = (ArrayList)arrayListObject;
        int length = arrayList.size();
        int index = 0;
        while (index < length) {
            Object element = arrayList.get(index);
            if (element != null) {
                if (element.getClass().isPrimitive()) {
                    return;
                }
                if (ReflectionStringTraverser.isString(element)) {
                    this.visitStringArrayListElement(arrayList, index, (String)element);
                } else if (ReflectionStringTraverser.isStringCollection(element)) {
                    this.visitStringCollectionArrayListElement(arrayList, index, element);
                } else {
                    this.traverseMutable(element, element.getClass());
                }
            }
            ++index;
        }
    }

    private void visitStringCollectionArrayElement(Object array, int index, Object collection) {
        Collection<String> newCollection = this.visitStringCollection(collection);
        Array.set(array, index, newCollection);
    }

    private void visitStringCollectionArrayListElement(ArrayList arrayList, int index, Object collection) {
        Collection<String> newCollection = this.visitStringCollection(collection);
        arrayList.set(index, newCollection);
    }

    private void visitStringArrayElement(Object array, int index, String element, Class<?> componentType) {
        String newElement = this.tryVisitString(element);
        if (newElement != null) {
            Array.set(array, index, newElement);
        }
    }

    private void visitStringArrayListElement(ArrayList arrayList, int index, String element) {
        String newElement = this.tryVisitString(element);
        if (newElement != null) {
            arrayList.set(index, newElement);
        }
    }

    private String tryVisitString(String element) {
        return this.visitor.tryVisit(element, element, null);
    }

    private static Class<?> tryFigureElementClass(Collection<?> collection) {
        for (Object elem : collection) {
            if (elem == null) continue;
            return elem.getClass();
        }
        return null;
    }

    private static Collection<String> asStringCollection(Object collection) {
        return (Collection)collection;
    }

    private static <T> Collection<T> createEmptyCollection(Collection<T> collection) {
        Class<?> clazz = collection.getClass();
        if (List.class.isAssignableFrom(clazz)) {
            return new ArrayList();
        }
        if (Set.class.isAssignableFrom(clazz)) {
            return new LinkedHashSet();
        }
        throw new IllegalStateException("Do not know how to create a collection of type " + clazz.getName());
    }

    private static boolean isString(Object object) {
        return object instanceof String;
    }

    private static boolean isStringClass(Class<?> clazz) {
        return String.class.isAssignableFrom(clazz);
    }

    private static boolean isStringCollection(Collection<?> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        Class<?> elementClass = ReflectionStringTraverser.tryFigureElementClass(collection);
        return elementClass != null && ReflectionStringTraverser.isStringClass(elementClass);
    }

    private static boolean isStringCollection(Object o) {
        return ReflectionStringTraverser.isCollection(o) && ReflectionStringTraverser.isStringCollection((Collection)o);
    }

    private static boolean isCollection(Object o) {
        return o instanceof Collection;
    }

    private static boolean isArrayList(Object o) {
        return o instanceof ArrayList;
    }

    public static interface ReflectionFieldVisitor {
        public String tryVisit(String var1, Object var2, Field var3);
    }
}

