/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.rules.process;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.adaptator.impl.XMLElementImpl;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.rules.Condition;
import java.util.List;

public class PackselectionCondition
extends Condition {
    private static final long serialVersionUID = 9193011814966195963L;
    protected String packid;

    @Override
    public void readFromXML(IXMLElement xmlcondition) throws Exception {
        try {
            this.packid = xmlcondition.getFirstChildNamed("packid").getContent();
        }
        catch (Exception e) {
            throw new Exception("Missing nested element in condition \"" + this.getId() + "\"");
        }
    }

    private boolean isTrue(List<Pack> selectedpacks) {
        if (selectedpacks != null) {
            for (Pack selectedpack : selectedpacks) {
                if (!this.packid.equals(selectedpack.id)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isTrue() {
        return this.isTrue(this.getInstallData().getSelectedPacks());
    }

    @Override
    public String getDependenciesDetails() {
        StringBuffer details = new StringBuffer();
        details.append(this.getId());
        details.append("depends on the selection of pack <b>");
        details.append(this.packid);
        details.append("</b><br/>");
        return details.toString();
    }

    @Override
    public void makeXMLData(IXMLElement conditionRoot) {
        XMLElementImpl packel = new XMLElementImpl("packid", conditionRoot);
        packel.setContent(this.packid);
        conditionRoot.addChild(packel);
    }

    public void setPackid(String packid) {
        this.packid = packid;
    }
}

