/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.event;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.PackFile;
import com.izforge.izpack.api.data.ResourceManager;
import com.izforge.izpack.api.exception.InstallerException;
import com.izforge.izpack.api.handler.AbstractUIProgressHandler;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.event.BSFAction;
import com.izforge.izpack.event.SimpleInstallerListener;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.ExtendedUIProgressHandler;
import com.izforge.izpack.util.helper.SpecHelper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class BSFInstallerListener
extends SimpleInstallerListener {
    public static final String SPEC_FILE_NAME = "BSFActionsSpec.xml";
    private HashMap<String, ArrayList<BSFAction>> actions = null;
    private ArrayList<BSFAction> uninstActions = null;
    private String currentPack = null;
    private AutomatedInstallData installdata = null;
    private VariableSubstitutor variableSubstitutor;
    private UninstallData uninstallData;

    public BSFInstallerListener(VariableSubstitutor variableSubstitutor, UninstallData uninstallData) {
        super(true);
        this.variableSubstitutor = variableSubstitutor;
        this.actions = new HashMap();
        this.uninstActions = new ArrayList();
        this.uninstallData = uninstallData;
    }

    @Override
    public void beforePacks(AutomatedInstallData idata, Integer npacks, AbstractUIProgressHandler handler) throws Exception {
        if (this.installdata == null) {
            this.installdata = idata;
        }
        super.beforePacks(idata, npacks, handler);
        this.getSpecHelper().readSpec(SPEC_FILE_NAME, this.variableSubstitutor);
        if (this.getSpecHelper().getSpec() == null) {
            return;
        }
        for (Pack pack : idata.getSelectedPacks()) {
            IXMLElement packElement = this.getSpecHelper().getPackForName(pack.name);
            if (packElement == null) continue;
            ArrayList<BSFAction> packActions = new ArrayList<BSFAction>();
            List<IXMLElement> scriptEntries = packElement.getChildrenNamed("script");
            if (scriptEntries != null && scriptEntries.size() >= 1) {
                for (IXMLElement scriptEntry : scriptEntries) {
                    BSFAction action = this.readAction(scriptEntry, idata);
                    if (action == null) continue;
                    packActions.add(action);
                    String script = action.getScript().toLowerCase();
                    if (!script.contains("beforedelete") && !script.contains("afterdelete") && !script.contains("beforedeletion") && !script.contains("afterdeletion")) continue;
                    this.uninstActions.add(action);
                }
                if (packActions.size() > 0) {
                    this.setProgressBarCaller();
                }
            }
            this.actions.put(pack.name, packActions);
        }
        for (Pack pack : idata.getAvailablePacks()) {
            String currentPack = pack.name;
            this.performAllActions(currentPack, "beforepacks", null, new Object[]{idata, npacks, handler});
        }
    }

    @Override
    public void afterPack(Pack pack, Integer i, AbstractUIProgressHandler handler) throws Exception {
        this.performAllActions(pack.name, "afterpack", handler, new Object[]{pack, i, handler});
        this.currentPack = null;
    }

    @Override
    public void afterPacks(AutomatedInstallData idata, AbstractUIProgressHandler handler) throws Exception {
        if (this.informProgressBar()) {
            handler.nextStep(this.getMsg("BSFAction.pack"), this.getProgressBarCallerId(), this.getActionCount(idata));
        }
        for (Pack selectedPack : idata.getSelectedPacks()) {
            String currentPack = selectedPack.name;
            this.performAllActions(currentPack, "afterpacks", handler, new Object[]{idata, handler});
        }
        if (this.uninstActions.size() > 0) {
            this.uninstallData.addAdditionalData("bsfActions", this.uninstActions);
        }
        this.installdata = null;
    }

    @Override
    public void beforePack(Pack pack, Integer i, AbstractUIProgressHandler handler) throws Exception {
        this.currentPack = pack.name;
        this.performAllActions(pack.name, "beforepack", handler, new Object[]{pack, i, handler});
    }

    @Override
    public void afterDir(File file, PackFile pack) throws Exception {
        this.performAllActions(this.currentPack, "afterdir", null, new Object[]{file, pack});
    }

    @Override
    public void afterFile(File file, PackFile pack) throws Exception {
        this.performAllActions(this.currentPack, "afterfile", null, new Object[]{file, pack});
    }

    @Override
    public void beforeDir(File file, PackFile pack) throws Exception {
        this.performAllActions(this.currentPack, "beforedir", null, new Object[]{file, pack});
    }

    @Override
    public void beforeFile(File file, PackFile pack) throws Exception {
        this.performAllActions(this.currentPack, "beforefile", null, new Object[]{file, pack});
    }

    @Override
    public boolean isFileListener() {
        return true;
    }

    protected ArrayList<BSFAction> getActions(String packName) {
        if (this.actions == null) {
            return null;
        }
        return this.actions.get(packName);
    }

    private int getActionCount(AutomatedInstallData idata) {
        int retval = 0;
        for (Pack selectedPack : idata.getSelectedPacks()) {
            String currentPack = selectedPack.name;
            ArrayList<BSFAction> actList = this.getActions(currentPack);
            if (actList == null) continue;
            retval += actList.size();
        }
        return retval;
    }

    private void performAllActions(String packName, String order, AbstractUIProgressHandler handler, Object[] callParams) throws InstallerException {
        ArrayList<BSFAction> actList = this.getActions(packName);
        if (actList == null || actList.size() == 0) {
            return;
        }
        Debug.trace("******* Executing all " + order + " actions of " + packName + " ...");
        for (BSFAction act : actList) {
            if (this.informProgressBar() && handler != null && handler instanceof ExtendedUIProgressHandler && order.equals("afterpacks")) {
                ((ExtendedUIProgressHandler)((Object)handler)).progress(act.getMessageID() != null ? this.getMsg(act.getMessageID()) : "");
            }
            try {
                if ("beforepacks".equalsIgnoreCase(order)) {
                    act.init();
                }
                act.execute(order, callParams, this.installdata);
                if (!"afterpacks".equalsIgnoreCase(order)) continue;
                act.destroy();
            }
            catch (Exception e) {
                throw new InstallerException(e);
            }
        }
    }

    private BSFAction readAction(IXMLElement element, AutomatedInstallData idata) throws InstallerException {
        BSFAction action;
        block18: {
            action = new BSFAction();
            String src = element.getAttribute("src");
            if (src != null) {
                InputStream is = null;
                InputStream subis = null;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    try {
                        byte[] buf = new byte[10240];
                        int read = 0;
                        is = ResourceManager.getInstance().getInputStream(src);
                        subis = new SpecHelper().substituteVariables(is, this.variableSubstitutor);
                        while ((read = subis.read(buf, 0, 10240)) != -1) {
                            baos.write(buf, 0, read);
                        }
                        action.setScript(new String(baos.toByteArray()));
                        break block18;
                    }
                    catch (Exception e) {
                        throw new InstallerException(e);
                    }
                }
                finally {
                    try {
                        if (subis != null) {
                            subis.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            String script = element.getContent();
            if (script == null) {
                script = "";
            }
            action.setScript(script);
        }
        String language = element.getAttribute("language");
        action.setLanguage(language);
        return action;
    }
}

