/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.data;

import com.izforge.izpack.api.data.AutomatedInstallData;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.api.merge.Mergeable;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.data.CustomData;
import com.izforge.izpack.data.ExecutableFile;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.merge.resolve.PathResolver;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.PrivilegedRunner;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarException;
import java.util.jar.JarOutputStream;

public class UninstallDataWriter {
    private static final String UNINSTALLER_CONDITION = "UNINSTALLER_CONDITION";
    private static final String LOGFILE_PATH = "InstallerFrame.logfilePath";
    private VariableSubstitutor variableSubstitutor;
    private UninstallData udata;
    private AutomatedInstallData installdata;
    private PathResolver pathResolver;
    private BufferedOutputStream bos;
    private FileOutputStream out;
    private JarOutputStream outJar;
    private RulesEngine rules;

    public UninstallDataWriter(VariableSubstitutor variableSubstitutor, UninstallData udata, AutomatedInstallData installdata, PathResolver pathResolver, RulesEngine rules) {
        this.variableSubstitutor = variableSubstitutor;
        this.udata = udata;
        this.installdata = installdata;
        this.pathResolver = pathResolver;
        this.rules = rules;
    }

    public boolean write() {
        List<String> files;
        BufferedWriter extLogWriter;
        block5: {
            block4: {
                try {
                    if (this.isUninstallShouldBeWriten()) break block4;
                    return false;
                }
                catch (Exception err) {
                    err.printStackTrace();
                    return false;
                }
            }
            extLogWriter = this.getExternLogFile(this.installdata);
            this.createOutputJar();
            files = this.udata.getUninstalableFilesList();
            if (this.outJar != null) break block5;
            return true;
        }
        System.out.println("[ Writing the uninstaller data ... ]");
        this.writeJarSkeleton(this.installdata, this.pathResolver, this.outJar);
        this.writeFilesLog(this.installdata, extLogWriter, files, this.outJar);
        this.writeUninstallerJarFileLog(this.udata, this.outJar);
        this.writeExecutables(this.udata, this.outJar);
        this.writeAdditionalUninstallData(this.udata, this.outJar);
        this.writeScriptFiles(this.udata, this.outJar);
        this.outJar.flush();
        this.outJar.close();
        this.bos.close();
        this.out.close();
        return true;
    }

    public boolean isUninstallShouldBeWriten() {
        if (!this.installdata.getInfo().isWriteUninstaller()) {
            return false;
        }
        String uninstallerCondition = this.installdata.getInfo().getUninstallerCondition();
        if (uninstallerCondition == null) {
            return true;
        }
        if (uninstallerCondition.length() > 0) {
            return true;
        }
        return this.rules.isConditionTrue(uninstallerCondition);
    }

    private BufferedWriter getExternLogFile(AutomatedInstallData installdata) {
        String logfile = installdata.getVariable(LOGFILE_PATH);
        BufferedWriter extLogWriter = null;
        if (logfile != null) {
            File outFile;
            if (logfile.toLowerCase().startsWith("default")) {
                logfile = String.valueOf(installdata.getInfo().getUninstallerPath()) + "/install.log";
            }
            if (!(outFile = new File(logfile = IoHelper.translatePath(logfile, this.variableSubstitutor))).getParentFile().exists()) {
                outFile.getParentFile().mkdirs();
            }
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(outFile);
            }
            catch (FileNotFoundException e) {
                Debug.trace("Cannot create logfile!");
                Debug.error(e);
            }
            if (out != null) {
                extLogWriter = new BufferedWriter(new OutputStreamWriter(out));
            }
        }
        return extLogWriter;
    }

    /*
     * Unable to fully structure code
     */
    private void writeFilesLog(AutomatedInstallData installdata, BufferedWriter extLogWriter, List<String> files, JarOutputStream outJar) throws IOException {
        block2: {
            outJar.putNextEntry(new JarEntry("install.log"));
            logWriter = new BufferedWriter(new OutputStreamWriter(outJar));
            logWriter.write(installdata.getInstallPath());
            logWriter.newLine();
            iter = files.iterator();
            if (extLogWriter == null) ** GOTO lbl23
            while (iter.hasNext()) {
                txt = iter.next();
                logWriter.write(txt);
                extLogWriter.write(txt);
                if (!iter.hasNext()) continue;
                logWriter.newLine();
                extLogWriter.newLine();
            }
            logWriter.flush();
            extLogWriter.flush();
            extLogWriter.close();
            break block2;
lbl-1000:
            // 1 sources

            {
                txt = iter.next();
                logWriter.write(txt);
                if (!iter.hasNext()) continue;
                logWriter.newLine();
lbl23:
                // 3 sources

                ** while (iter.hasNext())
            }
lbl24:
            // 1 sources

            logWriter.flush();
        }
        outJar.closeEntry();
    }

    private void writeExecutables(UninstallData udata, JarOutputStream outJar) throws IOException {
        outJar.putNextEntry(new JarEntry("executables"));
        ObjectOutputStream execStream = new ObjectOutputStream(outJar);
        execStream.writeInt(udata.getExecutablesList().size());
        for (ExecutableFile file : udata.getExecutablesList()) {
            execStream.writeObject(file);
        }
        execStream.flush();
        outJar.closeEntry();
    }

    private void writeUninstallerJarFileLog(UninstallData udata, JarOutputStream outJar) throws IOException {
        outJar.putNextEntry(new JarEntry("jarlocation.log"));
        BufferedWriter logWriter = new BufferedWriter(new OutputStreamWriter(outJar));
        logWriter.write(udata.getUninstallerJarFilename());
        logWriter.newLine();
        logWriter.write(udata.getUninstallerPath());
        logWriter.flush();
        outJar.closeEntry();
    }

    private void writeScriptFiles(UninstallData udata, JarOutputStream outJar) throws IOException {
        ArrayList<String> unInstallScripts = udata.getUninstallScripts();
        int idx = 0;
        for (String unInstallScript : unInstallScripts) {
            outJar.putNextEntry(new JarEntry("rootscript" + Integer.toString(idx)));
            ObjectOutputStream rootStream = new ObjectOutputStream(outJar);
            rootStream.writeUTF(unInstallScript);
            rootStream.flush();
            outJar.closeEntry();
            ++idx;
        }
    }

    private void writeAdditionalUninstallData(UninstallData udata, JarOutputStream outJar) throws IOException {
        Map<String, Object> additionalData = udata.getAdditionalData();
        if (additionalData != null && !additionalData.isEmpty()) {
            HashSet<String> exist = new HashSet<String>();
            for (String key : additionalData.keySet()) {
                int bytesInBuffer;
                long bytesCopied;
                byte[] buffer;
                Object contents = additionalData.get(key);
                if ("__uninstallLibs__".equals(key)) {
                    for (Object o : (List)contents) {
                        String nativeLibName = (String)((List)o).get(0);
                        buffer = new byte[5120];
                        bytesCopied = 0L;
                        outJar.putNextEntry(new JarEntry("/com/izforge/izpack/bin/native/" + nativeLibName));
                        InputStream in = this.getClass().getResourceAsStream("/com/izforge/izpack/bin/native/" + nativeLibName);
                        while ((bytesInBuffer = in.read(buffer)) != -1) {
                            outJar.write(buffer, 0, bytesInBuffer);
                            bytesCopied += (long)bytesInBuffer;
                        }
                        outJar.closeEntry();
                    }
                    continue;
                }
                if ("uninstallerListeners".equals(key) || "uninstallerJars".equals(key)) {
                    ArrayList<String> subContents = new ArrayList<String>();
                    for (Object o : (List)contents) {
                        buffer = new byte[5120];
                        bytesCopied = 0L;
                        CustomData customData = (CustomData)o;
                        if (customData.listenerName != null) {
                            subContents.add(customData.listenerName);
                        }
                        for (String content : customData.contents) {
                            if (exist.contains(content)) continue;
                            exist.add(content);
                            try {
                                outJar.putNextEntry(new JarEntry(content));
                            }
                            catch (JarException je) {
                                Debug.trace("JarException in writing custom data: " + je.getMessage());
                                continue;
                            }
                            InputStream in = this.getClass().getResourceAsStream("/" + content);
                            if (in != null) {
                                while ((bytesInBuffer = in.read(buffer)) != -1) {
                                    outJar.write(buffer, 0, bytesInBuffer);
                                    bytesCopied += (long)bytesInBuffer;
                                }
                            } else {
                                Debug.trace("custom data not found: " + content);
                            }
                            outJar.closeEntry();
                        }
                    }
                    outJar.putNextEntry(new JarEntry(key));
                    ObjectOutputStream objOut = new ObjectOutputStream(outJar);
                    objOut.writeObject(subContents);
                    objOut.flush();
                    outJar.closeEntry();
                    continue;
                }
                outJar.putNextEntry(new JarEntry(key));
                if (contents instanceof ByteArrayOutputStream) {
                    ((ByteArrayOutputStream)contents).writeTo(outJar);
                } else {
                    ObjectOutputStream objOut = new ObjectOutputStream(outJar);
                    objOut.writeObject(contents);
                    objOut.flush();
                }
                outJar.closeEntry();
            }
        }
    }

    public void writeJarSkeleton(AutomatedInstallData installdata, PathResolver pathResolver, JarOutputStream outJar) throws Exception {
        List<Mergeable> uninstallerMerge = pathResolver.getMergeableFromPath("com/izforge/izpack/uninstaller/");
        uninstallerMerge.addAll(pathResolver.getMergeableFromPath("uninstaller-META-INF/", "META-INF/"));
        uninstallerMerge.addAll(pathResolver.getMergeableFromPath("com/izforge/izpack/api/"));
        uninstallerMerge.addAll(pathResolver.getMergeableFromPath("com/izforge/izpack/util/"));
        uninstallerMerge.addAll(pathResolver.getMergeableFromPath("com/izforge/izpack/gui/"));
        uninstallerMerge.addAll(pathResolver.getMergeableFromPath("com/izforge/izpack/img/"));
        for (Mergeable mergeable : uninstallerMerge) {
            mergeable.merge(outJar);
        }
        if (PrivilegedRunner.isPrivilegedMode() && installdata.getInfo().isPrivilegedExecutionRequiredUninstaller()) {
            outJar.putNextEntry(new JarEntry("exec-admin"));
            outJar.closeEntry();
        }
        List<Mergeable> langPack = pathResolver.getMergeableFromPath("resources/langpacks/" + installdata.getLocaleISO3() + ".xml", "langpack.xml");
        for (Mergeable mergeable : langPack) {
            mergeable.merge(outJar);
        }
    }

    private void createOutputJar() {
        String dest = IoHelper.translatePath(this.installdata.getInfo().getUninstallerPath(), this.variableSubstitutor);
        String jar = String.valueOf(dest) + File.separator + this.installdata.getInfo().getUninstallerName();
        File pathMaker = new File(dest);
        pathMaker.mkdirs();
        this.udata.setUninstallerJarFilename(jar);
        this.udata.setUninstallerPath(dest);
        try {
            this.out = new FileOutputStream(jar);
        }
        catch (FileNotFoundException e) {
            throw new IzPackException("Problem writing uninstaller jar", e);
        }
        try {
            this.bos = new BufferedOutputStream(this.out);
            this.outJar = new JarOutputStream(this.bos);
        }
        catch (IOException e) {
            throw new IzPackException("Problem writing uninstaller jar", e);
        }
        this.outJar.setLevel(9);
        this.udata.addFile(jar, true);
    }
}

