/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.InterruptedExceptionUnchecked;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.filesystem.FileOperations;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.IImmutableCopier;
import ch.systemsx.cisd.etlserver.IFile;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class FileBasedFile
implements IFile {
    private final IImmutableCopier hardLinkCopierOrNull;
    private final File file;

    public FileBasedFile(File file, IImmutableCopier hardLinkCopierOrNull) {
        assert (file != null) : "Unspecified file.";
        this.file = file;
        this.hardLinkCopierOrNull = hardLinkCopierOrNull;
    }

    @Override
    public void copyFrom(File sourceFile) {
        this.copy(sourceFile, this.file);
    }

    @Override
    public void copyTo(File destinationFile) {
        this.copy(this.file, destinationFile);
    }

    private void copy(File sourceFile, File destinationFile) {
        if (sourceFile.isDirectory()) {
            this.copyDirectory(sourceFile, destinationFile);
        } else {
            this.copyFile(sourceFile, destinationFile);
        }
    }

    private void copyFile(File sourceFile, File destinationFile) {
        if (this.hardLinkCopierOrNull != null) {
            File destinationDirectory = destinationFile.getParentFile();
            Status status = this.hardLinkCopierOrNull.copyImmutably(sourceFile, destinationDirectory, destinationFile.getName());
            if (status.isError()) {
                throw new EnvironmentFailureException("Couldn't copy '" + sourceFile.getAbsolutePath() + "' using hard links to '" + destinationFile.getAbsolutePath() + "': " + status);
            }
        } else {
            try {
                InterruptedExceptionUnchecked.check();
                FileUtils.copyFile((File)sourceFile, (File)destinationFile, (boolean)true);
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        }
    }

    private void copyDirectory(File sourceDirectory, File destinationDirectory) {
        if (this.hardLinkCopierOrNull != null) {
            File destinationParentDirectory = destinationDirectory.getParentFile();
            Status status = this.hardLinkCopierOrNull.copyImmutably(sourceDirectory, destinationParentDirectory, destinationDirectory.getName());
            if (status.isError()) {
                throw new EnvironmentFailureException("Couldn't copy '" + sourceDirectory.getAbsolutePath() + "' using hard links to '" + destinationDirectory.getAbsolutePath() + "': " + status);
            }
        } else {
            try {
                InterruptedExceptionUnchecked.check();
                FileUtils.copyDirectory((File)sourceDirectory, (File)destinationDirectory, (boolean)true);
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        }
    }

    @Override
    public void delete() {
        if (FileOperations.getMonitoredInstanceForCurrentThread().removeRecursivelyQueueing(this.file)) {
            throw new EnvironmentFailureException("Can not delete file '" + this.file.getAbsolutePath() + "'.");
        }
    }

    @Override
    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    @Override
    public byte[] read() {
        try {
            return FileUtils.readFileToByteArray((File)this.file);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    @Override
    public void write(byte[] data) {
        try {
            FileUtils.writeByteArrayToFile((File)this.file, (byte[])data);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    @Override
    public final void check() throws EnvironmentFailureException, ConfigurationFailureException {
        String response = FileUtilities.checkDirectoryFullyAccessible(this.file, "");
        if (response != null) {
            throw new ConfigurationFailureException(response);
        }
    }

    @Override
    public boolean isRemote() {
        return false;
    }
}

