/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.etlserver.ITypeExtractor;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.FileFormatType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LocatorType;
import ch.systemsx.cisd.openbis.generic.shared.dto.types.DataSetTypeCode;
import java.io.File;
import java.util.Properties;

public class SimpleTypeExtractor
implements ITypeExtractor {
    public static final String FILE_FORMAT_TYPE_KEY = "file-format-type";
    public static final String LOCATOR_TYPE_KEY = "locator-type";
    public static final String DATA_SET_TYPE_KEY = "data-set-type";
    public static final String PROCESSOR_TYPE_KEY = "processor-type";
    public static final String IS_MEASURED_KEY = "is-measured";
    private FileFormatType fileFormatType;
    private LocatorType locatorType;
    private DataSetType dataSetType;
    private String processorType;
    private boolean measured;

    public SimpleTypeExtractor(Properties properties) {
        String code = properties.getProperty(FILE_FORMAT_TYPE_KEY, "PROPRIETARY");
        this.fileFormatType = new FileFormatType(code);
        code = properties.getProperty(LOCATOR_TYPE_KEY, "RELATIVE_LOCATION");
        this.locatorType = new LocatorType(code);
        code = properties.getProperty(DATA_SET_TYPE_KEY, DataSetTypeCode.UNKNOWN.getCode());
        this.dataSetType = new DataSetType(code);
        this.processorType = properties.getProperty(PROCESSOR_TYPE_KEY);
        this.measured = "true".equals(properties.getProperty(IS_MEASURED_KEY, "true"));
    }

    @Override
    public final FileFormatType getFileFormatType(File incomingDataSetPath) {
        return this.fileFormatType;
    }

    @Override
    public final LocatorType getLocatorType(File incomingDataSetPath) {
        return this.locatorType;
    }

    @Override
    public final DataSetType getDataSetType(File incomingDataSetPath) {
        return this.dataSetType;
    }

    @Override
    public String getProcessorType(File incomingDataSetPath) {
        return this.processorType;
    }

    @Override
    public boolean isMeasuredData(File incomingDataSetPath) {
        return this.measured;
    }
}

