/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.entityregistration;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.io.DelegatedReader;
import ch.systemsx.cisd.common.mail.EMailAddress;
import ch.systemsx.cisd.common.string.UnicodeUtils;
import ch.systemsx.cisd.etlserver.entityregistration.AbstractSampleAndDataSetProcessor;
import ch.systemsx.cisd.etlserver.entityregistration.IRegistrationStatus;
import ch.systemsx.cisd.etlserver.entityregistration.SampleAndDataSetRegistrationGlobalState;
import ch.systemsx.cisd.etlserver.entityregistration.SampleAndDataSetRegistrator;
import ch.systemsx.cisd.etlserver.entityregistration.SampleDataSetPair;
import ch.systemsx.cisd.etlserver.entityregistration.SampleDataSetPairParserObjectFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.parser.BisTabFileLoader;
import ch.systemsx.cisd.openbis.generic.shared.parser.GlobalProperties;
import ch.systemsx.cisd.openbis.generic.shared.parser.GlobalPropertiesLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.mail.util.ByteArrayDataSource;

class SampleAndDataSetControlFileProcessor
extends AbstractSampleAndDataSetProcessor {
    private static final String SUCCESS_FILENAME = "registered.txt";
    private final File controlFile;
    private final HashMap<SampleDataSetPair, IRegistrationStatus> errorMap = new HashMap();
    private final ArrayList<SampleDataSetPair> errorPairs = new ArrayList();
    private final HashMap<SampleDataSetPair, IRegistrationStatus> successMap = new HashMap();
    private final ArrayList<SampleDataSetPair> successPairs = new ArrayList();
    private final HashSet<File> processedDataSetFiles = new HashSet();
    private ControlFileRegistrationProperties properties;
    private String failureLinesResultSectionOrNull;
    private String unmentionedSubfoldersResultSectionOrNull;
    private String successLinesResultSectionOrNull;

    SampleAndDataSetControlFileProcessor(SampleAndDataSetRegistrationGlobalState globalState, File folder, File controlFile) {
        super(globalState, folder);
        this.controlFile = controlFile;
    }

    public void register() throws UserFailureException, EnvironmentFailureException, FileNotFoundException {
        ControlFileOverrideProperties overrideProperties = new ControlFileOverrideProperties(this.controlFile);
        this.logControlFileOverridePropertiesExtracted(overrideProperties);
        this.properties = new ControlFileRegistrationProperties(overrideProperties, this.globalState);
        BisTabFileLoader<SampleDataSetPair> controlFileLoader = new BisTabFileLoader<SampleDataSetPair>(SampleDataSetPairParserObjectFactory.createFactoryFactory(this.properties.getSampleType(), this.properties.getDataSetType()), false);
        List<SampleDataSetPair> loadedSampleDataSetPairs = null;
        Reader reader = UnicodeUtils.createReader(new FileInputStream(this.controlFile));
        DelegatedReader delegatedReader = new DelegatedReader(reader, this.controlFile.getName());
        try {
            try {
                this.properties.checkValidity();
                Map<String, String> defaults = Collections.emptyMap();
                loadedSampleDataSetPairs = controlFileLoader.load(delegatedReader, defaults);
            }
            catch (UserFailureException e) {
                if (this.properties.getUser() == null) {
                    throw e;
                }
                this.sendEmailWithErrorMessage(e.getMessage());
                try {
                    delegatedReader.close();
                }
                catch (IOException iOException) {}
                return;
            }
        }
        catch (Throwable throwable) {
            try {
                delegatedReader.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            delegatedReader.close();
        }
        catch (IOException iOException) {}
        String userId = this.properties.getUser().getUserId();
        for (SampleDataSetPair sampleDataSet : loadedSampleDataSetPairs) {
            sampleDataSet.getDataSetInformation().setUploadingUserId(userId);
            SampleAndDataSetRegistrator registrator = new SampleAndDataSetRegistrator(this.folder, this.properties, sampleDataSet);
            IRegistrationStatus result = registrator.register();
            this.processedDataSetFiles.add(registrator.getDataSetFile());
            if (result.isError()) {
                this.errorMap.put(sampleDataSet, result);
                this.errorPairs.add(sampleDataSet);
                continue;
            }
            this.successMap.put(sampleDataSet, result);
            this.successPairs.add(sampleDataSet);
        }
        this.sendResultsEmail();
    }

    private void sendResultsEmail() {
        this.createFailureLinesSection();
        this.createUnmentionedFoldersSection();
        this.createSuccessfulLinesSection();
        boolean wasSuccessful = true;
        StringBuilder resultEmail = new StringBuilder();
        if (this.failureLinesResultSectionOrNull != null) {
            resultEmail.append(this.failureLinesResultSectionOrNull);
            resultEmail.append("\n");
            wasSuccessful = false;
        }
        if (this.unmentionedSubfoldersResultSectionOrNull != null) {
            resultEmail.append(this.unmentionedSubfoldersResultSectionOrNull);
            resultEmail.append("\n");
            wasSuccessful = false;
        }
        if (this.successLinesResultSectionOrNull != null) {
            resultEmail.append(this.successLinesResultSectionOrNull);
        }
        if (wasSuccessful) {
            this.sendEmailWithSuccessMessage(resultEmail.toString());
        } else {
            this.sendEmailWithErrorMessage(resultEmail.toString());
        }
    }

    private void createFailureLinesSection() {
        if (this.errorMap.isEmpty()) {
            this.failureLinesResultSectionOrNull = null;
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Encountered errors in the following lines:\n");
        for (SampleDataSetPair pair : this.errorPairs) {
            IRegistrationStatus error = this.errorMap.get(pair);
            if (SampleAndDataSetRegistrationGlobalState.SampleRegistrationMode.IGNORE_EXISTING == this.globalState.getSampleRegistrationMode() && SampleDataSetPair.SampleDataSetPairProcessing.SKIPPED == pair.getProcessingApplied()) {
                sb.append("# ");
                sb.append("Skipped existing sample");
                sb.append("\n");
                sb.append("# ");
            } else {
                sb.append("# ");
                sb.append(error.getMessage());
                sb.append("\n");
            }
            String[] tokens = pair.getTokens();
            int i = 0;
            String[] stringArray = tokens;
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                sb.append(token);
                if (++i < tokens.length) {
                    sb.append("\t");
                }
                ++n2;
            }
            sb.append("\n");
        }
        this.failureLinesResultSectionOrNull = sb.toString();
    }

    private void createUnmentionedFoldersSection() {
        if (!this.globalState.areUnmentionedFoldersAnError()) {
            this.unmentionedSubfoldersResultSectionOrNull = null;
            return;
        }
        ArrayList<File> unprocessedFiles = this.getUnprocessedDataSetList();
        if (unprocessedFiles.isEmpty()) {
            this.unmentionedSubfoldersResultSectionOrNull = null;
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("The following subfolders were in the uploaded folder, but were not mentioned in the control file:\n");
        for (File file : unprocessedFiles) {
            sb.append(file.getName());
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        this.unmentionedSubfoldersResultSectionOrNull = sb.toString();
    }

    private void createSuccessfulLinesSection() {
        if (this.successPairs.isEmpty()) {
            this.successLinesResultSectionOrNull = null;
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("The following lines were successfully processed:\n");
        for (SampleDataSetPair pair : this.successPairs) {
            switch (pair.getProcessingApplied()) {
                case REGISTERED_SAMPLE_AND_DATA_SET: {
                    sb.append("# Registered sample and data set\n");
                    break;
                }
                case UPDATED_SAMPLE_REGISTERED_DATA_SET: {
                    sb.append("# Updated sample and registered data set\n");
                    break;
                }
            }
            sb.append("# ");
            String[] tokens = pair.getTokens();
            int i = 0;
            String[] stringArray = tokens;
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                sb.append(token);
                if (++i < tokens.length) {
                    sb.append("\t");
                }
                ++n2;
            }
            sb.append("\n");
        }
        this.successLinesResultSectionOrNull = sb.toString();
    }

    private void logControlFileOverridePropertiesExtracted(ControlFileOverrideProperties overrideProperties) {
        String message = String.format("Global properties extracted from file '%s': SAMPLE_TYPE(%s) DATA_SET_TYPE(%s) USER(%s)", this.controlFile.getName(), overrideProperties.trySampleType(), overrideProperties.tryDataSetType(), overrideProperties.tryUserString());
        this.logInfo(message);
    }

    private void sendEmailWithSuccessMessage(String message) {
        try {
            String subject = this.createSuccessEmailSubject();
            String content = this.createSuccessEmailContent();
            String filename = SUCCESS_FILENAME;
            EMailAddress recipient = new EMailAddress(this.properties.getUser().getEmail());
            ByteArrayDataSource dataSource = new ByteArrayDataSource(message, "text/plain");
            this.globalState.getMailClient().sendEmailMessageWithAttachment(subject, content, filename, new DataHandler(dataSource), null, null, recipient);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    private void sendEmailWithErrorMessage(String message) {
        this.logError(message);
        try {
            String subject = this.createErrorEmailSubject();
            String content = this.createErrorEmailContent();
            String filename = "errors.txt";
            EMailAddress recipient = new EMailAddress(this.properties.getUser().getEmail());
            ByteArrayDataSource dataSource = new ByteArrayDataSource(message, "text/plain");
            this.globalState.getMailClient().sendEmailMessageWithAttachment(subject, content, filename, new DataHandler(dataSource), null, null, recipient);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    private String createErrorEmailSubject() {
        return String.format("Sample / Data Set Registration Error -- %s", this.controlFile);
    }

    private String createErrorEmailContent() {
        return String.format("Not all samples and data sets specified in the control file, %s, could be registered / updated. The errors are detailed in the attachment. Each faulty line is reproduced, preceded by a comment explaining the cause of the error.", this.controlFile);
    }

    private String createSuccessEmailSubject() {
        return String.format("Sample / Data Set Registration Succeeded -- %s", this.controlFile);
    }

    private String createSuccessEmailContent() {
        return String.format("The registration/update of samples and the registration of data sets specified in the control file, %s, was successful.", this.controlFile);
    }

    private ArrayList<File> getUnprocessedDataSetList() {
        Object[] files = this.folder.listFiles();
        Arrays.sort(files);
        ArrayList<File> unprcessedDataSets = new ArrayList<File>();
        Object[] objectArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            Object file = objectArray[n2];
            if (!this.controlFile.equals(file) && !this.processedDataSetFiles.contains(file)) {
                unprcessedDataSets.add((File)file);
            }
            ++n2;
        }
        return unprcessedDataSets;
    }

    static class ControlFileOverrideProperties {
        private final GlobalProperties properties;

        ControlFileOverrideProperties(File controlFile) throws FileNotFoundException {
            this.properties = GlobalPropertiesLoader.load(controlFile);
        }

        public SampleType trySampleType() {
            String sampleTypeCode = this.properties.tryGet("SAMPLE_TYPE");
            if (sampleTypeCode == null) {
                return null;
            }
            SampleType sampleType = new SampleType();
            sampleType.setCode(sampleTypeCode);
            return sampleType;
        }

        public DataSetType tryDataSetType() {
            String dataSetTypeCode = this.properties.tryGet("DATA_SET_TYPE");
            if (dataSetTypeCode == null) {
                return null;
            }
            DataSetType dataSetType = new DataSetType();
            dataSetType.setCode(dataSetTypeCode);
            return dataSetType;
        }

        public String tryUserString() {
            return this.properties.tryGet("USERID");
        }
    }

    static class ControlFileRegistrationProperties {
        private final ControlFileOverrideProperties overrideProperties;
        private final SampleAndDataSetRegistrationGlobalState globalProperties;
        private final Person user;

        ControlFileRegistrationProperties(ControlFileOverrideProperties overrideProperties, SampleAndDataSetRegistrationGlobalState globalProperties) throws FileNotFoundException {
            this.overrideProperties = overrideProperties;
            this.globalProperties = globalProperties;
            String userIdOrEmail = overrideProperties.tryUserString();
            this.user = userIdOrEmail == null ? null : globalProperties.getOpenbisService().tryPersonWithUserIdOrEmail(userIdOrEmail);
        }

        public SampleAndDataSetRegistrationGlobalState getGlobalProperties() {
            return this.globalProperties;
        }

        public SampleType getSampleType() {
            SampleType sampleType = this.overrideProperties.trySampleType();
            if (sampleType == null) {
                sampleType = this.globalProperties.trySampleType();
            }
            return sampleType;
        }

        public DataSetType getDataSetType() {
            DataSetType dataSetType = this.overrideProperties.tryDataSetType();
            if (dataSetType == null) {
                dataSetType = this.globalProperties.tryDataSetType();
            }
            return dataSetType;
        }

        public Person getUser() {
            return this.user;
        }

        public void checkValidity() {
            SampleType sampleType = this.getSampleType();
            DataSetType dataSetType = this.getDataSetType();
            Person theUser = this.getUser();
            StringBuilder sb = new StringBuilder();
            boolean hasError = false;
            if (sampleType == null) {
                hasError = true;
                sb.append("\tNo default sample type has been specified, and no sample type was specified in the control file");
            }
            if (dataSetType == null) {
                hasError = true;
                sb.append("\tNo default data set type has been specified, and no data set type was specified in the control file");
            }
            if (theUser == null) {
                hasError = true;
                sb.append("\tNo valid user has been specified in the control file");
            }
            if (hasError) {
                throw new UserFailureException(sb.toString());
            }
        }
    }
}

