/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.archiveverifier.batch;

import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.ResultType;
import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.VerificationError;
import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.VerificationErrorType;
import java.io.File;
import java.util.Collections;
import java.util.List;

public class DataSetArchiveVerificationResult {
    private File file;
    private List<VerificationError> errors;

    public DataSetArchiveVerificationResult(File file, List<VerificationError> errors) {
        this.file = file;
        this.errors = errors;
    }

    public DataSetArchiveVerificationResult(VerificationErrorType type, String message) {
        this.file = null;
        this.errors = Collections.singletonList(new VerificationError(type, message));
    }

    public DataSetArchiveVerificationResult(Exception e) {
        this.file = null;
        this.errors = Collections.singletonList(new VerificationError(VerificationErrorType.ERROR, String.valueOf(e.getClass().getName()) + ":" + e.getMessage()));
    }

    public ResultType getType() {
        if (this.errors.isEmpty()) {
            return ResultType.OK;
        }
        VerificationErrorType errorType = VerificationErrorType.WARNING;
        for (VerificationError error : this.errors) {
            VerificationErrorType verificationErrorType = errorType = errorType.compareTo(error.getType()) > 0 ? errorType : error.getType();
        }
        switch (errorType) {
            case WARNING: {
                return ResultType.WARNING;
            }
            case GENERAL_WARNING: {
                return ResultType.GENERAL_WARNING;
            }
            case ERROR: {
                return ResultType.ERROR;
            }
            case FATAL: {
                return ResultType.FATAL;
            }
        }
        throw new IllegalStateException("unknown error type " + (Object)((Object)errorType));
    }

    public List<VerificationError> getErrors() {
        return this.errors;
    }

    public String getFileName() {
        if (this.file != null) {
            return this.file.getAbsolutePath();
        }
        return "file not found";
    }
}

