/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.server.MetaDataBuilder;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DataSetExistenceChecker;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.translator.DataSetTranslator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.zip.CRC32;

public abstract class AbstractDataSetPackager {
    public static final String META_DATA_FILE_NAME = "meta-data.tsv";
    private final IHierarchicalContentProvider contentProvider;
    private final DataSetExistenceChecker dataSetExistenceChecker;

    protected AbstractDataSetPackager(IHierarchicalContentProvider contentProvider, DataSetExistenceChecker dataSetExistenceChecker) {
        this.contentProvider = contentProvider;
        this.dataSetExistenceChecker = dataSetExistenceChecker;
    }

    public abstract void addEntry(String var1, long var2, long var4, long var6, InputStream var8);

    public abstract void addDirectoryEntry(String var1);

    protected abstract boolean isChecksumNeeded();

    public abstract void close();

    public void addDataSetTo(String rootPath, AbstractExternalData externalData) {
        try {
            byte[] bytes = MetaDataBuilder.createMetaData(externalData).getBytes();
            CRC32 checksumCalculator = new CRC32();
            byte[] byArray = bytes;
            int n = bytes.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                checksumCalculator.update(0xFF & b);
                ++n2;
            }
            Long checksum = checksumCalculator.getValue();
            this.addEntry(String.valueOf(rootPath) + META_DATA_FILE_NAME, System.currentTimeMillis(), new Long(bytes.length), checksum, new ByteArrayInputStream(bytes));
        }
        catch (Exception ex) {
            throw new RuntimeException("Couldn't package meta data for data set '" + externalData.getCode() + "'.", ex);
        }
        if (!this.dataSetExistenceChecker.dataSetExists(DataSetTranslator.translateToDescription(externalData))) {
            throw this.handleNonExistingDataSet(externalData, null);
        }
        IHierarchicalContent root = null;
        try {
            root = this.contentProvider.asContent(externalData.getCode());
        }
        catch (Exception ex) {
            throw this.handleNonExistingDataSet(externalData, ex);
        }
        try {
            try {
                this.addTo(rootPath, root.getRootNode());
            }
            catch (Exception ex) {
                throw new RuntimeException("Couldn't package data set '" + externalData.getCode() + "'.", ex);
            }
        }
        finally {
            if (root != null) {
                root.close();
            }
        }
    }

    private RuntimeException handleNonExistingDataSet(AbstractExternalData externalData, Exception ex) {
        return new RuntimeException("Data set '" + externalData.getCode() + "' does not exist.", ex);
    }

    private void addTo(String newRootPath, IHierarchicalContentNode node) {
        File file = node.tryGetFile();
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            throw new IllegalStateException("File '" + file + "' doesn't exist.");
        }
        String entryPath = String.valueOf(newRootPath) + node.getRelativePath();
        if (node.isDirectory() && file.isDirectory()) {
            List<IHierarchicalContentNode> childNodes = node.getChildNodes();
            if (childNodes.isEmpty()) {
                this.addDirectoryEntry(entryPath);
            } else {
                for (IHierarchicalContentNode childNode : childNodes) {
                    this.addTo(newRootPath, childNode);
                }
            }
        } else if (file.isFile()) {
            long size = file.length();
            long checksum = this.isChecksumNeeded() ? node.getChecksumCRC32() : 0;
            try {
                this.addEntry(entryPath, node.getLastModified(), size, checksum, node.getInputStream());
            }
            catch (Exception ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
        } else {
            throw new IllegalStateException("Node '" + node.getRelativePath() + "' is a real folder");
        }
    }
}

