/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.sample;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ActionContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ComponentProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DispatcherHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.SampleTypeDisplayID;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.BaseEntityModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.PersonRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.DisplayedAndSelectedEntities;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.columns.framework.LinkExtractor;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.AbstractEntityGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ColumnDefsAndConfigs;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.DisposableEntityChooser;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.GridUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IBrowserGridActionInvoker;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ICellListenerAndLinkGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ICriteriaProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.listener.OpenEntityDetailsTabHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.sample.ISampleCriteriaProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.sample.SampleBrowserToolbar;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.sample.SampleListDeletionConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.IDataRefreshCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedActionWithResult;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDirectlyConnectedController;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ListEntityDisplayCriteriaKind;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ListSampleDisplayCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ListSampleDisplayCriteria2;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SampleBrowserGrid
extends AbstractEntityGrid<Sample> {
    protected static final IDirectlyConnectedController DUMMY_DIRECTLY_CONNECTED_CONTROLLER = new IDirectlyConnectedController(){

        @Override
        public void setOnChangeAction(IDelegatedAction onChangeAction) {
        }

        @Override
        public boolean isOnlyDirectlyConnected() {
            return true;
        }
    };
    private static final String PREFIX = "openbis_sample-browser";
    public static final String MAIN_BROWSER_ID = "openbis_sample-browser_main";
    public static final String MAIN_GRID_ID = SampleBrowserGrid.createGridId("openbis_sample-browser_main");
    public static final String ADD_BUTTON_ID_SUFFIX = "_add-button";
    public static final String EDIT_BUTTON_ID_SUFFIX = "_edit-button";
    public static final String DELETE_BUTTON_ID_SUFFIX = "_delete-button";
    public static final String SHOW_DETAILS_BUTTON_ID_SUFFIX = "_show-details-button";
    public static final String METAPROJECT_TYPE = "metaproject";
    private final ISampleCriteriaProvider propertyTypesAndCriteriaProvider;
    private TechId experimentIdOrNull;
    private final IDirectlyConnectedController directlyConnectedController;

    public static final String createGridId(String browserId) {
        return String.valueOf(browserId) + "-grid";
    }

    public static DisposableEntityChooser<TableModelRowWithObject<Sample>> createChooser(IViewContext<ICommonClientServiceAsync> viewContext, boolean addShared, boolean addAll, boolean excludeWithoutExperiment, SampleTypeDisplayID sampleTypeID, boolean multipleSelection) {
        SampleBrowserToolbar toolbar;
        SampleBrowserToolbar criteriaProvider = toolbar = new SampleBrowserToolbar(viewContext, addShared, addAll, excludeWithoutExperiment, sampleTypeID);
        SampleBrowserGrid browserGrid = new SampleBrowserGrid((IViewContext)viewContext, (ISampleCriteriaProvider)criteriaProvider, MAIN_BROWSER_ID, false, (IDisplayTypeIDGenerator)DisplayTypeIDGenerator.ENTITY_BROWSER_GRID, DUMMY_DIRECTLY_CONNECTED_CONTROLLER){

            @Override
            protected ICellListenerAndLinkGenerator<Sample> tryGetCellListenerAndLinkGenerator(String columnId) {
                return null;
            }

            @Override
            protected boolean isEditable(BaseEntityModel<TableModelRowWithObject<Sample>> model, String columnID) {
                return false;
            }

            @Override
            protected void showNonEditableTableCellMessage(BaseEntityModel<TableModelRowWithObject<Sample>> model, String columnID) {
            }
        };
        if (multipleSelection) {
            browserGrid.allowMultipleSelection();
        }
        super.addGridRefreshListener(toolbar);
        return browserGrid.asDisposableWithToolbar(toolbar);
    }

    public static IDisposableComponent create(IViewContext<ICommonClientServiceAsync> viewContext, String initialGroupOrNull, String initialSampleTypeOrNull) {
        SampleBrowserToolbar toolbar;
        SampleBrowserToolbar criteriaProvider = toolbar = new SampleBrowserToolbar(viewContext, true, true, false, initialGroupOrNull, initialSampleTypeOrNull, SampleTypeDisplayID.MAIN_SAMPLE_BROWSER);
        SampleBrowserGrid browserGrid = new SampleBrowserGrid(viewContext, criteriaProvider, MAIN_BROWSER_ID, false, DisplayTypeIDGenerator.ENTITY_BROWSER_GRID, DUMMY_DIRECTLY_CONNECTED_CONTROLLER);
        browserGrid.addGridRefreshListener(toolbar);
        browserGrid.extendBottomToolbar();
        return browserGrid.asDisposableWithToolbar(toolbar);
    }

    public static IDisposableComponent createGridForContainerSamples(IViewContext<ICommonClientServiceAsync> viewContext, TechId containerSampleId, String browserId, SampleType sampleType) {
        ListSampleDisplayCriteria criteria = ListSampleDisplayCriteria.createForContainer(containerSampleId);
        return SampleBrowserGrid.createGridForRelatedSamples(viewContext, criteria, browserId, sampleType);
    }

    public static IDisposableComponent createGridForDerivedSamples(IViewContext<ICommonClientServiceAsync> viewContext, TechId parentSampleId, String browserId, SampleType sampleType) {
        ListSampleDisplayCriteria criteria = ListSampleDisplayCriteria.createForParent(parentSampleId);
        return SampleBrowserGrid.createGridForRelatedSamples(viewContext, criteria, browserId, sampleType);
    }

    public static IDisposableComponent createGridForParentSamples(IViewContext<ICommonClientServiceAsync> viewContext, TechId childSampleId, String browserId, SampleType sampleType) {
        ListSampleDisplayCriteria criteria = ListSampleDisplayCriteria.createForChild(childSampleId);
        return SampleBrowserGrid.createGridForRelatedSamples(viewContext, criteria, browserId, sampleType);
    }

    private static IDisposableComponent createGridForRelatedSamples(IViewContext<ICommonClientServiceAsync> viewContext, ListSampleDisplayCriteria criteria, String browserId, SampleType sampleType) {
        String entityTypeCode = sampleType.getCode();
        SampleBrowserGrid browserGrid = SampleBrowserGrid.createGridAsComponent(viewContext, browserId, criteria, entityTypeCode, DisplayTypeIDGenerator.SAMPLE_DETAILS_GRID, DUMMY_DIRECTLY_CONNECTED_CONTROLLER);
        browserGrid.updateCriteriaProviderAndRefresh();
        browserGrid.extendBottomToolbar();
        return browserGrid.asDisposableWithoutToolbar();
    }

    public static IDisposableComponent createGridForExperimentSamples(IViewContext<ICommonClientServiceAsync> viewContext, TechId experimentId, String browserId, BasicEntityType experimentType, IDirectlyConnectedController directlyConnectedController) {
        ListSampleDisplayCriteria criteria = ListSampleDisplayCriteria.createForExperiment(experimentId);
        String entityTypeCode = experimentType.getCode();
        SampleBrowserGrid browserGrid = SampleBrowserGrid.createGridAsComponent(viewContext, browserId, criteria, entityTypeCode, DisplayTypeIDGenerator.EXPERIMENT_DETAILS_GRID, directlyConnectedController);
        browserGrid.experimentIdOrNull = experimentId;
        browserGrid.updateCriteriaProviderAndRefresh();
        browserGrid.extendBottomToolbar();
        return browserGrid.asDisposableWithoutToolbar();
    }

    public static SampleBrowserGrid createGridForMetaprojectSamples(IViewContext<ICommonClientServiceAsync> viewContext, TechId metaprojectId, String browserId) {
        ListSampleDisplayCriteria criteria = ListSampleDisplayCriteria.createForMetaproject(new MetaprojectCriteria(metaprojectId.getId()));
        SampleBrowserGrid browserGrid = SampleBrowserGrid.createGridAsComponent(viewContext, browserId, criteria, METAPROJECT_TYPE, DisplayTypeIDGenerator.METAPROJECT_DETAILS_GRID, DUMMY_DIRECTLY_CONNECTED_CONTROLLER);
        browserGrid.updateCriteriaProviderAndRefresh();
        browserGrid.addEntityOperationsLabel();
        browserGrid.addTaggingButtons(false);
        browserGrid.addEntityOperationsSeparator();
        browserGrid.allowMultipleSelection();
        return browserGrid;
    }

    private static SampleBrowserGrid createGridAsComponent(IViewContext<ICommonClientServiceAsync> viewContext, String browserId, ListSampleDisplayCriteria criteria, final String entityTypeCode, DisplayTypeIDGenerator displayTypeIDGenerator, IDirectlyConnectedController directlyConnectedController) {
        SampleCriteriaProvider criteriaProvider = new SampleCriteriaProvider(viewContext, criteria);
        boolean refreshAutomatically = false;
        SampleBrowserGrid browserGrid = new SampleBrowserGrid(viewContext, criteriaProvider, browserId, refreshAutomatically, displayTypeIDGenerator, directlyConnectedController){

            @Override
            public String getGridDisplayTypeID() {
                return String.valueOf(super.getGridDisplayTypeID()) + "-" + entityTypeCode;
            }
        };
        return browserGrid;
    }

    protected SampleBrowserGrid(IViewContext<ICommonClientServiceAsync> viewContext, ISampleCriteriaProvider criteriaProvider, String browserId, boolean refreshAutomatically, IDisplayTypeIDGenerator displayTypeIDGenerator, IDirectlyConnectedController directlyConnectedController) {
        super(viewContext, browserId, displayTypeIDGenerator);
        this.propertyTypesAndCriteriaProvider = criteriaProvider;
        this.directlyConnectedController = directlyConnectedController;
        directlyConnectedController.setOnChangeAction(new IDelegatedAction(){

            @Override
            public void execute() {
                SampleBrowserGrid.this.refresh();
            }
        });
        this.linkProject();
    }

    @Override
    protected boolean supportsExportForUpdate() {
        return true;
    }

    @Override
    public String getGridDisplayTypeID() {
        ListSampleDisplayCriteria criteria = this.getCriteriaProvider().tryGetCriteria();
        String suffix = this.createDisplayIdSuffix(EntityKind.SAMPLE, criteria == null ? null : criteria.tryGetSampleType());
        return this.createGridDisplayTypeID(suffix);
    }

    private void linkProject() {
        this.registerListenerAndLinkGenerator("PROJECT", new ICellListenerAndLinkGenerator<Sample>(){

            @Override
            public void handle(TableModelRowWithObject<Sample> rowItem, boolean specialKeyPressed) {
                Project project = rowItem.getObjectOrNull().getExperiment().getProject();
                String href = LinkExtractor.tryExtract(project);
                OpenEntityDetailsTabHelper.open(SampleBrowserGrid.this.viewContext, project, specialKeyPressed, href);
            }

            @Override
            public String tryGetLink(Sample entity, ISerializableComparable comparableValue) {
                Experiment exp = entity.getExperiment();
                return exp == null ? null : LinkExtractor.tryExtract(exp.getProject());
            }
        });
    }

    @Override
    protected String translateColumnIdToDictionaryKey(String columnID) {
        return columnID.toLowerCase();
    }

    @Override
    protected ColumnDefsAndConfigs<TableModelRowWithObject<Sample>> createColumnsDefinition() {
        ColumnDefsAndConfigs<TableModelRowWithObject<Sample>> definitions = super.createColumnsDefinition();
        definitions.setGridCellRendererFor("REGISTRATOR", PersonRenderer.REGISTRATOR_RENDERER);
        definitions.setGridCellRendererFor("MODIFIER", PersonRenderer.MODIFIER_RENDERER);
        definitions.setGridCellRendererFor("SHOW_DETAILS_LINK", this.createShowDetailsLinkCellRenderer());
        return definitions;
    }

    @Override
    protected EntityKind getEntityKindOrNull() {
        return EntityKind.SAMPLE;
    }

    @Override
    protected List<String> getColumnIdsOfFilters() {
        return Arrays.asList("CODE", "EXPERIMENT", "PROJECT");
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<Sample>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<Sample>> callback) {
        ListSampleDisplayCriteria2 criteria;
        ListSampleDisplayCriteria c1 = this.getCriteriaProvider().tryGetCriteria();
        if (c1.getCriteriaKind() == ListEntityDisplayCriteriaKind.BROWSE) {
            criteria = new ListSampleDisplayCriteria2(c1.getBrowseCriteria());
        } else if (c1.getCriteriaKind() == ListEntityDisplayCriteriaKind.SEARCH) {
            criteria = new ListSampleDisplayCriteria2(c1.getSearchCriteria());
        } else if (c1.getCriteriaKind() == ListEntityDisplayCriteriaKind.METAPROJECT) {
            criteria = new ListSampleDisplayCriteria2(c1.getMetaprojectCriteria());
        } else {
            throw new IllegalArgumentException("Unsupported criteria kind: " + (Object)((Object)c1.getCriteriaKind()));
        }
        criteria.copyPagingConfig(resultSetConfig);
        if (criteria.getCriteriaKind() == ListEntityDisplayCriteriaKind.BROWSE) {
            criteria.getBrowseCriteria().setOnlyDirectlyConnected(this.directlyConnectedController.isOnlyDirectlyConnected());
        }
        ((ICommonClientServiceAsync)this.viewContext.getService()).listSamples2(criteria, callback);
    }

    @Override
    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<Sample>> exportCriteria, AbstractAsyncCallback<String> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).prepareExportSamples(exportCriteria, callback);
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        ICriteriaProvider<ListSampleDisplayCriteria> criteriaProvider = this.getCriteriaProvider();
        return GridUtils.getRelevantModifications(DatabaseModificationKind.ObjectKind.SAMPLE, criteriaProvider);
    }

    @Override
    public void update(Set<DatabaseModificationKind> observedModifications) {
        ICriteriaProvider<ListSampleDisplayCriteria> criteriaProvider = this.getCriteriaProvider();
        criteriaProvider.update(observedModifications, new IDataRefreshCallback(){

            @Override
            public void postRefresh(boolean wasSuccessful) {
            }
        });
        if (criteriaProvider.tryGetCriteria() != null) {
            super.update(observedModifications);
        }
    }

    protected void updateCriteriaProviderAndRefresh() {
        HashSet<DatabaseModificationKind> observedModifications = new HashSet<DatabaseModificationKind>();
        this.getCriteriaProvider().update(observedModifications, new IDataRefreshCallback(){

            @Override
            public void postRefresh(boolean wasSuccessful) {
                SampleBrowserGrid.this.refresh();
            }
        });
    }

    private void addGridRefreshListener(SampleBrowserToolbar topToolbar) {
        topToolbar.setCriteriaChangedListeners(this.createGridRefreshDelegatedAction());
    }

    protected ICriteriaProvider<ListSampleDisplayCriteria> getCriteriaProvider() {
        return this.propertyTypesAndCriteriaProvider;
    }

    protected void extendBottomToolbar() {
        if (this.viewContext.isSimpleOrEmbeddedMode()) {
            return;
        }
        this.addEntityOperationsLabel();
        this.addEntityOperationButtons();
        this.addEntityOperationsSeparator();
    }

    protected void addEntityOperationButtons() {
        Button addButton = new Button(this.viewContext.getMessage("button_add", "Sample"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                SampleBrowserGrid.this.openSampleRegistrationTab();
            }
        });
        addButton.setId(this.createChildComponentId(ADD_BUTTON_ID_SUFFIX));
        this.addButton(addButton);
        this.addTaggingButtons();
        String showDetailsTitle = this.viewContext.getMessage("button_show_details", new Object[0]);
        Button showDetailsButton = this.createSelectedItemButton(showDetailsTitle, this.asShowEntityInvoker(false));
        showDetailsButton.setId(this.createChildComponentId(SHOW_DETAILS_BUTTON_ID_SUFFIX));
        this.addButton(showDetailsButton);
        String editTitle = this.viewContext.getMessage("edit", new Object[0]);
        Button editButton = this.createSelectedItemButton(editTitle, this.asShowEntityInvoker(true));
        editButton.setId(this.createChildComponentId(EDIT_BUTTON_ID_SUFFIX));
        this.addButton(editButton);
        String deleteTitle = this.viewContext.getMessage("button_delete", new Object[0]);
        String deleteAllTitle = String.valueOf(deleteTitle) + " All";
        Button deleteButton = new Button(deleteAllTitle, (SelectionListener)new TypedTableGrid.AbstractCreateDialogListener(this){

            protected Dialog createDialog(List<TableModelRowWithObject<Sample>> samples, IBrowserGridActionInvoker invoker) {
                AbstractAsyncCallback callback = SampleBrowserGrid.this.createRefreshCallback(invoker);
                DisplayedAndSelectedEntities<TableModelRowWithObject<Sample>> s = SampleBrowserGrid.this.getDisplayedAndSelectedItemsAction().execute();
                return new SampleListDeletionConfirmationDialog<DisplayedAndSelectedEntities<TableModelRowWithObject<Sample>>>((IViewContext<ICommonClientServiceAsync>)SampleBrowserGrid.this.viewContext, (List<DisplayedAndSelectedEntities<TableModelRowWithObject<Sample>>>)samples, (AsyncCallback<Void>)callback, s);
            }
        });
        deleteButton.setId(this.createChildComponentId(DELETE_BUTTON_ID_SUFFIX));
        this.changeButtonTitleOnSelectedItems(deleteButton, deleteAllTitle, deleteTitle);
        this.addButton(deleteButton);
        this.allowMultipleSelection();
    }

    protected final IDelegatedActionWithResult<DisplayedAndSelectedEntities<TableModelRowWithObject<Sample>>> getDisplayedAndSelectedItemsAction() {
        return new IDelegatedActionWithResult<DisplayedAndSelectedEntities<TableModelRowWithObject<Sample>>>(){

            @Override
            public DisplayedAndSelectedEntities<TableModelRowWithObject<Sample>> execute() {
                TableExportCriteria tableExportCriteria = SampleBrowserGrid.this.createTableExportCriteria();
                List selectedBaseObjects = SampleBrowserGrid.this.getSelectedBaseObjects();
                return new DisplayedAndSelectedEntities<TableModelRowWithObject<Sample>>(selectedBaseObjects, tableExportCriteria, SampleBrowserGrid.this.getTotalCount());
            }
        };
    }

    public static final String createChildComponentId(String browserId, String childSuffix) {
        return String.valueOf(browserId) + childSuffix;
    }

    private final String createChildComponentId(String childSuffix) {
        return SampleBrowserGrid.createChildComponentId(this.getId(), childSuffix);
    }

    private void openSampleRegistrationTab() {
        if (this.experimentIdOrNull != null) {
            ((ICommonClientServiceAsync)this.viewContext.getService()).getExperimentInfo(this.experimentIdOrNull, (AsyncCallback<Experiment>)new SampleRegistrationWithExperimentInfoCallback(this.viewContext));
        } else {
            ActionContext context = new ActionContext();
            ListSampleDisplayCriteria criteriaOrNull = this.getCriteriaProvider().tryGetCriteria();
            if (criteriaOrNull != null && criteriaOrNull.getCriteriaKind() == ListEntityDisplayCriteriaKind.BROWSE) {
                ListSampleCriteria browseCriteria = criteriaOrNull.getBrowseCriteria();
                SampleType sampleType = browseCriteria.getSampleType();
                context.setSampleType(sampleType);
                String spaceCode = browseCriteria.getSpaceCode();
                context.setSpaceCode(spaceCode);
            }
            DispatcherHelper.dispatchNaviEvent(new ComponentProvider(this.viewContext).getSampleRegistration(context));
        }
    }

    protected final IDelegatedAction createGridRefreshDelegatedAction() {
        return new IDelegatedAction(){

            @Override
            public void execute() {
                if (SampleBrowserGrid.this.getCriteriaProvider().tryGetCriteria() != null) {
                    SampleBrowserGrid.this.refreshGridWithFilters();
                }
            }
        };
    }

    protected static class SampleCriteriaProvider
    implements ISampleCriteriaProvider {
        private final ListSampleDisplayCriteria criteria;

        public SampleCriteriaProvider(IViewContext<?> viewContext, ListSampleDisplayCriteria criteria) {
            this.criteria = criteria;
        }

        @Override
        public ListSampleDisplayCriteria tryGetCriteria() {
            return this.criteria;
        }

        @Override
        public void update(Set<DatabaseModificationKind> observedModifications, IDataRefreshCallback dataRefreshCallback) {
            dataRefreshCallback.postRefresh(true);
        }

        @Override
        public DatabaseModificationKind[] getRelevantModifications() {
            return DatabaseModificationKind.any(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT);
        }
    }

    private final class SampleRegistrationWithExperimentInfoCallback
    extends AbstractAsyncCallback<Experiment> {
        public SampleRegistrationWithExperimentInfoCallback(IViewContext<ICommonClientServiceAsync> viewContext) {
            super(viewContext);
        }

        @Override
        protected void process(Experiment result) {
            ActionContext experimentContext = new ActionContext(result);
            DispatcherHelper.dispatchNaviEvent(new ComponentProvider(this.viewContext.getCommonViewContext()).getSampleRegistration(experimentContext));
        }
    }
}

