/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.LabeledItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.SimpleComboBox;
import com.extjs.gxt.ui.client.widget.form.SimpleComboValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SimpleModelComboBox<T>
extends SimpleComboBox<LabeledItem<T>> {
    public SimpleModelComboBox(IMessageProvider messageProvider, List<T> items, List<String> labels, List<String> tooltips, Integer widthPx) {
        this(messageProvider, SimpleModelComboBox.createModelItems(items, labels, tooltips), widthPx);
    }

    public SimpleModelComboBox(IMessageProvider messageProvider, List<LabeledItem<T>> model, Integer widthPx) {
        this.configure(messageProvider, widthPx);
        this.setModel(model);
        GWTUtils.autoselect(this);
        GWTUtils.setupAutoWidth(this);
    }

    private void configure(IMessageProvider messageProvider, Integer widthPx) {
        this.setTriggerAction(ComboBox.TriggerAction.ALL);
        this.setAllowBlank(false);
        this.setEditable(false);
        this.setEmptyText(messageProvider.getMessage("combobox_choose", new Object[0]));
        if (widthPx != null) {
            this.setWidth("" + widthPx);
        }
        this.setTemplate(GWTUtils.getTooltipTemplate("label", "tooltip"));
    }

    private static <T> List<LabeledItem<T>> createModelItems(List<T> items, List<String> labels, List<String> tooltips) {
        assert (items.size() == labels.size()) : "for each item there should be one corresponding label";
        assert (items.size() == tooltips.size()) : "for each item there should be one corresponding tooltip";
        ArrayList<LabeledItem<T>> model = new ArrayList<LabeledItem<T>>();
        int i = 0;
        for (T item : items) {
            model.add(new LabeledItem<T>(item, labels.get(i), tooltips.get(i)));
            ++i;
        }
        return model;
    }

    private void setModel(List<LabeledItem<T>> modelItems) {
        for (LabeledItem<T> item : modelItems) {
            this.add(item);
        }
    }

    public void add(List<LabeledItem<T>> values) {
        ArrayList list = new ArrayList();
        for (LabeledItem<T> t : values) {
            list.add(new ExtendedSimpleComboValue(t));
        }
        this.store.add(list);
    }

    public void add(LabeledItem<T> value) {
        this.store.add(new ExtendedSimpleComboValue(value));
    }

    public T tryGetChosenItem() {
        if (this.getSelectedIndex() == -1) {
            return null;
        }
        return ((LabeledItem)this.getSimpleValue()).getItem();
    }

    public static <T> T getChosenItem(SelectionChangedEvent<SimpleComboValue<LabeledItem<T>>> se) {
        return ((LabeledItem)((SimpleComboValue)se.getSelectedItem()).getValue()).getItem();
    }

    public LabeledItem<T> findModelForVal(T val) {
        LabeledItem result = null;
        for (SimpleComboValue c : this.getStore().getModels()) {
            Object item = ((LabeledItem)c.getValue()).getItem();
            if (item == null || !item.equals(val)) continue;
            result = (LabeledItem)c.getValue();
            break;
        }
        return result;
    }

    public void setSelection(LabeledItem<T> itemToSelectOrNull) {
        if (itemToSelectOrNull == null) {
            this.setSelection(new ArrayList());
        } else {
            for (SimpleComboValue info : this.getStore().getModels()) {
                Object item = ((LabeledItem)info.getValue()).getItem();
                if (item == null || !item.equals(itemToSelectOrNull.getItem())) continue;
                this.setSelection(Collections.singletonList(info));
            }
        }
    }

    private static class ExtendedSimpleComboValue<T>
    extends SimpleComboValue<LabeledItem<T>> {
        private static final long serialVersionUID = 1L;

        private ExtendedSimpleComboValue(LabeledItem<T> value) {
            super(value);
            this.set("label", value.toString());
            this.set("tooltip", value.getTooltip());
        }
    }
}

