/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IAttachmentBO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Attachment;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentHolderPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventType;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import java.util.Collections;
import java.util.List;
import org.springframework.dao.DataAccessException;

public final class AttachmentBO
extends AbstractBusinessObject
implements IAttachmentBO {
    private AttachmentPE attachment;
    private boolean dataChanged;

    public AttachmentBO(IDAOFactory daoFactory, Session session, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        super(daoFactory, session, managedPropertyEvaluatorFactory);
    }

    @Override
    public void deleteHolderAttachments(AttachmentHolderPE holder, List<String> fileNames, String reason) {
        for (String fileName : fileNames) {
            try {
                this.getAttachmentDAO().deleteByOwnerAndFileName(holder, fileName);
                this.getEventDAO().persist(AttachmentBO.createDeletionEvent(holder, fileName, this.session.tryGetPerson(), reason));
            }
            catch (DataAccessException ex) {
                AttachmentBO.throwException(ex, String.format("Attachment '%s'", fileName));
            }
        }
    }

    public static EventPE createDeletionEvent(AttachmentHolderPE holder, String fileName, PersonPE registrator, String reason) {
        EventPE event = new EventPE();
        String identifier = AttachmentBO.createDeletionIdentifier(holder, fileName);
        event.setEventType(EventType.DELETION);
        event.setEntityType(EventPE.EntityType.ATTACHMENT);
        event.setIdentifiers(Collections.singletonList(identifier));
        event.setDescription(identifier);
        event.setReason(reason);
        event.setRegistrator(registrator);
        return event;
    }

    private static String createDeletionIdentifier(AttachmentHolderPE holder, String fileName) {
        return String.format("%s/%s/%s", holder.getHolderName(), holder.getIdentifier(), fileName);
    }

    @Override
    public void updateAttachment(AttachmentHolderPE holder, Attachment attachmentDTO) {
        this.load(holder, attachmentDTO.getFileName(), attachmentDTO.getVersion());
        this.attachment.setDescription(attachmentDTO.getDescription());
        this.attachment.setTitle(attachmentDTO.getTitle());
        this.dataChanged = true;
    }

    @Override
    public final void save() {
        assert (this.attachment != null) : "Can not save an undefined attachment.";
        if (this.dataChanged) {
            try {
                this.getAttachmentDAO().persist(this.attachment);
            }
            catch (DataAccessException ex) {
                AttachmentBO.throwException(ex, "Attachment '" + this.attachment.getFileName() + "'");
            }
        }
    }

    private void load(AttachmentHolderPE holder, String fileName, int version) {
        this.attachment = this.getAttachmentDAO().tryFindAttachmentByOwnerAndFileNameAndVersion(holder, fileName, version);
        if (this.attachment == null) {
            throw new UserFailureException("Attachment not found");
        }
        this.dataChanged = false;
    }
}

