/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.IdentifierHelper;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import java.util.List;

public class SampleGenericBusinessRules {
    private static void assertValidParentRelation(SamplePE parent, SamplePE child, String childRelationName) throws UserFailureException {
        if (parent == null || child == null) {
            return;
        }
        SampleIdentifier parentId = parent.getSampleIdentifier();
        SampleIdentifier childId = IdentifierHelper.createSampleIdentifier(child);
        if (parentId.isSpaceLevel() && childId.isDatabaseInstanceLevel()) {
            SampleGenericBusinessRules.throwUserFailureException("The database instance sample '%s' can not be %s the space sample '%s'.", child, parent, childRelationName);
        }
    }

    private static void assertValidChildrenRelation(List<SamplePE> children, SamplePE parent, String childRelationName) throws UserFailureException {
        if (children == null || children.size() == 0 || parent == null) {
            return;
        }
        SampleIdentifier parentId = IdentifierHelper.createSampleIdentifier(parent);
        if (parentId.isSpaceLevel()) {
            for (SamplePE child : children) {
                SampleIdentifier childId = child.getSampleIdentifier();
                if (!childId.isDatabaseInstanceLevel()) continue;
                SampleGenericBusinessRules.throwUserFailureException("Sample '%s' can not be a space sample because of a %s database instance sample '%s'.", parent, child, childRelationName);
            }
        }
    }

    public static void assertValidParents(SamplePE sample) {
        if (sample == null) {
            return;
        }
        for (SamplePE parent : sample.getParents()) {
            SampleGenericBusinessRules.assertValidParentRelation(parent, sample, "child of");
        }
    }

    public static void assertValidContainer(SamplePE sample) {
        if (sample == null) {
            return;
        }
        SampleGenericBusinessRules.assertValidParentRelation(sample.getContainer(), sample, "contained in");
    }

    public static void assertValidChildren(SamplePE sample) {
        if (sample == null) {
            return;
        }
        SampleGenericBusinessRules.assertValidChildrenRelation(sample.getGenerated(), sample, "child");
    }

    public static void assertValidComponents(SamplePE sample) {
        if (sample == null) {
            return;
        }
        SampleGenericBusinessRules.assertValidChildrenRelation(sample.getContained(), sample, "contained");
    }

    private static void throwUserFailureException(String messageTemplate, SamplePE sample1, SamplePE sample2, String childRelationName) {
        throw UserFailureException.fromTemplate(messageTemplate, sample1.getSampleIdentifier(), childRelationName, sample2.getSampleIdentifier());
    }
}

