/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.collection.CollectionStyle;
import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.collection.IToStringConverter;
import ch.systemsx.cisd.common.collection.ToStringDefaultConverter;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.MethodUtils;
import ch.systemsx.cisd.openbis.generic.server.batch.BatchOperationExecutor;
import ch.systemsx.cisd.openbis.generic.server.batch.IBatchOperation;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.PersistencyResources;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractGenericEntityWithPropertiesDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.DAOUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.IDetachedCriteriaFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeConverter;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetArchivingStatus;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DeletedDataSetLocation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStorePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletedDataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventType;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExternalDataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.hibernate.FetchMode;
import org.hibernate.HibernateException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.StatelessSession;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.transform.ResultTransformer;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;

final class DataDAO
extends AbstractGenericEntityWithPropertiesDAO<DataPE>
implements IDataDAO {
    private final int MAX_BATCH_SIZE = 999;
    private static final Class<DataPE> ENTITY_CLASS = DataPE.class;
    private static final Class<ExternalDataPE> EXTERNAL_DATA_ENTITY_CLASS = ExternalDataPE.class;
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DataDAO.class);
    private static final String TABLE_NAME = ENTITY_CLASS.getSimpleName();
    private static final String EXTERNAL_DATA_TABLE_NAME = EXTERNAL_DATA_ENTITY_CLASS.getSimpleName();

    DataDAO(PersistencyResources persistencyResources, DatabaseInstancePE databaseInstance) {
        super(persistencyResources, databaseInstance, ENTITY_CLASS);
    }

    @Override
    public boolean hasDataSet(SamplePE sample) throws DataAccessException {
        DetachedCriteria criteria = DetachedCriteria.forClass(ExternalDataPE.class);
        criteria.add((Criterion)Restrictions.eq((String)"sampleInternal", (Object)sample));
        criteria.setProjection(Projections.rowCount());
        Integer count = ((Number)this.getHibernateTemplate().findByCriteria(criteria).get(0)).intValue();
        return count > 0;
    }

    @Override
    public final List<DataPE> listRelatedDataSets(List<IEntityInformationHolder> entities, EntityKind entityKind) throws DataAccessException {
        assert (entities != null) : "Unspecified entities.";
        assert (entities.size() > 0) : "Empty entities.";
        assert (entityKind != null) : "Unspecified entity kind.";
        String entityName = entityKind.toString().toLowerCase();
        final String query = String.format("from %s e left join fetch e.experimentInternal left join fetch e.sampleInternal left join fetch e.dataSetParentRelationships left join fetch e.containedDataSets left join fetch e.dataSetProperties where e.%sInternal.id IN (:ids)", TABLE_NAME, entityName);
        final ArrayList<Long> ids = new ArrayList<Long>();
        for (IEntityInformationHolder entity : entities) {
            ids.add(entity.getId());
        }
        final ArrayList<DataPE> results = new ArrayList<DataPE>();
        BatchOperationExecutor.executeInBatches(new IBatchOperation<Long>(){

            @Override
            public void execute(List<Long> entityIds) {
                List list = DataDAO.cast(DataDAO.this.getHibernateTemplate().findByNamedParam(query, "ids", entityIds));
                results.addAll(list);
            }

            @Override
            public List<Long> getAllEntities() {
                return ids;
            }

            @Override
            public String getEntityName() {
                return "dataSet";
            }

            @Override
            public String getOperationName() {
                return "listRelatedDataSets";
            }
        });
        this.distinct(results);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("%d external data have been found for %d entities.", results.size(), entities.size()));
        }
        return results;
    }

    @Override
    public final List<DataPE> listDataSetsWithoutRelationships(SamplePE sample) throws DataAccessException {
        assert (sample != null) : "Unspecified sample.";
        String query = String.format("from %s e where e.sampleInternal = ?", TABLE_NAME);
        List<DataPE> list = DataDAO.cast(this.getHibernateTemplate().find(query, DataDAO.toArray(sample)));
        this.distinct(list);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("%d external data have been found for [sample=%s].", list.size(), sample));
        }
        return list;
    }

    @Override
    public final List<DataPE> listDataSets(SamplePE sample) throws DataAccessException {
        assert (sample != null) : "Unspecified sample.";
        String query = String.format("from %s e left join fetch e.experimentInternal left join fetch e.dataSetParentRelationships left join fetch e.dataSetProperties where e.sampleInternal = ?", TABLE_NAME);
        List<DataPE> list = DataDAO.cast(this.getHibernateTemplate().find(query, DataDAO.toArray(sample)));
        this.distinct(list);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("%d external data have been found for [sample=%s].", list.size(), sample));
        }
        return list;
    }

    @Override
    public final List<DataPE> listExternalData(DataStorePE dataStore) throws DataAccessException {
        assert (dataStore != null) : "Unspecified data store.";
        DetachedCriteria criteria = DetachedCriteria.forClass(ExternalDataPE.class);
        criteria.add((Criterion)Restrictions.eq((String)"dataStore", (Object)dataStore));
        List<DataPE> list = DataDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("%s(%s): %d data set(s) have been found.", MethodUtils.getCurrentMethod().getName(), dataStore, list.size()));
        }
        return list;
    }

    @Override
    public final List<DataPE> listDataSets(ExperimentPE experiment) throws DataAccessException {
        assert (experiment != null) : "Unspecified experiment.";
        String query = String.format("from %s e left join fetch e.experimentInternal left join fetch e.dataSetParentRelationships left join fetch e.dataSetProperties where e.experimentInternal = ?", TABLE_NAME);
        List<DataPE> list = DataDAO.cast(this.getHibernateTemplate().find(query, DataDAO.toArray(experiment)));
        this.distinct(list);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("%d external data have been found for [experiment=%s].", list.size(), experiment));
        }
        return list;
    }

    private void distinct(List<DataPE> list) {
        TreeSet<DataPE> set = new TreeSet<DataPE>(list);
        list.clear();
        list.addAll(set);
    }

    @Override
    public DataPE tryToFindDataSetByCode(String dataSetCode) {
        assert (dataSetCode != null) : "Unspecified data set code.";
        String mangledCode = CodeConverter.tryToDatabase(dataSetCode);
        SimpleExpression codeEq = Restrictions.eq((String)"code", (Object)mangledCode);
        DetachedCriteria criteria = DetachedCriteria.forClass(ENTITY_CLASS);
        criteria.add((Criterion)codeEq);
        criteria.setFetchMode("dataSetType", FetchMode.JOIN);
        criteria.setFetchMode("dataStore", FetchMode.JOIN);
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        List list = DataDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        DataPE entity = (DataPE)DataDAO.tryFindEntity(list, "data set", new Object[0]);
        if (operationLog.isDebugEnabled()) {
            String methodName = MethodUtils.getCurrentMethod().getName();
            operationLog.debug(String.format("%s(%s): '%s'.", methodName, dataSetCode, entity));
        }
        return entity;
    }

    @Override
    public List<DeletedDataPE> tryToFindDeletedDataSetsByCodes(Collection<String> dataSetCodes) {
        assert (dataSetCodes != null) : "Unspecified collection";
        if (dataSetCodes.size() == 0) {
            return Collections.emptyList();
        }
        List<DeletedDataPE> list = DAOUtils.listByCollection(this.getHibernateTemplate(), new IDetachedCriteriaFactory(){

            @Override
            public DetachedCriteria createCriteria() {
                DetachedCriteria criteria = DetachedCriteria.forClass(DeletedDataPE.class);
                criteria.setFetchMode("dataStore", FetchMode.SELECT);
                criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
                return criteria;
            }
        }, "code", dataSetCodes);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("Found '%s' data sets for codes '%s'.", list.size(), dataSetCodes));
        }
        return list;
    }

    @Override
    public List<DataPE> tryToFindFullDataSetsByIds(Collection<Long> ids, boolean withPropertyTypes, boolean lockForUpdate) {
        return this.tryToFindFullDataSets("id", ids, withPropertyTypes, lockForUpdate);
    }

    @Override
    public List<DataPE> tryToFindFullDataSetsByCodes(Collection<String> dataSetCodes, boolean withPropertyTypes, boolean lockForUpdate) {
        return this.tryToFindFullDataSets("code", dataSetCodes, withPropertyTypes, lockForUpdate);
    }

    private List<DataPE> tryToFindFullDataSets(String identifierColumn, Collection<?> identifiers, boolean withPropertyTypes, boolean lockForUpdate) {
        assert (identifiers != null) : "Unspecified collection";
        int len = identifiers.size();
        if (len > 999) {
            ArrayList<DataPE> result = new ArrayList<DataPE>(identifiers.size());
            ArrayList dataSetCodesList = new ArrayList(identifiers);
            int startIndex = 0;
            int endIndex = 999;
            while (endIndex > startIndex) {
                result.addAll(this.primFindFullDataSetsByCode(identifierColumn, dataSetCodesList.subList(startIndex, endIndex), withPropertyTypes, lockForUpdate));
                startIndex = endIndex;
                endIndex = Math.min(endIndex + 999, len);
            }
            return result;
        }
        return this.primFindFullDataSetsByCode(identifierColumn, identifiers, withPropertyTypes, lockForUpdate);
    }

    private List<DataPE> primFindFullDataSetsByCode(String identifierColumn, Collection<?> identifiers, final boolean withPropertyTypes, boolean lockForUpdate) {
        if (identifiers.size() == 0) {
            return Collections.emptyList();
        }
        List<DataPE> list = DAOUtils.listByCollection(this.getHibernateTemplate(), new IDetachedCriteriaFactory(){

            @Override
            public DetachedCriteria createCriteria() {
                DetachedCriteria criteria = DetachedCriteria.forClass((Class)ENTITY_CLASS);
                criteria.setFetchMode("dataSetType", FetchMode.SELECT);
                criteria.setFetchMode("dataStore", FetchMode.SELECT);
                criteria.setFetchMode("experimentInternal", FetchMode.SELECT);
                criteria.setFetchMode("sampleInternal", FetchMode.SELECT);
                criteria.setFetchMode("fileFormat", FetchMode.SELECT);
                if (withPropertyTypes) {
                    criteria.setFetchMode("dataSetType.dataSetTypePropertyTypesInternal", FetchMode.JOIN);
                }
                criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
                return criteria;
            }
        }, identifierColumn, identifiers);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("Found '%s' data sets for codes '%s'.", list.size(), identifiers));
        }
        return list;
    }

    @Override
    public DataPE tryToFindFullDataSetByCode(String dataSetCode, boolean withPropertyTypes, boolean lockForUpdate) {
        assert (dataSetCode != null) : "Unspecified data set code";
        String mangledCode = CodeConverter.tryToDatabase(dataSetCode);
        SimpleExpression codeEq = Restrictions.eq((String)"code", (Object)mangledCode);
        DetachedCriteria criteria = DetachedCriteria.forClass(ENTITY_CLASS);
        criteria.add((Criterion)codeEq);
        criteria.setFetchMode("dataSetType", FetchMode.SELECT);
        criteria.setFetchMode("dataStore", FetchMode.SELECT);
        criteria.setFetchMode("experimentInternal", FetchMode.SELECT);
        criteria.setFetchMode("sampleInternal", FetchMode.SELECT);
        criteria.setFetchMode("fileFormat", FetchMode.SELECT);
        if (withPropertyTypes) {
            criteria.setFetchMode("dataSetType.dataSetTypePropertyTypesInternal", FetchMode.JOIN);
        }
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        List list = DataDAO.cast(this.getHibernateTemplate().findByCriteria(criteria));
        DataPE entity = (DataPE)DataDAO.tryFindEntity(list, "data set", new Object[0]);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("Data Set '%s' found for data set code '%s'.", entity, dataSetCode));
        }
        return entity;
    }

    @Override
    public void updateDataSetStatuses(final List<String> dataSetCodes, final DataSetArchivingStatus status) {
        assert (dataSetCodes != null) : "Unspecified data set codes";
        assert (status != null) : "Unspecified code";
        if (dataSetCodes.size() == 0) {
            return;
        }
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        int len = dataSetCodes.size();
        int updatedRows = 0;
        if (len > 999) {
            int startIndex = 0;
            int endIndex = 999;
            while (endIndex > startIndex) {
                final int startIndexFinal = startIndex;
                final int endIndexFinal = endIndex;
                updatedRows += ((Integer)hibernateTemplate.execute(new HibernateCallback(){

                    public final Object doInHibernate(Session session) throws HibernateException, SQLException {
                        return session.createQuery("UPDATE VERSIONED " + EXTERNAL_DATA_TABLE_NAME + " SET status = :status WHERE code IN (:codes) ").setParameter("status", (Object)status).setParameterList("codes", dataSetCodes.subList(startIndexFinal, endIndexFinal)).executeUpdate();
                    }
                })).intValue();
                startIndex = endIndex;
                endIndex = Math.min(endIndex + 999, len);
            }
        } else {
            updatedRows = (Integer)hibernateTemplate.execute(new HibernateCallback(){

                public final Object doInHibernate(Session session) throws HibernateException, SQLException {
                    return session.createQuery("UPDATE VERSIONED " + EXTERNAL_DATA_TABLE_NAME + " SET status = :status WHERE code IN (:codes) ").setParameter("status", (Object)status).setParameterList("codes", (Collection)dataSetCodes).executeUpdate();
                }
            });
        }
        hibernateTemplate.flush();
        if (updatedRows != dataSetCodes.size()) {
            throw UserFailureException.fromTemplate("Update of %s data set statuses to %s failed.", new Object[]{dataSetCodes.size(), status});
        }
        if (operationLog.isInfoEnabled()) {
            operationLog.info(String.format("UPDATED: %s data set statuses to '%s'.", new Object[]{dataSetCodes.size(), status}));
        }
    }

    @Override
    public void updateDataSetStatuses(final List<String> dataSetCodes, final DataSetArchivingStatus status, final boolean presentInArchive) {
        assert (dataSetCodes != null) : "Unspecified data set codes";
        assert (status != null) : "Unspecified code";
        if (dataSetCodes.size() == 0) {
            return;
        }
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        int len = dataSetCodes.size();
        int updatedRows = 0;
        if (len > 999) {
            int startIndex = 0;
            int endIndex = 999;
            while (endIndex > startIndex) {
                final int startIndexFinal = startIndex;
                final int endIndexFinal = endIndex;
                updatedRows += ((Integer)hibernateTemplate.execute(new HibernateCallback(){

                    public final Object doInHibernate(Session session) throws HibernateException, SQLException {
                        return session.createQuery("UPDATE VERSIONED " + EXTERNAL_DATA_TABLE_NAME + " SET status = :status, presentInArchive = :presentInArchive" + " WHERE code IN (:codes) ").setParameter("status", (Object)status).setParameter("presentInArchive", (Object)presentInArchive).setParameterList("codes", dataSetCodes.subList(startIndexFinal, endIndexFinal)).executeUpdate();
                    }
                })).intValue();
                startIndex = endIndex;
                endIndex = Math.min(endIndex + 999, len);
            }
        } else {
            updatedRows = (Integer)hibernateTemplate.execute(new HibernateCallback(){

                public final Object doInHibernate(Session session) throws HibernateException, SQLException {
                    return session.createQuery("UPDATE VERSIONED " + EXTERNAL_DATA_TABLE_NAME + " SET status = :status, presentInArchive = :presentInArchive" + " WHERE code IN (:codes) ").setParameter("status", (Object)status).setParameter("presentInArchive", (Object)presentInArchive).setParameterList("codes", (Collection)dataSetCodes).executeUpdate();
                }
            });
        }
        hibernateTemplate.flush();
        if (updatedRows != dataSetCodes.size()) {
            throw UserFailureException.fromTemplate("Update of %s data set statuses to '%s' and presentInArchive to '%s' failed.", new Object[]{dataSetCodes.size(), status, presentInArchive});
        }
        if (operationLog.isInfoEnabled()) {
            operationLog.info(String.format("UPDATED: %s data set statuses to '%s' and presentInArchive flag to '%s'.", new Object[]{dataSetCodes.size(), status, presentInArchive}));
        }
    }

    @Override
    public void createDataSet(DataPE dataset, PersonPE modifier) {
        assert (dataset != null) : "Unspecified data set.";
        dataset.setCode(CodeConverter.tryToDatabase(dataset.getCode()));
        dataset.setModifier(modifier);
        if (!dataset.isPlaceholder()) {
            DataDAO.validatePE(dataset);
        }
        HibernateTemplate template = this.getHibernateTemplate();
        this.lockRelatedEntities(dataset);
        template.save((Object)dataset);
        template.flush();
        this.scheduleDynamicPropertiesEvaluation(Collections.singletonList(dataset));
        if (operationLog.isInfoEnabled()) {
            operationLog.info(String.format("ADD: data set '%s'.", dataset));
        }
    }

    private void lockRelatedEntities(DataPE data) {
        this.lockEntity(data.getExperiment());
        this.lockEntity(data.tryGetSample());
        this.lockEntity(data.getContainer());
        this.lockEntities(data.getParents());
        this.lockEntities(data.getChildren());
    }

    @Override
    public void updateDataSet(DataPE data, PersonPE modifier) {
        assert (data != null) : "Given external data can not be null.";
        DataDAO.validatePE(data);
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        data.setCode(CodeConverter.tryToDatabase(data.getCode()));
        data.setModifier(modifier);
        Long id = HibernateUtils.getId(data);
        DataPE loaded = (DataPE)hibernateTemplate.load(ENTITY_CLASS, (Serializable)id);
        if (loaded.isPlaceholder() && data instanceof ExternalDataPE) {
            ExternalDataPE externalData = (ExternalDataPE)data;
            String shareId = externalData.getShareId();
            String location = externalData.getLocation();
            Long size = externalData.getSize();
            Long locatorTypeID = externalData.getLocatorType().getId();
            Long fileFormatTypeID = externalData.getFileFormatType().getId();
            char complete = externalData.getComplete().name().charAt(0);
            Long storageFormatTermID = externalData.getStorageFormatVocabularyTerm().getId();
            if (size == null) {
                this.executeUpdate("insert into external_data (data_id, share_id, location, loty_id, ffty_id, is_complete, cvte_id_stor_fmt) values (?, ?, ?, ?, ?, ?, ?)", new Serializable[]{id, shareId, location, locatorTypeID, fileFormatTypeID, Character.valueOf(complete), storageFormatTermID});
            } else {
                this.executeUpdate("insert into external_data (data_id, share_id, location, size, loty_id, ffty_id, is_complete, cvte_id_stor_fmt) values (?, ?, ?, ?, ?, ?, ?, ?)", new Serializable[]{id, shareId, location, size, locatorTypeID, fileFormatTypeID, Character.valueOf(complete), storageFormatTermID});
            }
            hibernateTemplate.evict((Object)loaded);
        }
        this.lockRelatedEntities(data);
        hibernateTemplate.update((Object)data);
        hibernateTemplate.flush();
        this.scheduleDynamicPropertiesEvaluation(Collections.singletonList(data));
        if (operationLog.isInfoEnabled()) {
            operationLog.info(String.format("UPDATE: external data '%s'.", data));
        }
    }

    @Override
    public void delete(DataPE entity) throws DataAccessException {
        assert (entity != null) : "entity unspecified";
        if (entity.isContainer()) {
            ArrayList<DataPE> components = new ArrayList<DataPE>(entity.getContainedDataSets());
            for (DataPE component : components) {
                entity.removeComponent(component);
            }
        }
        this.flush();
        super.delete(entity);
    }

    @Override
    public void delete(List<TechId> dataIds, PersonPE registrator, String reason) throws DataAccessException {
        String sqlSelectPermIds = DataDAO.createSelectCodesOrderByIdSQL("data_all");
        String sqlSelectLocations = DataDAO.createSelectLocationsOrderByIdSQL("data_all");
        String sqlDeleteProperties = AbstractGenericEntityWithPropertiesDAO.SQLBuilder.createDeletePropertiesSQL("data_set_properties", "ds_id");
        String sqlDeleteDataSets = AbstractGenericEntityWithPropertiesDAO.SQLBuilder.createDeleteEnitiesSQL("data_all");
        String sqlInsertEvent = AbstractGenericEntityWithPropertiesDAO.SQLBuilder.createInsertEventSQL();
        String sqlDeleteExternalData = DataDAO.createDeleteExternalDataSQL();
        String sqlDeleteChildrenConnections = DataDAO.createDeleteChildrenConnectionsSQL();
        String sqlDeleteParentConnections = DataDAO.createDeleteParentConnectionsSQL();
        String sqlDeleteComponentConnections = DataDAO.createDeleteComponentConnectionsSQL();
        this.executePermanentDeleteOfDataSets(EventPE.EntityType.DATASET, dataIds, registrator, reason, sqlSelectPermIds, sqlSelectLocations, sqlDeleteProperties, sqlDeleteDataSets, sqlInsertEvent, sqlDeleteExternalData, sqlDeleteChildrenConnections, sqlDeleteParentConnections, sqlDeleteComponentConnections);
    }

    protected void executePermanentDeleteOfDataSets(EventPE.EntityType entityType, List<TechId> entityTechIds, PersonPE registrator, String reason, String sqlSelectPermIds, String sqlSelectLocations, String sqlDeleteProperties, String sqlDeleteEntities, String sqlInsertEvent, String ... additionalQueries) {
        List<Long> entityIds = TechId.asLongs(entityTechIds);
        DeleteDataSetsPermanentlyBatchOperation deleteOperation = new DeleteDataSetsPermanentlyBatchOperation(entityType, entityIds, registrator, reason, sqlSelectPermIds, sqlSelectLocations, sqlDeleteProperties, sqlDeleteEntities, sqlInsertEvent, additionalQueries);
        BatchOperationExecutor.executeInBatches(deleteOperation);
        this.scheduleRemoveFromFullTextIndex(entityIds);
    }

    private static String createSelectCodesOrderByIdSQL(String dataSetsTable) {
        return "SELECT code FROM " + dataSetsTable + " WHERE id " + AbstractGenericEntityWithPropertiesDAO.SQLBuilder.inEntityIds() + " ORDER BY id";
    }

    private static String createSelectLocationsOrderByIdSQL(String dataSetsTable) {
        return "SELECT ed.location, ed.share_id, ds.code FROM " + dataSetsTable + " d " + "JOIN data_stores ds ON (d.dast_id = ds.id) " + "LEFT OUTER JOIN external_data ed ON (d.id = ed.data_id) WHERE d.id " + AbstractGenericEntityWithPropertiesDAO.SQLBuilder.inEntityIds() + " ORDER BY d.id";
    }

    private static String createDeleteExternalDataSQL() {
        return "DELETE FROM external_data WHERE data_id " + AbstractGenericEntityWithPropertiesDAO.SQLBuilder.inEntityIds();
    }

    private static String createDeleteChildrenConnectionsSQL() {
        return "DELETE FROM data_set_relationships_all WHERE data_id_parent " + AbstractGenericEntityWithPropertiesDAO.SQLBuilder.inEntityIds();
    }

    private static String createDeleteParentConnectionsSQL() {
        return "DELETE FROM data_set_relationships_all WHERE data_id_child " + AbstractGenericEntityWithPropertiesDAO.SQLBuilder.inEntityIds();
    }

    private static String createDeleteComponentConnectionsSQL() {
        return "UPDATE data_all SET ctnr_id = NULL WHERE ctnr_id " + AbstractGenericEntityWithPropertiesDAO.SQLBuilder.inEntityIds();
    }

    @Override
    public Set<TechId> findParentIds(final Collection<TechId> dataSetIds) {
        List results = (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public final Object doInHibernate(Session session) {
                List<Long> longIds = TechId.asLongs(dataSetIds);
                return session.createSQLQuery("select data_id_parent from data_set_relationships where data_id_child in (:ids)").setParameterList("ids", longIds).list();
            }
        });
        return DataDAO.transformNumbers2TechIdSet(results);
    }

    @Override
    public List<DataPE> listByCode(Set<String> values) {
        if (values == null || values.isEmpty()) {
            return new ArrayList<DataPE>();
        }
        List<DataPE> list = DAOUtils.listByCollection(this.getHibernateTemplate(), DataPE.class, "code", values);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug(String.format("%d data set(s) have been found.", list.size()));
        }
        return list;
    }

    @Override
    public List<SpacePE> listSpacesByDataSetIds(Collection<Long> values) {
        final ArrayList<Long> allIds = new ArrayList<Long>(values);
        final String query = "from " + SpacePE.class.getSimpleName() + " as s where s.id in (select p.space.id from " + ProjectPE.class.getSimpleName() + " as p where p.id in (select e.projectInternal.id from " + ExperimentPE.class.getSimpleName() + " as e where e.id in (select d.experimentInternal.id from " + DataPE.class.getSimpleName() + " as d where d.id in (:ids))))";
        final ArrayList<SpacePE> result = new ArrayList<SpacePE>();
        BatchOperationExecutor.executeInBatches(new IBatchOperation<Long>(){

            @Override
            public void execute(List<Long> ids) {
                List spaces = DataDAO.cast(DataDAO.this.getHibernateTemplate().findByNamedParam(query, "ids", ids));
                result.addAll(spaces);
            }

            @Override
            public List<Long> getAllEntities() {
                return allIds;
            }

            @Override
            public String getEntityName() {
                return "space";
            }

            @Override
            public String getOperationName() {
                return "listSpacesByDataSetIds";
            }
        });
        return result;
    }

    @Override
    public void updateDataSets(List<DataPE> dataSets, PersonPE modifier) {
        assert (dataSets != null) : "Data sets not defined";
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        for (DataPE data : dataSets) {
            DataDAO.validatePE(data);
            data.setCode(CodeConverter.tryToDatabase(data.getCode()));
            hibernateTemplate.saveOrUpdate((Object)data);
        }
        if (operationLog.isInfoEnabled()) {
            operationLog.info(String.format("UPDATE: %d data sets.", dataSets.size()));
        }
        DataDAO.flushWithSqlExceptionHandling(this.getHibernateTemplate());
        this.scheduleDynamicPropertiesEvaluation(dataSets);
        hibernateTemplate.clear();
    }

    @Override
    public final void validateAndSaveUpdatedEntity(DataPE entity) throws DataAccessException {
        super.validateAndSaveUpdatedEntity(entity);
        this.scheduleDynamicPropertiesEvaluation(Arrays.asList(entity));
    }

    @Override
    public List<TechId> listDataSetIdsBySampleIds(Collection<TechId> samples) {
        List<Long> longIds = TechId.asLongs(samples);
        List results = DAOUtils.listByCollection(this.getHibernateTemplate(), new IDetachedCriteriaFactory(){

            @Override
            public DetachedCriteria createCriteria() {
                DetachedCriteria criteria = DetachedCriteria.forClass(DataPE.class);
                criteria.setProjection((Projection)Projections.id());
                return criteria;
            }
        }, "sampleInternal.id", longIds);
        if (operationLog.isDebugEnabled()) {
            operationLog.info(String.format("found %s data sets for given samples", results.size()));
        }
        return DataDAO.transformNumbers2TechIdList(results);
    }

    @Override
    public List<TechId> listDataSetIdsByExperimentIds(Collection<TechId> experiments) {
        List<Long> longIds = TechId.asLongs(experiments);
        List results = DAOUtils.listByCollection(this.getHibernateTemplate(), new IDetachedCriteriaFactory(){

            @Override
            public DetachedCriteria createCriteria() {
                DetachedCriteria criteria = DetachedCriteria.forClass(DataPE.class);
                criteria.setProjection((Projection)Projections.id());
                return criteria;
            }
        }, "experimentInternal.id", longIds);
        if (operationLog.isDebugEnabled()) {
            operationLog.info(String.format("found %s data sets for given experiments", results.size()));
        }
        return DataDAO.transformNumbers2TechIdList(results);
    }

    @Override
    Logger getLogger() {
        return operationLog;
    }

    @Override
    public List<TechId> listContainedDataSets(Collection<TechId> containerIds) {
        final List<Long> longIds = TechId.asLongs(containerIds);
        final ArrayList totalResults = new ArrayList();
        BatchOperationExecutor.executeInBatches(new IBatchOperation<Long>(){

            @Override
            public void execute(List<Long> batchIds) {
                List result = DAOUtils.listByCollection(DataDAO.this.getHibernateTemplate(), new IDetachedCriteriaFactory(){

                    @Override
                    public DetachedCriteria createCriteria() {
                        DetachedCriteria criteria = DetachedCriteria.forClass(DataPE.class);
                        criteria.setProjection((Projection)Projections.id());
                        return criteria;
                    }
                }, "containerInternal.id", batchIds);
                totalResults.addAll(result);
            }

            @Override
            public List<Long> getAllEntities() {
                return longIds;
            }

            @Override
            public String getEntityName() {
                return "dataSet";
            }

            @Override
            public String getOperationName() {
                return "listContainedDataSets";
            }
        }, 999);
        if (operationLog.isDebugEnabled()) {
            operationLog.info(String.format("found %s data sets for given containers", totalResults.size()));
        }
        return DataDAO.transformNumbers2TechIdList(totalResults);
    }

    @Override
    public List<TechId> listContainedDataSetsRecursively(Collection<TechId> containersIds) {
        LinkedHashSet<TechId> allIds = new LinkedHashSet<TechId>();
        List<TechId> containedDataSetIds = new LinkedList<TechId>();
        containedDataSetIds.addAll(containersIds);
        while (allIds.addAll(containedDataSetIds)) {
            containedDataSetIds = this.listContainedDataSets(containedDataSetIds);
        }
        return new ArrayList<TechId>(allIds);
    }

    @Override
    public boolean confirmStorage(String dataSetCode) {
        SQLQuery query = this.getSession().createSQLQuery("update external_data set storage_confirmation = true where storage_confirmation = false and data_id in (select id from data_all where code = :code)");
        query.setString("code", CodeConverter.tryToDatabase(dataSetCode));
        return query.executeUpdate() > 0;
    }

    @Override
    public boolean exists(String dataSetCode) {
        SQLQuery query = this.getSession().createSQLQuery("select count(*) from data_all where code = :code");
        query.setString("code", CodeConverter.tryToDatabase(dataSetCode));
        Number count = (Number)query.uniqueResult();
        return count != null && count.intValue() > 0;
    }

    protected class DeleteDataSetsPermanentlyBatchOperation
    implements IBatchOperation<Long> {
        private final EventPE.EntityType entityType;
        private final List<Long> allEntityIds;
        private final PersonPE registrator;
        private final String reason;
        private final String sqlSelectPermIds;
        private final String sqlSelectLocations;
        private final String sqlDeleteProperties;
        private final String sqlDeleteEntities;
        private final String sqlInsertEvent;
        private final String[] additionalQueries;

        public DeleteDataSetsPermanentlyBatchOperation(EventPE.EntityType entityType, List<Long> allEntityIds, PersonPE registrator, String reason, String sqlSelectPermIds, String sqlSelectLocations, String sqlDeleteProperties, String sqlDeleteEntities, String sqlInsertEvent, String ... additionalQueries) {
            this.entityType = entityType;
            this.allEntityIds = allEntityIds;
            this.registrator = registrator;
            this.reason = reason;
            this.sqlSelectPermIds = sqlSelectPermIds;
            this.sqlSelectLocations = sqlSelectLocations;
            this.sqlDeleteProperties = sqlDeleteProperties;
            this.sqlDeleteEntities = sqlDeleteEntities;
            this.sqlInsertEvent = sqlInsertEvent;
            this.additionalQueries = additionalQueries;
        }

        @Override
        public List<Long> getAllEntities() {
            return this.allEntityIds;
        }

        @Override
        public String getEntityName() {
            return this.entityType.name();
        }

        @Override
        public String getOperationName() {
            return "permanently deleting";
        }

        @Override
        public void execute(List<Long> batchEntityIds) {
            DataDAO.this.executeStatelessAction(this.createPermanentDeleteAction(batchEntityIds));
        }

        private AbstractDAO.StatelessHibernateCallback createPermanentDeleteAction(List<Long> entityIdsToDelete) {
            return new PermanentDeletionAction(entityIdsToDelete);
        }

        private class PermanentDeletionAction
        implements AbstractDAO.StatelessHibernateCallback {
            private final List<Long> entityIdsToDelete;

            public PermanentDeletionAction(List<Long> entityIdsToDelete) {
                this.entityIdsToDelete = entityIdsToDelete;
            }

            @Override
            public Object doInStatelessSession(StatelessSession session) {
                SQLQuery sqlQuerySelectPermIds = session.createSQLQuery(DeleteDataSetsPermanentlyBatchOperation.this.sqlSelectPermIds);
                SQLQuery sqlQuerySelectLocations = session.createSQLQuery(DeleteDataSetsPermanentlyBatchOperation.this.sqlSelectLocations);
                SQLQuery sqlQueryDeleteProperties = session.createSQLQuery(DeleteDataSetsPermanentlyBatchOperation.this.sqlDeleteProperties);
                SQLQuery sqlQueryDeleteEntities = session.createSQLQuery(DeleteDataSetsPermanentlyBatchOperation.this.sqlDeleteEntities);
                SQLQuery sqlQueryInsertEvent = session.createSQLQuery(DeleteDataSetsPermanentlyBatchOperation.this.sqlInsertEvent);
                ArrayList<SQLQuery> additionalSqlQueries = new ArrayList<SQLQuery>();
                String[] stringArray = DeleteDataSetsPermanentlyBatchOperation.this.additionalQueries;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String queryString = stringArray[n2];
                    additionalSqlQueries.add(session.createSQLQuery(queryString));
                    ++n2;
                }
                List<String> permIds = this.selectPermIds(sqlQuerySelectPermIds, this.entityIdsToDelete);
                if (permIds.isEmpty()) {
                    return null;
                }
                List<DeletedDataSetLocation> locations = this.selectLocations(sqlQuerySelectLocations, this.entityIdsToDelete);
                this.deleteProperties(sqlQueryDeleteProperties, this.entityIdsToDelete);
                this.executeAdditionalQueries(additionalSqlQueries, this.entityIdsToDelete);
                this.deleteMainEntities(sqlQueryDeleteEntities, this.entityIdsToDelete);
                this.insertEvent(sqlQueryInsertEvent, permIds, locations);
                return null;
            }

            private List<String> selectPermIds(SQLQuery sqlQuerySelectPermIds, List<Long> entityIds) {
                sqlQuerySelectPermIds.setParameterList("entityIds", entityIds);
                List permIdsOrNull = DataDAO.cast(sqlQuerySelectPermIds.list());
                return permIdsOrNull == null ? Collections.emptyList() : permIdsOrNull;
            }

            private List<DeletedDataSetLocation> selectLocations(SQLQuery sqlQuerySelectLocations, List<Long> entityIds) {
                sqlQuerySelectLocations.setParameterList("entityIds", entityIds);
                sqlQuerySelectLocations.setResultTransformer(new ResultTransformer(){
                    private static final long serialVersionUID = 1L;

                    public Object transformTuple(Object[] values, String[] aliases) {
                        DeletedDataSetLocation location = new DeletedDataSetLocation();
                        location.setLocation((String)values[0]);
                        location.setShareId((String)values[1]);
                        location.setDatastoreCode((String)values[2]);
                        return location;
                    }

                    public List transformList(List list) {
                        return list;
                    }
                });
                return DataDAO.cast(sqlQuerySelectLocations.list());
            }

            private void deleteProperties(SQLQuery sqlQueryDeleteProperties, List<Long> entityIds) {
                sqlQueryDeleteProperties.setParameterList("entityIds", entityIds);
                sqlQueryDeleteProperties.executeUpdate();
            }

            private void executeAdditionalQueries(List<SQLQuery> additionalSqlQueries, List<Long> entityIds) {
                for (SQLQuery query : additionalSqlQueries) {
                    query.setParameterList("entityIds", entityIds);
                    query.executeUpdate();
                }
            }

            private void deleteMainEntities(SQLQuery sqlQueryDeleteEntities, List<Long> entityIds) {
                sqlQueryDeleteEntities.setParameterList("entityIds", entityIds);
                sqlQueryDeleteEntities.executeUpdate();
            }

            private void insertEvent(SQLQuery sqlQueryInsertEvent, List<String> permIds, List<DeletedDataSetLocation> locations) {
                sqlQueryInsertEvent.setParameter("eventType", (Object)EventType.DELETION.name());
                sqlQueryInsertEvent.setParameter("reason", (Object)DeleteDataSetsPermanentlyBatchOperation.this.reason);
                sqlQueryInsertEvent.setParameter("registratorId", (Object)DeleteDataSetsPermanentlyBatchOperation.this.registrator.getId());
                sqlQueryInsertEvent.setParameter("entityType", (Object)DeleteDataSetsPermanentlyBatchOperation.this.entityType.name());
                IToStringConverter<Object> toStringConverter = new IToStringConverter<Object>(){
                    IToStringConverter<Object> delegatee = ToStringDefaultConverter.getInstance();

                    @Override
                    public String toString(Object value) {
                        return value == null ? "" : this.delegatee.toString(value);
                    }
                };
                String allPermIdsAsString = CollectionUtils.abbreviate(permIds, -1, toStringConverter, CollectionStyle.NO_BOUNDARY);
                sqlQueryInsertEvent.setParameter("identifiers", (Object)allPermIdsAsString);
                sqlQueryInsertEvent.setParameter("description", (Object)DeletedDataSetLocation.format(locations));
                sqlQueryInsertEvent.executeUpdate();
            }
        }
    }
}

