/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.systemsx.cisd.openbis.generic.server.business.bo.ICommonBusinessObjectFactory;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IExperimentTable;
import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.IDatasetLister;
import ch.systemsx.cisd.openbis.generic.server.business.bo.materiallister.IMaterialLister;
import ch.systemsx.cisd.openbis.generic.server.business.bo.samplelister.ISampleLister;
import ch.systemsx.cisd.openbis.generic.server.business.search.DataSetSearchManager;
import ch.systemsx.cisd.openbis.generic.server.business.search.ExperimentSearchManager;
import ch.systemsx.cisd.openbis.generic.server.business.search.MaterialSearchManager;
import ch.systemsx.cisd.openbis.generic.server.business.search.SampleSearchManager;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IHibernateSearchDAO;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import java.util.List;

class SearchHelper {
    private final Session session;
    private final ICommonBusinessObjectFactory businessObjectFactory;
    private final IDAOFactory daoFactory;

    public SearchHelper(Session session, ICommonBusinessObjectFactory businessObjectFactory, IDAOFactory daoFactory) {
        this.session = session;
        this.businessObjectFactory = businessObjectFactory;
        this.daoFactory = daoFactory;
    }

    public List<Sample> searchForSamples(String userId, DetailedSearchCriteria criteria) {
        ISampleLister sampleLister = this.businessObjectFactory.createSampleLister(this.session);
        IHibernateSearchDAO searchDAO = this.daoFactory.getHibernateSearchDAO();
        return new SampleSearchManager(searchDAO, sampleLister).searchForSamples(userId, criteria);
    }

    public List<AbstractExternalData> searchForDataSets(String userId, DetailedSearchCriteria detailedSearchCriteria) {
        IHibernateSearchDAO searchDAO = this.daoFactory.getHibernateSearchDAO();
        IDatasetLister dataSetLister = this.businessObjectFactory.createDatasetLister(this.session);
        return new DataSetSearchManager(searchDAO, dataSetLister).searchForDataSets(userId, detailedSearchCriteria);
    }

    public List<AbstractExternalData> searchForDataSets(String userId, Long userTechId, DetailedSearchCriteria detailedSearchCriteria) {
        IHibernateSearchDAO searchDAO = this.daoFactory.getHibernateSearchDAO();
        IDatasetLister dataSetLister = this.businessObjectFactory.createDatasetLister(this.session, userTechId);
        return new DataSetSearchManager(searchDAO, dataSetLister).searchForDataSets(userId, detailedSearchCriteria);
    }

    public List<Material> searchForMaterials(String userId, DetailedSearchCriteria detailedSearchCriteria) {
        IHibernateSearchDAO searchDAO = this.daoFactory.getHibernateSearchDAO();
        IMaterialLister materialLister = this.businessObjectFactory.createMaterialLister(this.session);
        return new MaterialSearchManager(searchDAO, materialLister).searchForMaterials(userId, detailedSearchCriteria);
    }

    public List<ExperimentPE> searchForExperiments(String userId, DetailedSearchCriteria detailedSearchCriteria) {
        IHibernateSearchDAO searchDAO = this.daoFactory.getHibernateSearchDAO();
        IExperimentTable experimentTable = this.businessObjectFactory.createExperimentTable(this.session);
        return new ExperimentSearchManager(searchDAO, experimentTable).searchForExperiments(userId, detailedSearchCriteria);
    }
}

