/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search;

import ch.systemsx.cisd.common.collection.CollectionUtils;
import java.io.Serializable;
import java.util.List;

public class EntitiesToUpdate
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Class<?> clazz;
    private final List<Long> ids;
    private final IndexUpdateOperationKind operationKind;

    public static EntitiesToUpdate remove(Class<?> clazz, List<Long> ids) {
        return new EntitiesToUpdate(IndexUpdateOperationKind.REMOVE, clazz, ids);
    }

    public static EntitiesToUpdate reindex(Class<?> clazz, List<Long> ids) {
        return new EntitiesToUpdate(IndexUpdateOperationKind.REINDEX, clazz, ids);
    }

    private EntitiesToUpdate(IndexUpdateOperationKind operationKind, Class<?> clazz, List<Long> ids) {
        this.clazz = clazz;
        this.ids = ids;
        this.operationKind = operationKind;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public List<Long> getIds() {
        return this.ids;
    }

    public IndexUpdateOperationKind getOperationKind() {
        return this.operationKind;
    }

    public String toString() {
        return (Object)((Object)this.operationKind) + " " + this.clazz.getName() + ": " + CollectionUtils.abbreviate(this.ids, 10);
    }

    public static enum IndexUpdateOperationKind {
        REINDEX,
        REMOVE;

    }
}

