/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tools;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;

public class MakeDatasetStructureTable {
    private PrintStream out;

    private void printHeader() {
        this.out.println(".. Please don't even think about editing this file directly.");
        this.out.println(".. It is generated using the 'gen-structure-table' Ant");
        this.out.println(".. target in components/bio-formats, which uses");
        this.out.println(".. loci.formats.tools.MakeDatasetStructureTable, so please");
        this.out.println(".. update that instead.");
        this.out.println();
        this.out.println("Dataset Structure Table");
        this.out.println("=======================");
        this.out.println();
        this.out.print("This table shows the extension of the file that you should ");
        this.out.println("choose if you want");
        this.out.println("to open/import a dataset in a particular format.");
        this.out.println();
        this.out.println(".. tabularcolumns:: |p{4cm}|p{3cm}|p{8cm}|");
        this.out.println();
        this.out.println(".. list-table::");
        this.out.println("   :header-rows: 1");
        this.out.println();
        this.out.println("   * - Format name");
        this.out.println("     - File to choose");
        this.out.println("     - Structure of files");
    }

    private void printFooter() {
        this.out.println();
        this.out.println("Flex Support");
        this.out.println("------------");
        this.out.println();
        this.out.println("OMERO.importer supports importing analyzed Flex files from an Opera");
        this.out.println("system.");
        this.out.println();
        this.out.println("Basic configuration is done via the ``importer.ini``. Once the user has");
        this.out.println("run the Importer once, this file will be in the following location:");
        this.out.println();
        this.out.println("-  ``C:\\Documents and Settings\\<username>\\omero\\importer.ini``");
        this.out.println();
        this.out.println("The user will need to modify or add the ``[FlexReaderServerMaps]``");
        this.out.println("section of the INI file as follows:");
        this.out.println();
        this.out.println("::");
        this.out.println();
        this.out.println("    ...");
        this.out.println("    [FlexReaderServerMaps]");
        this.out.println("    CIA-1 = \\\\\\\\hostname1\\\\mount;\\\\\\\\archivehost1\\\\mount");
        this.out.println("    CIA-2 = \\\\\\\\hostname2\\\\mount;\\\\\\\\archivehost2\\\\mount");
        this.out.println();
        this.out.println("where the *key* of the INI file line is the value of the \"Host\" tag in");
        this.out.println("the ``.mea`` measurement XML file (here: ``<Host name=\"CIA-1\">``) and");
        this.out.println("the value is a semicolon-separated list of *escaped* UNC path names to");
        this.out.println("the Opera workstations where the Flex files reside.");
        this.out.println();
        this.out.println("Once this resolution has been encoded in the configuration file **and**");
        this.out.println("you have restarted the importer, you will be able to select the ``.mea``");
        this.out.println("measurement XML file from the Importer user interface as the import");
        this.out.println("target.");
    }

    private void printFormatEntry(IFormatReader reader) {
        String format = reader.getFormat();
        String[] suffixes = reader.getSuffixes();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < suffixes.length; ++i) {
            if (suffixes[i].trim().length() > 0) {
                sb.append(".");
                sb.append(suffixes[i]);
            } else {
                sb.append("(no extension)");
            }
            if (i == suffixes.length - 1) continue;
            sb.append(", ");
        }
        String extension = sb.toString();
        String description = reader.getDatasetStructureDescription();
        this.out.println("   * - " + format);
        this.out.println("     - " + extension);
        this.out.println("     - " + description);
    }

    public void printTable() {
        ImageReader baseReader = new ImageReader();
        IFormatReader[] allReaders = baseReader.getReaders();
        Comparator<IFormatReader> comparator = new Comparator<IFormatReader>(){

            @Override
            public int compare(IFormatReader r1, IFormatReader r2) {
                String s1 = r1.getFormat();
                String s2 = r2.getFormat();
                return s1.compareTo(s2);
            }
        };
        Arrays.sort(allReaders, comparator);
        this.printHeader();
        for (IFormatReader reader : allReaders) {
            this.printFormatEntry(reader);
        }
        this.printFooter();
    }

    public void setOutputFile(String[] args) throws IOException {
        this.out = args.length == 0 ? System.out : new PrintStream(args[0], "UTF-8");
    }

    public void closeFile() throws IOException {
        this.out.close();
    }

    public static void main(String[] args) throws IOException {
        MakeDatasetStructureTable table = new MakeDatasetStructureTable();
        table.setOutputFile(args);
        table.printTable();
        table.closeFile();
    }
}

