/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.ddf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import loci.poi.ddf.EscherRecord;
import loci.poi.ddf.EscherRecordFactory;
import loci.poi.ddf.EscherSerializationListener;
import loci.poi.util.HexDump;
import loci.poi.util.LittleEndian;

public class UnknownEscherRecord
extends EscherRecord {
    private static final byte[] NO_BYTES = new byte[0];
    private byte[] thedata = NO_BYTES;
    private List childRecords = new ArrayList();

    public int fillFields(byte[] data, int offset, EscherRecordFactory recordFactory) {
        int bytesRemaining = this.readHeader(data, offset);
        if (this.isContainerRecord()) {
            int bytesWritten = 0;
            this.thedata = new byte[0];
            offset += 8;
            bytesWritten += 8;
            while (bytesRemaining > 0) {
                EscherRecord child = recordFactory.createRecord(data, offset);
                int childBytesWritten = child.fillFields(data, offset, recordFactory);
                bytesWritten += childBytesWritten;
                offset += childBytesWritten;
                bytesRemaining -= childBytesWritten;
                this.getChildRecords().add(child);
            }
            return bytesWritten;
        }
        this.thedata = new byte[bytesRemaining];
        System.arraycopy(data, offset + 8, this.thedata, 0, bytesRemaining);
        return bytesRemaining + 8;
    }

    public int serialize(int offset, byte[] data, EscherSerializationListener listener) {
        listener.beforeRecordSerialize(offset, this.getRecordId(), this);
        LittleEndian.putShort(data, offset, this.getOptions());
        LittleEndian.putShort(data, offset + 2, this.getRecordId());
        int remainingBytes = this.thedata.length;
        Iterator iterator = this.getChildRecords().iterator();
        while (iterator.hasNext()) {
            EscherRecord r = (EscherRecord)iterator.next();
            remainingBytes += r.getRecordSize();
        }
        LittleEndian.putInt(data, offset + 4, remainingBytes);
        System.arraycopy(this.thedata, 0, data, offset + 8, this.thedata.length);
        int pos = offset + 8 + this.thedata.length;
        Iterator iterator2 = this.getChildRecords().iterator();
        while (iterator2.hasNext()) {
            EscherRecord r = (EscherRecord)iterator2.next();
            pos += r.serialize(pos, data, listener);
        }
        listener.afterRecordSerialize(pos, this.getRecordId(), pos - offset, this);
        return pos - offset;
    }

    public byte[] getData() {
        return this.thedata;
    }

    public int getRecordSize() {
        return 8 + this.thedata.length;
    }

    public List getChildRecords() {
        return this.childRecords;
    }

    public void setChildRecords(List childRecords) {
        this.childRecords = childRecords;
    }

    public Object clone() {
        return super.clone();
    }

    public String getRecordName() {
        return "Unknown 0x" + HexDump.toHex(this.getRecordId());
    }

    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuffer children = new StringBuffer();
        if (this.getChildRecords().size() > 0) {
            children.append("  children: " + nl);
            Iterator iterator = this.getChildRecords().iterator();
            while (iterator.hasNext()) {
                EscherRecord record = (EscherRecord)iterator.next();
                children.append(record.toString());
                children.append(nl);
            }
        }
        String theDumpHex = "";
        try {
            if (this.thedata.length != 0) {
                theDumpHex = "  Extra Data:" + nl;
                theDumpHex = theDumpHex + HexDump.dump(this.thedata, 0L, 0);
            }
        }
        catch (Exception e) {
            theDumpHex = "Error!!";
        }
        return this.getClass().getName() + ":" + nl + "  isContainer: " + this.isContainerRecord() + nl + "  options: 0x" + HexDump.toHex(this.getOptions()) + nl + "  recordId: 0x" + HexDump.toHex(this.getRecordId()) + nl + "  numchildren: " + this.getChildRecords().size() + nl + theDumpHex + children.toString();
    }

    public void addChildRecord(EscherRecord childRecord) {
        this.getChildRecords().add(childRecord);
    }
}

