/*
 * Decompiled with CFR 0.152.
 */
package mdbtools.dbengine.tasks;

import java.sql.SQLException;
import mdbtools.dbengine.MemoryData;
import mdbtools.dbengine.sql.FQColumn;
import mdbtools.dbengine.sql.OrderBy;
import mdbtools.dbengine.tasks.Task;

public class SimpleSort
implements Task {
    private MemoryData result;
    private Task task;
    private OrderBy[] sortBy;
    private int[] tableMap;

    public SimpleSort(Task task, OrderBy[] sortBy, int[] tableMap) throws SQLException {
        this.task = task;
        this.sortBy = sortBy;
        this.tableMap = tableMap;
    }

    public void run() throws SQLException {
        MemoryData data = (MemoryData)this.task.getResult();
        int[] sb = new int[this.sortBy.length];
        boolean[] ascending = new boolean[sb.length];
        for (int i = 0; i < this.sortBy.length; ++i) {
            sb[i] = this.getColumnToSort(this.sortBy[i].getSort());
            ascending[i] = this.sortBy[i].isAscending();
        }
        data.sort(sb, ascending);
        this.result = data;
    }

    public Object getResult() {
        return this.result;
    }

    private int getColumnToSort(Object column) throws SQLException {
        if (column instanceof Integer) {
            return (Integer)column - 1;
        }
        if (column instanceof FQColumn) {
            FQColumn c = (FQColumn)column;
            return this.tableMap[c.getTable()] + c.getColumn();
        }
        throw new SQLException("I don't know how to sort this");
    }
}

