/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application.page;

import ch.systemsx.cisd.cifex.client.application.ViewContext;
import ch.systemsx.cisd.cifex.client.application.grid.GridWidget;
import ch.systemsx.cisd.cifex.client.application.model.AbstractFileGridModel;
import ch.systemsx.cisd.cifex.client.application.page.AbstractMainPageTabController;
import ch.systemsx.cisd.cifex.client.application.page.AdminTabController;
import ch.systemsx.cisd.cifex.client.application.page.InboxTabController;
import ch.systemsx.cisd.cifex.client.application.page.InviteTabController;
import ch.systemsx.cisd.cifex.client.application.page.ShareTabController;
import ch.systemsx.cisd.cifex.client.application.utils.MessageDictionary;
import ch.systemsx.cisd.cifex.shared.basic.dto.UserInfoDTO;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.TabPanelEvent;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.TabPanel;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import java.util.ArrayList;
import java.util.List;

public final class MainPageTabPanel
extends TabPanel {
    private final ShareTabController shareTab;
    private final TabItem shareTabItem;
    private final InboxTabController inboxTab;
    private final TabItem inboxTabItem;
    private final InviteTabController inviteTabOrNull;
    private final TabItem inviteTabItemOrNull;
    private final AdminTabController adminTabOrNull;
    private final TabItem adminTabItemOrNull;
    private final ViewContext context;
    private final List<GridWidget<AbstractFileGridModel>> fileGridWidgets;

    public MainPageTabPanel(ViewContext context) {
        this.context = context;
        this.fileGridWidgets = new ArrayList<GridWidget<AbstractFileGridModel>>(3);
        this.shareTab = new ShareTabController(this.context, this.fileGridWidgets);
        this.inboxTab = new InboxTabController(this.context, this.fileGridWidgets);
        this.shareTabItem = this.createTabItem(MessageDictionary.msg(MessageDictionary.SHARE_VIEW_LABEL), this.shareTab);
        this.shareTabItem.setHideMode(Style.HideMode.OFFSETS);
        this.inboxTabItem = this.createTabItem(MessageDictionary.msg(MessageDictionary.INBOX_VIEW_LABEL), this.inboxTab);
        UserInfoDTO user = context.getModel().getUser();
        if (user.isPermanent() && !user.isAdmin()) {
            this.inviteTabOrNull = new InviteTabController(this.context, this.fileGridWidgets);
            this.inviteTabItemOrNull = this.createTabItem(MessageDictionary.msg(MessageDictionary.INVITE_VIEW_LABEL), this.inviteTabOrNull);
        } else {
            this.inviteTabOrNull = null;
            this.inviteTabItemOrNull = null;
        }
        if (user.isAdmin()) {
            this.adminTabOrNull = new AdminTabController(this.context, this.fileGridWidgets);
            this.adminTabItemOrNull = this.createTabItem(MessageDictionary.msg(MessageDictionary.ADMIN_VIEW_LABEL), this.adminTabOrNull);
        } else {
            this.adminTabOrNull = null;
            this.adminTabItemOrNull = null;
        }
        this.initializePanel();
    }

    public void showTab(Tab tab) {
        switch (tab) {
            case INBOX_TAB: {
                this.setSelection(this.inboxTabItem);
                break;
            }
            case INVITE_TAB: {
                if (this.inviteTabItemOrNull == null) break;
                this.setSelection(this.inviteTabItemOrNull);
                break;
            }
            case SHARE_TAB: {
                this.setSelection(this.shareTabItem);
                break;
            }
            case ADMIN_TAB: {
                if (this.adminTabItemOrNull == null) break;
                this.setSelection(this.adminTabItemOrNull);
            }
        }
    }

    private final void initializePanel() {
        this.add(this.shareTabItem);
        this.add(this.inboxTabItem);
        if (this.context.getModel().getUser().isPermanent() && this.inviteTabItemOrNull != null) {
            this.add(this.inviteTabItemOrNull);
        }
        if (this.context.getModel().getUser().isAdmin() && this.adminTabOrNull != null) {
            this.add(this.adminTabItemOrNull);
        }
        this.ensureDebugId("cifex-tabpanel");
    }

    private TabItem createTabItem(String name, final AbstractMainPageTabController tabController) {
        TabItem tabItem = new TabItem(name);
        tabItem.setLayout((Layout)new FitLayout());
        tabItem.setClosable(false);
        tabItem.add(tabController.getWidget());
        tabItem.addListener(Events.Select, (Listener)new Listener<TabPanelEvent>(){

            public void handleEvent(TabPanelEvent be) {
                MainPageTabPanel.this.context.getPageController().setCurrentPage(tabController.getPageIdentifier());
            }
        });
        return tabItem;
    }

    public static enum Tab {
        SHARE_TAB,
        INBOX_TAB,
        INVITE_TAB,
        ADMIN_TAB;

    }
}

