/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client.gui;

import ch.systemsx.cisd.cifex.rpc.client.FileItem;
import ch.systemsx.cisd.cifex.rpc.client.FileItemStatus;
import ch.systemsx.cisd.cifex.rpc.client.ICIFEXUploader;
import ch.systemsx.cisd.cifex.rpc.client.gui.IProgressListener;
import ch.systemsx.cisd.common.utilities.ITimeProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang.ArrayUtils;

final class UploadTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private final ITimeProvider timeProvider;
    private List<FileItem> fileItems = new ArrayList<FileItem>();
    private FileItem currentFileToBeUploaded;

    UploadTableModel(ICIFEXUploader uploader, ITimeProvider timeProvider) {
        this.timeProvider = timeProvider;
        uploader.addProgressListener(new IProgressListener(){

            @Override
            public void start(File file, String operationName, long fileSize, Long fileIdOrNull) {
                UploadTableModel.this.currentFileToBeUploaded = UploadTableModel.this.tryToFind(file);
                this.setNumberOfBytes(0L);
                UploadTableModel.this.fireChanged(null);
            }

            @Override
            public void reportProgress(int percentage, long numberOfBytes) {
                if (percentage == 100) {
                    if (UploadTableModel.this.currentFileToBeUploaded != null) {
                        this.setNumberOfBytes(UploadTableModel.this.currentFileToBeUploaded.getLength());
                        UploadTableModel.this.currentFileToBeUploaded.setStatus(FileItemStatus.FINISHED);
                    }
                } else {
                    this.setNumberOfBytes(numberOfBytes);
                }
                UploadTableModel.this.fireChanged(null);
            }

            @Override
            public void finished(boolean successful) {
                if (UploadTableModel.this.currentFileToBeUploaded != null) {
                    if (successful) {
                        this.setNumberOfBytes(UploadTableModel.this.currentFileToBeUploaded.getLength());
                        UploadTableModel.this.fireChanged(FileItemStatus.FINISHED);
                    } else {
                        UploadTableModel.this.fireChanged(FileItemStatus.ABORTED);
                    }
                }
            }

            @Override
            public void exceptionOccured(Throwable throwable) {
                UploadTableModel.this.fireChanged(FileItemStatus.STALLED);
            }

            @Override
            public void warningOccured(String warningMessage) {
                UploadTableModel.this.fireChanged(FileItemStatus.STALLED);
            }

            private void setNumberOfBytes(long numberOfBytes) {
                if (UploadTableModel.this.currentFileToBeUploaded != null) {
                    UploadTableModel.this.currentFileToBeUploaded.setNumberOfBytesUploaded(numberOfBytes);
                }
            }
        });
    }

    void addFile(File file) {
        int size = this.fileItems.size();
        this.fileItems.add(new FileItem(file, this.timeProvider));
        this.fireTableRowsInserted(size, size);
    }

    List<File> getFiles() {
        ArrayList<File> files = new ArrayList<File>();
        for (FileItem fileItem : this.fileItems) {
            files.add(fileItem.getFile());
        }
        return files;
    }

    FileItem getFileItem(int index) {
        return this.fileItems.get(index);
    }

    boolean alreadyAdded(File file) {
        for (FileItem fileItem : this.fileItems) {
            if (!file.equals(fileItem.getFile())) continue;
            return true;
        }
        return false;
    }

    public FileItem tryToFind(File file) {
        for (FileItem fileItem : this.fileItems) {
            if (!fileItem.getUploadedFile().equals(file)) continue;
            return fileItem;
        }
        return null;
    }

    private void fireChanged(FileItemStatus statusOrNull) {
        if (this.currentFileToBeUploaded != null) {
            if (statusOrNull != null) {
                this.currentFileToBeUploaded.setStatus(statusOrNull);
            }
            int index = this.fileItems.indexOf(this.currentFileToBeUploaded);
            this.fireTableRowsUpdated(index, index);
        }
    }

    public FileItem fireChanged(File file, FileItemStatus statusOrNull) {
        this.currentFileToBeUploaded = this.tryToFind(file);
        this.fireChanged(statusOrNull);
        return this.currentFileToBeUploaded;
    }

    @Override
    public int getRowCount() {
        return this.fileItems.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        FileItem fileItem = this.fileItems.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return fileItem.getFile().getName();
            }
            case 1: {
                return fileItem;
            }
        }
        return null;
    }

    public void removeRows(int[] rows) {
        ArrayUtils.reverse((int[])rows);
        int[] nArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            int rowIndex = nArray[n2];
            this.fileItems.remove(rowIndex);
            ++n2;
        }
    }
}

