/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.server;

import ch.systemsx.cisd.cifex.rpc.server.Session;
import ch.systemsx.cisd.cifex.server.business.IUserActionLog;
import ch.systemsx.cisd.cifex.server.business.dto.UserDTO;
import ch.systemsx.cisd.common.exceptions.InvalidSessionException;
import ch.systemsx.cisd.common.security.TokenGenerator;
import ch.systemsx.cisd.common.servlet.IActionLog;
import ch.systemsx.cisd.common.servlet.IRequestContextProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpSession;

public class SessionManager {
    private final boolean testMode;
    private final TokenGenerator tokenGenerator = new TokenGenerator();
    private final Map<String, Session> sessions = new HashMap<String, Session>();
    private final IRequestContextProvider requestContextProviderOrNull;
    private final IUserActionLog userBehaviorLogOrNull;
    private int nextID;

    public SessionManager(IRequestContextProvider requestContextProvider, IUserActionLog userBehaviorLogOrNull, String testingFlag) {
        this.requestContextProviderOrNull = requestContextProvider;
        this.userBehaviorLogOrNull = userBehaviorLogOrNull;
        this.testMode = "true".equals(testingFlag);
    }

    Collection<Session> getAllSessions() {
        return this.sessions.values();
    }

    public synchronized Session createSession(UserDTO user, String url) {
        String sessionID = this.testMode ? Integer.toString(this.nextID++) : this.tokenGenerator.getNewToken(System.currentTimeMillis());
        Session session = new Session(sessionID, user, url);
        this.sessions.put(sessionID, session);
        this.storeRPCSessionInHTTPSession(session);
        if (this.userBehaviorLogOrNull != null) {
            this.userBehaviorLogOrNull.logSuccessfulLogin();
        }
        return session;
    }

    public synchronized Session getSession(String sessionID) throws InvalidSessionException {
        return this.getSession(sessionID, true);
    }

    synchronized Session getSession(String sessionID, boolean storeInHTTPSession) throws InvalidSessionException {
        Session session = this.sessions.get(sessionID);
        if (session == null) {
            throw new InvalidSessionException("No session found for ID " + sessionID);
        }
        session.touchSession();
        if (storeInHTTPSession) {
            this.storeRPCSessionInHTTPSession(session);
        }
        return session;
    }

    public synchronized void removeSession(String sessionID, boolean timedOut) {
        Session removedSession = this.sessions.remove(sessionID);
        if (this.userBehaviorLogOrNull != null && removedSession != null) {
            this.userBehaviorLogOrNull.logLogout(removedSession, timedOut ? IActionLog.LogoutReason.SESSION_TIMEOUT : IActionLog.LogoutReason.SESSION_LOGOUT);
        }
    }

    public synchronized void removeSessionsForUser(String userCode) {
        Iterator<Session> sessionIt = this.sessions.values().iterator();
        while (sessionIt.hasNext()) {
            Session session = sessionIt.next();
            if (!userCode.equals(session.getUser().getUserCode())) continue;
            sessionIt.remove();
            if (this.userBehaviorLogOrNull == null) continue;
            this.userBehaviorLogOrNull.logLogout(session, IActionLog.LogoutReason.USER_DELETED);
        }
    }

    private void storeRPCSessionInHTTPSession(Session session) {
        if (this.requestContextProviderOrNull != null) {
            HttpSession httpSession = this.requestContextProviderOrNull.getHttpServletRequest().getSession();
            httpSession.setAttribute("rpc-session", (Object)session);
        }
    }
}

