/*
 * Decompiled with CFR 0.152.
 */
package net.lemnik.eodsql.spi.util;

import java.sql.SQLException;
import java.util.Collection;
import net.lemnik.eodsql.DataSetCache;
import net.lemnik.eodsql.spi.Context;
import net.lemnik.eodsql.spi.util.ConnectedDataSet;
import net.lemnik.eodsql.spi.util.DataObjectBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UpdatableDataSet<T>
extends ConnectedDataSet<T> {
    UpdatableDataSet(DataObjectBinding<T> binding, Context context, DataSetCache<T> cache) {
        super(binding, context, cache);
    }

    @Override
    public void disconnect() {
        throw new UnsupportedOperationException("Updatable DataSet cannot be disconnected.");
    }

    @Override
    public boolean add(T e) {
        try {
            this.results.moveToInsertRow();
            this.binding.marshall(e, this.results);
            this.results.insertRow();
            this.results.moveToCurrentRow();
            this.setSize(null);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        if (c.isEmpty()) {
            return false;
        }
        for (T o : c) {
            this.add(o);
        }
        return true;
    }

    @Override
    public T remove(int index) {
        Object value = this.get(index);
        try {
            this.results.absolute(index + 1);
            this.results.deleteRow();
            this.setSize(null);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    @Override
    public T set(int index, T element) {
        Object oldValue = this.get(index);
        try {
            this.results.absolute(index + 1);
            this.binding.marshall(element, this.results);
            this.results.updateRow();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        return oldValue;
    }
}

