/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.authentication.crowd;

import ch.systemsx.cisd.common.time.DateTimeUtils;
import org.apache.commons.lang.StringUtils;

public class CrowdConfiguration {
    private String host;
    private int port = 443;
    private String application;
    private String applicationPassword;
    private int timeout = 10000;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        if (CrowdConfiguration.isResolved(host)) {
            this.host = host;
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        if (port > 0) {
            this.port = port;
        }
    }

    public String getPortStr() {
        return Integer.toString(this.port);
    }

    public void setPortStr(String portStr) {
        if (CrowdConfiguration.isResolved(portStr)) {
            try {
                this.setPort(Integer.parseInt(portStr));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public String getServerURL() {
        if (this.isConfigured()) {
            return "https://" + this.host + ":" + this.port + "/crowd/services/SecurityServer";
        }
        return null;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        if (CrowdConfiguration.isResolved(application)) {
            this.application = application;
        }
    }

    public String getApplicationPassword() {
        return this.applicationPassword;
    }

    public void setApplicationPassword(String applicationPassword) {
        if (CrowdConfiguration.isResolved(applicationPassword)) {
            this.applicationPassword = applicationPassword;
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeoutMillis) {
        this.timeout = timeoutMillis < 0 ? 0 : timeoutMillis;
    }

    public void setTimeoutStr(String timeoutStr) {
        if (CrowdConfiguration.isResolved(timeoutStr)) {
            try {
                this.setTimeout((int)DateTimeUtils.parseDurationToMillis(timeoutStr));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public String getTimeoutStr() {
        return Integer.toString(this.getTimeout() / 1000);
    }

    public boolean isConfigured() {
        return StringUtils.isNotBlank((String)this.host) && StringUtils.isNotBlank((String)this.application) && StringUtils.isNotBlank((String)this.applicationPassword);
    }

    private static boolean isResolved(String name) {
        return StringUtils.isNotBlank((String)name) && !name.startsWith("${");
    }
}

