/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.filesystem.FileOperations;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.properties.ExtendedProperties;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.etlserver.IDataSetHandler;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BatchOperationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.DatabaseInstanceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.parser.GlobalProperties;
import ch.systemsx.cisd.openbis.generic.shared.parser.GlobalPropertiesLoader;
import ch.systemsx.cisd.openbis.generic.shared.parser.NamedInputStream;
import ch.systemsx.cisd.openbis.generic.shared.parser.SampleUploadSectionsParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class SampleRegisteringDropbox
implements IDataSetHandler {
    private static final String USER_KEY = "USER";
    private static final String DEFAULT_SPACE_KEY = "DEFAULT_SPACE";
    private static final String SAMPLE_TYPE_KEY = "SAMPLE_TYPE";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, SampleRegisteringDropbox.class);
    private final IEncapsulatedOpenBISService service;
    private String logDir;
    private String samplePrefix;

    public SampleRegisteringDropbox(Properties parentProperties, IDataSetHandler delegator, IEncapsulatedOpenBISService service) {
        this.service = service;
        Properties specificProperties = SampleRegisteringDropbox.getSpecificProperties(parentProperties);
        this.logDir = PropertyUtils.getMandatoryProperty(specificProperties, "error-log-dir");
        this.samplePrefix = PropertyUtils.getProperty(specificProperties, "sample-code-prefix", "S");
    }

    private static Properties getSpecificProperties(Properties properties) {
        return ExtendedProperties.getSubset(properties, "dataset-handler.", true);
    }

    @Override
    public List<DataSetInformation> handleDataSet(File file) {
        File marker = new File(file.getParent(), this.createErrorMarkerFileName(file));
        File logFile = new File(new File(this.logDir), this.createErrorLogFileName(file));
        try {
            if (marker.exists() || file.getName().endsWith("_delete_me_after_correcting_errors")) {
                return this.createReturnValue();
            }
            GlobalProperties properties = GlobalPropertiesLoader.load(file);
            String defaultSpaceIdentifierOrNull = this.tryExtractSpaceIdentifier(properties);
            String userOrNull = properties.tryGet(USER_KEY);
            SampleType sampleType = this.extractSampleType(properties);
            this.logGlobalPropertiesExtracted(file, defaultSpaceIdentifierOrNull, userOrNull, sampleType);
            boolean generateCodesAutomatically = defaultSpaceIdentifierOrNull != null;
            SampleUploadSectionsParser.SampleCodeGenerator sampleCodeGeneratorOrNull = this.tryCreateCodeGenrator(generateCodesAutomatically);
            NamedInputStream stream = new NamedInputStream(new FileInputStream(file), file.getName());
            SampleUploadSectionsParser.BatchSamplesOperation info = SampleUploadSectionsParser.prepareSamples(sampleType, Arrays.asList(stream), defaultSpaceIdentifierOrNull, sampleCodeGeneratorOrNull, true, null, BatchOperationKind.REGISTRATION);
            this.logSamplesExtracted(file, info);
            this.service.registerSamples(info.getSamples(), userOrNull);
            this.logSamplesRegistered(file, info);
        }
        catch (Throwable ex) {
            String message = ex.getMessage();
            try {
                FileUtils.touch((File)marker);
                FileUtils.writeStringToFile((File)logFile, (String)message);
            }
            catch (IOException iOException) {
                operationLog.error((Object)String.format("Could not write to error log: [%s]. Message: [%s]", logFile.getPath(), message));
            }
            return this.createReturnValue();
        }
        FileOperations.getMonitoredInstanceForCurrentThread().deleteRecursively(file);
        this.logFileDeletion(file);
        return this.createReturnValue();
    }

    private String createErrorLogFileName(File file) {
        return String.valueOf(file.getName()) + "_" + "error-log.txt";
    }

    private String createErrorMarkerFileName(File file) {
        return String.valueOf(file.getName()) + "_delete_me_after_correcting_errors";
    }

    private ArrayList<DataSetInformation> createReturnValue() {
        return new ArrayList<DataSetInformation>();
    }

    private void logSamplesRegistered(File file, SampleUploadSectionsParser.BatchSamplesOperation info) {
        String message = String.format("%s samples extracted from file '%s' and registered", info.getCodes().length, file.getName());
        operationLog.info((Object)message);
    }

    private void logFileDeletion(File file) {
        String message = String.format("Deleting file '%s' after successfull registration of samples", file.getName());
        operationLog.debug((Object)message);
    }

    private void logSamplesExtracted(File file, SampleUploadSectionsParser.BatchSamplesOperation info) {
        String message = String.format("Samples found in file '%s': %s", file.getName(), info.getCodes().length);
        operationLog.debug((Object)message);
    }

    private void logGlobalPropertiesExtracted(File file, String defaultSpaceIdentifierOrNull, String userOrNull, SampleType sampleType) {
        String message = String.format("Global properties extracted from file '%s': SAMPLE_TYPE(%s) DEFAULT_SPACE(%s) USER(%s)", file.getName(), sampleType, defaultSpaceIdentifierOrNull, userOrNull);
        operationLog.debug((Object)message);
    }

    private SampleType extractSampleType(GlobalProperties properties) {
        String sampleTypeCode = properties.get(SAMPLE_TYPE_KEY);
        SampleType sampleType = new SampleType();
        sampleType.setCode(sampleTypeCode);
        return sampleType;
    }

    private String tryExtractSpaceIdentifier(GlobalProperties properties) {
        String spaceCodeOrNull = properties.tryGet(DEFAULT_SPACE_KEY);
        if (spaceCodeOrNull == null) {
            return null;
        }
        return new SpaceIdentifier(DatabaseInstanceIdentifier.createHome(), spaceCodeOrNull).toString();
    }

    private SampleUploadSectionsParser.SampleCodeGenerator tryCreateCodeGenrator(boolean generateCodesAutomatically) {
        if (generateCodesAutomatically) {
            return new SampleUploadSectionsParser.SampleCodeGenerator(){

                @Override
                public List<String> generateCodes(int size) {
                    return SampleRegisteringDropbox.this.service.generateCodes(SampleRegisteringDropbox.this.samplePrefix, EntityKind.SAMPLE, size);
                }
            };
        }
        return null;
    }
}

