/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.api.impl;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.common.filesystem.FileOperations;
import ch.systemsx.cisd.common.filesystem.IFileOperations;
import ch.systemsx.cisd.etlserver.registrator.api.impl.AbstractTransactionalCommand;
import java.io.File;
import java.io.IOException;

public class MoveFileCommand
extends AbstractTransactionalCommand {
    private static final long serialVersionUID = 1L;
    private final String srcParentDirAbsolutePath;
    private final String srcFileName;
    private final boolean srcIsFile;
    private final String dstParentDirAbsolutePath;
    private final String dstFileName;

    public MoveFileCommand(String srcParentDirAbsolutePath, String srcFileName, String dstParentDirAbsolutePath, String dstFileName) {
        this.srcParentDirAbsolutePath = srcParentDirAbsolutePath;
        this.srcFileName = srcFileName;
        this.srcIsFile = this.getSrc().isFile();
        this.dstParentDirAbsolutePath = dstParentDirAbsolutePath;
        this.dstFileName = dstFileName;
    }

    @Override
    public void execute() {
        File src = this.getSrc();
        File dst = this.getDst();
        if (!src.exists()) {
            IOException checkedException = new IOException("Source file for move does not exist");
            throw new IOExceptionUnchecked(checkedException);
        }
        this.moveFile(src, dst);
    }

    private File getDst() {
        return new File(this.dstParentDirAbsolutePath, this.dstFileName);
    }

    private File getSrc() {
        return new File(this.srcParentDirAbsolutePath, this.srcFileName);
    }

    @Override
    public void rollback() {
        File src = this.getSrc();
        File dst = this.getDst();
        if (!dst.exists()) {
            if (!src.exists()) {
                MoveFileCommand.getOperationLog().error((Object)"Could not undo move command. The file move source file no longer exists.");
            }
            return;
        }
        if (this.srcIsFile && dst.isDirectory()) {
            File movedFile = new File(dst, src.getName());
            this.moveFile(movedFile, new File(this.srcParentDirAbsolutePath));
        } else {
            this.moveFile(dst, src);
        }
    }

    private void moveFile(File from, File to) {
        String entity = from.isFile() ? "file" : "directory";
        MoveFileCommand.getOperationLog().info((Object)String.format("Moving %s '%s' to '%s'", entity, from.getAbsolutePath(), to.getAbsolutePath()));
        IFileOperations fileOperations = FileOperations.getMonitoredInstanceForCurrentThread();
        fileOperations.move(from, to);
        if (from.exists()) {
            MoveFileCommand.getOperationLog().error((Object)String.format("Failed to move %s '%s' to '%s'", entity, from.getAbsolutePath(), to.getAbsolutePath()));
        }
    }

    public String toString() {
        return "MoveFileCommand [srcParentDirAbsolutePath=" + this.srcParentDirAbsolutePath + ", srcFileName=" + this.srcFileName + ", dstParentDirAbsolutePath=" + this.dstParentDirAbsolutePath + ", dstFileName=" + this.dstFileName + "]";
    }
}

