/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.registrator.api.v2.impl;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.IExperimentImmutable;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.IObjectId;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.id.experiment.ExperimentIdentifierId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.util.EntityHelper;

public class ExperimentImmutable
implements IExperimentImmutable {
    private final Experiment experiment;

    public ExperimentImmutable(Experiment experiment) {
        this.experiment = experiment;
    }

    @Override
    public String getExperimentIdentifier() {
        String identifier = this.experiment.getIdentifier();
        return identifier == null ? null : identifier.toUpperCase();
    }

    public Long getId() {
        return this.experiment.getId();
    }

    @Override
    public IObjectId getEntityId() {
        return new ExperimentIdentifierId(this.getExperimentIdentifier());
    }

    @Override
    public boolean isExistingExperiment() {
        return true;
    }

    protected void checkExists() {
        if (!this.isExistingExperiment()) {
            throw new UserFailureException("Experiment does not exist.");
        }
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    @Override
    public String getPropertyValue(String propertyCode) {
        return EntityHelper.tryFindPropertyValue(this.experiment, propertyCode);
    }

    @Override
    public String getExperimentType() {
        if (this.experiment.getExperimentType() != null) {
            return this.experiment.getExperimentType().getCode();
        }
        return null;
    }

    @Override
    public String getPermId() {
        return this.experiment.getPermId();
    }

    public int hashCode() {
        return this.getExperimentIdentifier().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        ExperimentImmutable other = (ExperimentImmutable)obj;
        return !(this.getExperimentIdentifier() == null ? other.getExperimentIdentifier() != null : !this.getExperimentIdentifier().equals(other.getExperimentIdentifier()));
    }
}

