/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.archiveverifier.batch;

import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.DataSetArchiveVerificationResult;
import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.IArchiveFileRepository;
import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.IArchiveFileVerifier;
import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.IDataSetArchiveVerifier;
import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.VerificationError;
import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.VerificationErrorType;
import java.io.File;
import java.util.List;

public class DataSetArchiveVerifier
implements IDataSetArchiveVerifier {
    private final IArchiveFileVerifier verifier;
    private final IArchiveFileRepository fileRepository;

    public DataSetArchiveVerifier(IArchiveFileRepository fileRepository, IArchiveFileVerifier verifier) {
        this.fileRepository = fileRepository;
        this.verifier = verifier;
    }

    @Override
    public DataSetArchiveVerificationResult run(String dataSetCode) {
        File file = this.fileRepository.getArchiveFileOf(dataSetCode);
        if (file.exists()) {
            List<VerificationError> errors = this.verifier.verify(file);
            return new DataSetArchiveVerificationResult(file, errors);
        }
        return new DataSetArchiveVerificationResult(VerificationErrorType.ERROR, "file not found");
    }
}

