/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl;

import ch.systemsx.cisd.base.image.IImageTransformerFactory;
import ch.systemsx.cisd.common.reflection.AbstractHashable;
import ch.systemsx.cisd.hcs.Location;
import ch.systemsx.cisd.openbis.dss.etl.RelativeImageReference;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeNormalizer;

public class AcquiredSingleImage
extends AbstractHashable {
    private final Location wellLocationOrNull;
    private final Location tileLocation;
    private final String channelCode;
    private final Float timePointOrNull;
    private final Float depthOrNull;
    private Integer seriesNumberOrNull;
    private final RelativeImageReference imageFilePath;
    private RelativeImageReference thumbnailFilePathOrNull;
    private IImageTransformerFactory imageTransformerFactoryOrNull;

    public AcquiredSingleImage(Location wellLocationOrNull, Location tileLocation, String channelCode, Float timePointOrNull, Float depthOrNull, Integer seriesNumberOrNull, RelativeImageReference imageFilePath, RelativeImageReference thumbnailFilePathOrNull) {
        this.wellLocationOrNull = wellLocationOrNull;
        this.tileLocation = tileLocation;
        this.channelCode = CodeNormalizer.normalize(channelCode);
        this.timePointOrNull = timePointOrNull;
        this.depthOrNull = depthOrNull;
        this.seriesNumberOrNull = seriesNumberOrNull;
        this.imageFilePath = imageFilePath;
        this.thumbnailFilePathOrNull = thumbnailFilePathOrNull;
    }

    public Location tryGetWellLocation() {
        return this.wellLocationOrNull;
    }

    public int getWellRow() {
        assert (this.wellLocationOrNull != null) : "wellLocationOrNull is null";
        return this.wellLocationOrNull.getY();
    }

    public int getWellColumn() {
        assert (this.wellLocationOrNull != null) : "wellLocationOrNull is null";
        return this.wellLocationOrNull.getX();
    }

    public int getTileRow() {
        return this.tileLocation.getY();
    }

    public int getTileColumn() {
        return this.tileLocation.getX();
    }

    public String getChannelCode() {
        return this.channelCode;
    }

    public Float tryGetTimePoint() {
        return this.timePointOrNull;
    }

    public Float tryGetDepth() {
        return this.depthOrNull;
    }

    public RelativeImageReference getImageReference() {
        return this.imageFilePath;
    }

    public RelativeImageReference getThumbnailFilePathOrNull() {
        return this.thumbnailFilePathOrNull;
    }

    public Integer tryGetSeriesNumber() {
        return this.seriesNumberOrNull;
    }

    public void setSeriesNumber(int seriesNumber) {
        this.seriesNumberOrNull = seriesNumber;
    }

    public IImageTransformerFactory tryGetImageTransformerFactory() {
        return this.imageTransformerFactoryOrNull;
    }

    public void setImageTransformerFactory(IImageTransformerFactory imageTransformerFactoryOrNull) {
        this.imageTransformerFactoryOrNull = imageTransformerFactoryOrNull;
    }
}

