/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.dto.api;

import ch.systemsx.cisd.base.image.IImageTransformerFactory;
import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.dss.etl.dto.ImageLibraryInfo;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.Channel;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ChannelColor;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ChannelColorComponent;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ChannelColorRGB;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ImageIdentifier;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ImageMetadata;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ImageStorageConfiguraton;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.IntensityRange;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.Location;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.OriginalDataStorageFormat;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.thumbnails.DefaultThumbnailsConfiguration;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.thumbnails.IThumbnailsConfiguration;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.thumbnails.ResolutionBasedThumbnailsConfiguration;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.thumbnails.ZoomLevelBasedThumbnailsConfiguration;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.transformations.ConvertToolImageTransformerFactory;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.transformations.ImageTransformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeNormalizer;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Geometry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class SimpleImageDataConfig {
    private String mainDatasetTypeCode;
    private String fileFormatCode = "UNKNOWN";
    private String plateCode;
    private String spaceCode;
    private boolean isMeasured = false;
    private String[] recognizedImageExtensions = new String[]{"tiff", "tif", "png", "gif", "jpg", "jpeg", "c01"};
    private List<IThumbnailsConfiguration> imagePyramid = new ArrayList<IThumbnailsConfiguration>();
    private int maxThumbnailWidthAndHeight = 256;
    private boolean generateThumbnailsWithImageMagic = true;
    private List<String> thumbnailsGenerationImageMagicParams = Collections.emptyList();
    private boolean generateThumbnailsIn8BitHighQuality = false;
    private double allowedMachineLoadDuringThumbnailsGeneration = 1.0;
    private boolean storeChannelsOnExperimentLevel = false;
    private OriginalDataStorageFormat originalDataStorageFormat = OriginalDataStorageFormat.UNCHANGED;
    private String convertTransformationCliArgumentsOrNull;
    private ImageLibraryInfo imageLibraryInfoOrNull;
    private boolean isMicroscopy;
    private List<String> computeCommonIntensityRangeOfAllImagesForChannelsOrNull = null;
    private float computeCommonIntensityRangeOfAllImagesThreshold = 0.01f;
    private String computeCommonIntensityRangeOfAllImagesLabel = "Optimal (series)";
    private boolean computeCommonIntensityRangeOfAllImagesIsDefault = true;
    private Map<String, IntensityRange> fixedIntensityRangeForAllImages;
    private String thumbnailsFileFormat;
    private List<Channel> channels;
    private List<ChannelColorComponent> channelColorComponentsOrNull;
    private Integer colorDepth;

    public ImageMetadata extractImageMetadata(String imagePath) {
        throw new UnsupportedOperationException("One of the extractImageMetadata() methods has to be implemented.");
    }

    public ImageMetadata[] extractImagesMetadata(String imagePath, List<ImageIdentifier> imageIdentifiers) {
        ImageMetadata[] imageMetadataArray;
        ImageMetadata imageMetadata = this.extractImageMetadata(imagePath);
        if (imageMetadata != null) {
            ImageMetadata[] imageMetadataArray2 = new ImageMetadata[1];
            imageMetadataArray = imageMetadataArray2;
            imageMetadataArray2[0] = imageMetadata;
        } else {
            imageMetadataArray = new ImageMetadata[]{};
        }
        return imageMetadataArray;
    }

    public Geometry getTileGeometry(List<? extends ImageMetadata> imageMetadataList, int maxTileNumber) {
        return Geometry.createFromRowColDimensions(1, maxTileNumber);
    }

    public Location getTileCoordinates(int tileNumber, Geometry tileGeometry) {
        int columns = tileGeometry.getWidth();
        int row = (tileNumber - 1) / columns + 1;
        int col = (tileNumber - 1) % columns + 1;
        return new Location(row, col);
    }

    public Channel createChannel(String channelCode) {
        ChannelColorRGB channelColorOrNull = this.tryGetChannelColor(channelCode.toUpperCase());
        ImageTransformation[] availableTransformations = this.getAvailableChannelTransformations(channelCode);
        String label = channelCode;
        String normalizedChannelCode = CodeNormalizer.normalize(channelCode);
        Channel channel = new Channel(normalizedChannelCode, label, channelColorOrNull);
        channel.setAvailableTransformations(availableTransformations);
        return channel;
    }

    private ChannelColorRGB tryGetChannelColor(String channelCode) {
        ChannelColor channelColor = this.getChannelColor(channelCode);
        ChannelColorRGB channelColorRGB = this.getChannelColorRGB(channelCode);
        if (channelColorRGB != null && channelColor != null) {
            throw new IllegalStateException(String.format("Color for channel '%s' is specified in two ways: %s and %s", new Object[]{channelColor, channelColorRGB}));
        }
        if (channelColor != null) {
            return channelColor.getRGB();
        }
        return channelColorRGB;
    }

    public ImageTransformation[] getAvailableChannelTransformations(String channelCode) {
        return null;
    }

    public ChannelColor getChannelColor(String channelCode) {
        return null;
    }

    public ChannelColorRGB getChannelColorRGB(String channelCode) {
        return null;
    }

    public ImageStorageConfiguraton getImageStorageConfiguration() {
        ImageStorageConfiguraton imageStorageConfiguraton = ImageStorageConfiguraton.createDefault();
        imageStorageConfiguraton.setStoreChannelsOnExperimentLevel(this.isStoreChannelsOnExperimentLevel());
        imageStorageConfiguraton.setOriginalDataStorageFormat(this.getOriginalDataStorageFormat());
        for (IThumbnailsConfiguration thumbnailsConfiguration : this.imagePyramid) {
            imageStorageConfiguraton.addThumbnailsStorageFormat(thumbnailsConfiguration.getThumbnailsStorageFormat(this));
        }
        if (!StringUtils.isBlank(this.convertTransformationCliArgumentsOrNull)) {
            ConvertToolImageTransformerFactory convertTransformerFactory = new ConvertToolImageTransformerFactory(this.convertTransformationCliArgumentsOrNull);
            imageStorageConfiguraton.setImageTransformerFactory((IImageTransformerFactory)convertTransformerFactory);
        }
        imageStorageConfiguraton.setImageLibrary(this.imageLibraryInfoOrNull);
        return imageStorageConfiguraton;
    }

    public String getPlateSpace() {
        return this.spaceCode;
    }

    public String getPlateCode() {
        return this.plateCode;
    }

    public String[] getRecognizedImageExtensions() {
        return this.recognizedImageExtensions;
    }

    public boolean isGenerateThumbnails() {
        return this.imagePyramid.size() > 0;
    }

    public int getMaxThumbnailWidthAndHeight() {
        return this.maxThumbnailWidthAndHeight;
    }

    public double getAllowedMachineLoadDuringThumbnailsGeneration() {
        return this.allowedMachineLoadDuringThumbnailsGeneration;
    }

    public boolean isStoreChannelsOnExperimentLevel() {
        return this.storeChannelsOnExperimentLevel;
    }

    public OriginalDataStorageFormat getOriginalDataStorageFormat() {
        return this.originalDataStorageFormat;
    }

    public String tryGetConvertTransformationCliArguments() {
        return this.convertTransformationCliArgumentsOrNull;
    }

    public List<String> getComputeCommonIntensityRangeOfAllImagesForChannels() {
        return this.computeCommonIntensityRangeOfAllImagesForChannelsOrNull;
    }

    public float getComputeCommonIntensityRangeOfAllImagesThreshold() {
        return this.computeCommonIntensityRangeOfAllImagesThreshold;
    }

    public boolean isFixedIntensityRangeForAllImagesDefined() {
        return this.fixedIntensityRangeForAllImages != null;
    }

    public Map<String, IntensityRange> getFixedIntensityRangeForAllImages() {
        return this.fixedIntensityRangeForAllImages;
    }

    public String getComputeCommonIntensityRangeOfAllImagesLabel() {
        return this.computeCommonIntensityRangeOfAllImagesLabel;
    }

    public boolean isComputeCommonIntensityRangeOfAllImagesDefault() {
        return this.computeCommonIntensityRangeOfAllImagesIsDefault;
    }

    public List<Channel> getChannels() {
        return this.channels;
    }

    public List<ChannelColorComponent> getChannelColorComponentsOrNull() {
        return this.channelColorComponentsOrNull;
    }

    public void setPlate(String spaceCode, String plateCode) {
        this.spaceCode = spaceCode;
        this.plateCode = plateCode;
    }

    public void setRecognizedImageExtensions(String[] recognizedImageExtensions) {
        this.recognizedImageExtensions = recognizedImageExtensions;
    }

    public void setChannels(List<Channel> channels) {
        this.channels = channels;
    }

    public void setChannels(List<Channel> channels, List<ChannelColorComponent> channelColorComponents) {
        this.channels = channels;
        this.channelColorComponentsOrNull = channelColorComponents;
    }

    public void setGenerateThumbnails(boolean generateThumbnails) {
        this.imagePyramid.clear();
        this.imagePyramid.add(new DefaultThumbnailsConfiguration());
    }

    @Deprecated
    public void setGenerateImagePyramid(IThumbnailsConfiguration[] elements) {
        this.setGenerateImageRepresentations(elements);
    }

    @Deprecated
    public void setGenerateImagePyramidWithScaleFactors(double[] zoomLevels) {
        this.setGenerateImageRepresentationsUsingScaleFactors(zoomLevels);
    }

    @Deprecated
    public void setGenerateImagePyramidWithImageResolution(String[] resolutions) {
        this.setGenerateImageRepresentationsUsingImageResolutions(resolutions);
    }

    public void setGenerateImageRepresentations(IThumbnailsConfiguration[] formats) {
        this.imagePyramid.clear();
        this.imagePyramid.addAll(Arrays.asList(formats));
    }

    public void setGenerateImageRepresentationsUsingScaleFactors(double[] scaleFactors) {
        this.imagePyramid.clear();
        if (scaleFactors == null) {
            return;
        }
        double[] dArray = scaleFactors;
        int n = scaleFactors.length;
        int n2 = 0;
        while (n2 < n) {
            double scaleFactor = dArray[n2];
            if (scaleFactor <= 0.0) {
                throw new IllegalArgumentException("Scale factors for generated image representations must be greater than 0. " + scaleFactor + " <= 0");
            }
            ++n2;
        }
        dArray = scaleFactors;
        n = scaleFactors.length;
        n2 = 0;
        while (n2 < n) {
            double scale = dArray[n2];
            this.addGeneratedImageRepresentationWithScale(scale);
            ++n2;
        }
    }

    public IThumbnailsConfiguration addGeneratedImageRepresentationWithScale(double scale) {
        if (scale <= 0.0) {
            throw new IllegalArgumentException("Scale factors for generated image representations must be greater than 0. " + scale + " <= 0");
        }
        ZoomLevelBasedThumbnailsConfiguration imageRep = new ZoomLevelBasedThumbnailsConfiguration(scale);
        this.imagePyramid.add(imageRep);
        return imageRep;
    }

    public void setGenerateImageRepresentationsUsingImageResolutions(String[] resolutions) {
        this.setGenerateImageRepresentationsUsingImageResolutions(resolutions, true);
    }

    public void setGenerateImageRepresentationsWithoutEnlargingUsingImageResolutions(String[] resolutions) {
        this.setGenerateImageRepresentationsUsingImageResolutions(resolutions, false);
    }

    private void setGenerateImageRepresentationsUsingImageResolutions(String[] resolutions, boolean allowEnlarging) {
        this.imagePyramid.clear();
        if (resolutions != null) {
            String[] stringArray = resolutions;
            int n = resolutions.length;
            int n2 = 0;
            while (n2 < n) {
                String resolution = stringArray[n2];
                this.addGeneratedImageRepresentationWithResolution(resolution, allowEnlarging);
                ++n2;
            }
        }
    }

    public IThumbnailsConfiguration addGeneratedImageRepresentationWithResolution(String resolution) {
        return this.addGeneratedImageRepresentationWithResolution(resolution, true);
    }

    public IThumbnailsConfiguration addGeneratedImageRepresentationWithoutEnlargingWithResolution(String resolution) {
        return this.addGeneratedImageRepresentationWithResolution(resolution, false);
    }

    private IThumbnailsConfiguration addGeneratedImageRepresentationWithResolution(String resolution, boolean allowEnlarging) {
        String[] dimension = resolution.split("x");
        if (dimension.length != 2) {
            throw new IllegalArgumentException("Resolution must be specified in format width x height, e. g. '400x300', but was: '" + resolution + "'");
        }
        int width = Integer.parseInt(dimension[0].trim());
        int height = Integer.parseInt(dimension[1].trim());
        ResolutionBasedThumbnailsConfiguration imageRep = new ResolutionBasedThumbnailsConfiguration(width, height, allowEnlarging);
        this.imagePyramid.add(imageRep);
        return imageRep;
    }

    public void setMaxThumbnailWidthAndHeight(int maxThumbnailWidthAndHeight) {
        this.maxThumbnailWidthAndHeight = maxThumbnailWidthAndHeight;
    }

    public void setAllowedMachineLoadDuringThumbnailsGeneration(double allowedMachineLoadDuringThumbnailsGeneration) {
        this.allowedMachineLoadDuringThumbnailsGeneration = allowedMachineLoadDuringThumbnailsGeneration;
    }

    public void setUseImageMagicToGenerateThumbnails(boolean generateWithImageMagic) {
        this.generateThumbnailsWithImageMagic = generateWithImageMagic;
    }

    public boolean getGenerateThumbnailsWithImageMagic() {
        return this.generateThumbnailsWithImageMagic;
    }

    public void setThumbnailsGenerationImageMagicParams(String[] imageMagicParams) {
        this.thumbnailsGenerationImageMagicParams = Arrays.asList(imageMagicParams);
    }

    public List<String> getThumbnailsGenerationImageMagicParams() {
        return this.thumbnailsGenerationImageMagicParams;
    }

    public void setGenerateHighQuality8BitThumbnails(boolean highQualityThumbnails) {
        this.generateThumbnailsIn8BitHighQuality = highQualityThumbnails;
    }

    public boolean getGenerateThumbnailsIn8BitHighQuality() {
        return this.generateThumbnailsIn8BitHighQuality;
    }

    @Deprecated
    public void setGenerateHighQualityThumbnails(boolean highQualityThumbnails) {
        this.generateThumbnailsIn8BitHighQuality = highQualityThumbnails;
    }

    public void setComputeCommonIntensityRangeOfAllImagesForAllChannels() {
        this.computeCommonIntensityRangeOfAllImagesForChannelsOrNull = Collections.emptyList();
    }

    public void setComputeCommonIntensityRangeOfAllImagesForChannels(String[] channelCodesOrNull) {
        this.computeCommonIntensityRangeOfAllImagesForChannelsOrNull = Arrays.asList(channelCodesOrNull);
    }

    public void setComputeCommonIntensityRangeOfAllImagesLabel(String userFriendlyTransformationlabel) {
        this.computeCommonIntensityRangeOfAllImagesLabel = userFriendlyTransformationlabel;
    }

    public void setComputeCommonIntensityRangeOfAllImagesThreshold(float threshold) {
        this.computeCommonIntensityRangeOfAllImagesThreshold = threshold;
    }

    public void setDefaultFixedIntensityRangeForAllImages(int minLevel, int maxLevel) {
        if (this.fixedIntensityRangeForAllImages == null) {
            this.fixedIntensityRangeForAllImages = new HashMap<String, IntensityRange>();
        }
        this.fixedIntensityRangeForAllImages.put(null, new IntensityRange(minLevel, maxLevel));
    }

    public void addFixedIntensityRangeForAllImages(String channelCode, int minLevel, int maxLevel) {
        if (this.fixedIntensityRangeForAllImages == null) {
            this.fixedIntensityRangeForAllImages = new HashMap<String, IntensityRange>();
        }
        this.fixedIntensityRangeForAllImages.put(CodeNormalizer.normalize(channelCode), new IntensityRange(minLevel, maxLevel));
    }

    public void setComputeCommonIntensityRangeOfAllImagesIsDefault(boolean isDefault) {
        this.computeCommonIntensityRangeOfAllImagesIsDefault = isDefault;
    }

    public void setStoreChannelsOnExperimentLevel(boolean storeChannelsOnExperimentLevel) {
        this.storeChannelsOnExperimentLevel = storeChannelsOnExperimentLevel;
    }

    public void setOriginalDataStorageFormat(OriginalDataStorageFormat originalDataStorageFormat) {
        this.originalDataStorageFormat = originalDataStorageFormat;
    }

    public void setOriginalDataStorageFormat(ch.systemsx.cisd.openbis.dss.etl.dto.api.v1.OriginalDataStorageFormat originalDataStorageFormat) {
        this.originalDataStorageFormat = originalDataStorageFormat.getIndependentOriginalDataStorageFormat();
    }

    public void setConvertTransformationCliArguments(String convertTransformationCliArguments) {
        this.convertTransformationCliArgumentsOrNull = convertTransformationCliArguments;
    }

    public void setImageLibrary(String imageLibraryName, String readerName) {
        this.imageLibraryInfoOrNull = new ImageLibraryInfo(imageLibraryName, readerName);
    }

    public void setImageLibrary(String imageLibraryName) {
        this.imageLibraryInfoOrNull = new ImageLibraryInfo(imageLibraryName);
    }

    public void setRawImageDatasetType() {
        this.setDataSetType("HCS_IMAGE_RAW");
        this.setMeasuredData(true);
    }

    public void setOverviewImageDatasetType() {
        this.setDataSetType("HCS_IMAGE_OVERVIEW");
        this.setMeasuredData(false);
    }

    public void setSegmentationImageDatasetType() {
        this.setDataSetType("HCS_IMAGE_SEGMENTATION");
        this.setMeasuredData(false);
    }

    public void setDataSetType(String datasetTypeCode) {
        this.mainDatasetTypeCode = datasetTypeCode;
    }

    public void setFileFormatType(String fileFormatCode) {
        this.fileFormatCode = fileFormatCode;
    }

    public void setMeasuredData(boolean isMeasured) {
        this.isMeasured = isMeasured;
    }

    public void setMicroscopyData(boolean isMicroscopy) {
        this.isMicroscopy = isMicroscopy;
    }

    public String getDataSetType() {
        return this.mainDatasetTypeCode;
    }

    public String getFileFormatType() {
        return this.fileFormatCode;
    }

    public boolean isMeasuredData() {
        return this.isMeasured;
    }

    public boolean isMicroscopyData() {
        return this.isMicroscopy;
    }

    public void setThumbnailsFileFormat(String thumbnailsFileFormat) {
        this.thumbnailsFileFormat = thumbnailsFileFormat;
    }

    public String getThumbnailsFileFormat() {
        return this.thumbnailsFileFormat;
    }

    public Integer getColorDepth() {
        return this.colorDepth;
    }

    public void setColorDepth(Integer colorDepth) {
        this.colorDepth = colorDepth;
    }
}

