/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.dto.api.v1.impl;

import ch.systemsx.cisd.etlserver.registrator.DataSetRegistrationDetails;
import ch.systemsx.cisd.etlserver.registrator.api.v1.IDataSet;
import ch.systemsx.cisd.etlserver.registrator.api.v1.impl.DataSet;
import ch.systemsx.cisd.openbis.dss.etl.PlateGeometryOracle;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.ImageDataSetInformation;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.v1.IImageDataSet;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v1.IExperimentImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v1.ISampleImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import java.io.File;
import java.util.Collections;
import java.util.List;

public class ImageContainerDataSet
extends DataSet<DataSetInformation>
implements IImageDataSet {
    private DataSet<ImageDataSetInformation> originalDataset;
    private List<IDataSet> thumbnailDatasets = Collections.emptyList();
    private boolean establishSampleLinkForContainedDataSets = false;

    public ImageContainerDataSet(DataSetRegistrationDetails<? extends DataSetInformation> registrationDetails, File dataSetFolder, IEncapsulatedOpenBISService service) {
        super(registrationDetails, dataSetFolder, service);
    }

    @Override
    public void setAnalysisProcedure(String analysisProcedure) {
        this.setPropertyValue("$ANALYSIS_PROCEDURE", analysisProcedure);
    }

    @Override
    public void establishSampleLinkForContainedDataSets() {
        this.establishSampleLinkForContainedDataSets = true;
    }

    public boolean sampleLinkForContainedDataSetsShouldBeEstablished() {
        return this.establishSampleLinkForContainedDataSets;
    }

    @Override
    public DataSet<ImageDataSetInformation> getOriginalDataset() {
        return this.originalDataset;
    }

    public void setOriginalDataset(DataSet<ImageDataSetInformation> originalDataset) {
        this.originalDataset = originalDataset;
    }

    @Override
    public List<IDataSet> getThumbnailDatasets() {
        return this.thumbnailDatasets;
    }

    public void setThumbnailDatasets(List<IDataSet> thumbnailDatasets) {
        this.thumbnailDatasets = thumbnailDatasets;
    }

    @Override
    public void setSample(ISampleImmutable sampleOrNull) {
        super.setSample(sampleOrNull);
        if (this.originalDataset != null) {
            this.originalDataset.setSample(sampleOrNull);
            this.originalDataset.getRegistrationDetails().getDataSetInformation().setLinkSample(this.establishSampleLinkForContainedDataSets);
        }
        for (IDataSet thumbnailDataset : this.thumbnailDatasets) {
            thumbnailDataset.setSample(sampleOrNull);
            if (!(thumbnailDataset instanceof DataSet)) continue;
            ((DataSetInformation)((DataSet)thumbnailDataset).getRegistrationDetails().getDataSetInformation()).setLinkSample(this.establishSampleLinkForContainedDataSets);
        }
    }

    @Override
    public void setExperiment(IExperimentImmutable experimentOrNull) {
        super.setExperiment(experimentOrNull);
        if (this.originalDataset != null) {
            this.originalDataset.setExperiment(experimentOrNull);
        }
        for (IDataSet thumbnailDataset : this.thumbnailDatasets) {
            thumbnailDataset.setExperiment(experimentOrNull);
        }
    }

    @Override
    public String figureGeometry() {
        return PlateGeometryOracle.figureGeometry(this.getImageRegistrationDetails(), this.service);
    }

    private DataSetRegistrationDetails<ImageDataSetInformation> getImageRegistrationDetails() {
        return this.originalDataset.getRegistrationDetails();
    }
}

