/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.dbbackup;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.common.io.PropertyIOUtils;
import ch.systemsx.cisd.common.properties.ExtendedProperties;
import ch.systemsx.cisd.openbis.dss.generic.server.dbbackup.BackupDatabaseParser;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DssPluginType;
import ch.systemsx.cisd.openbis.generic.shared.coreplugin.CorePluginScanner;
import ch.systemsx.cisd.openbis.generic.shared.coreplugin.CorePluginsInjector;
import ch.systemsx.cisd.openbis.generic.shared.coreplugin.CorePluginsUtils;
import java.io.File;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;

public class BackupDatabaseDescriptionGenerator {
    public static final String AS_DB_KEY_PREFIX = "database.";
    public static final String PROTEOMICS_DB_KEY_PREFIX = "proteomics.database.";
    public static final String HCS_IMAGING_DB_VERSION_HOLDER = "ch.systemsx.cisd.openbis.dss.etl.ImagingDatabaseVersionHolder";
    private static final String AS_BASIC_DB_NAME = "openbis";
    private Set<String> result = new TreeSet<String>();

    private void process(Properties properties) {
        String openBisDatabase = BackupDatabaseParser.getAppServerDatabaseDescription(properties, AS_DB_KEY_PREFIX, AS_BASIC_DB_NAME);
        this.addIfFound(openBisDatabase);
        List<String> descriptions = BackupDatabaseParser.getDssServerDatabaseDescriptions(properties);
        for (String description : descriptions) {
            this.addIfFound(description);
        }
    }

    private void addIfFound(String databaseDescription) {
        if (!StringUtils.isEmpty((String)databaseDescription)) {
            this.result.add(databaseDescription);
        }
    }

    void process(String[] fileNames) {
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            File file = new File(fileName);
            if (file.isFile() && file.canRead()) {
                Properties properties = this.readPropertiesAndInjectCorePluginsIfDSS(file);
                this.process(properties);
            } else {
                System.err.println("Cannot read from specified file " + fileName);
            }
            ++n2;
        }
    }

    private Properties readPropertiesAndInjectCorePluginsIfDSS(File propertiesFile) {
        Properties properties = PropertyIOUtils.loadProperties(propertiesFile);
        if (this.isDSSPropertiesFile(propertiesFile)) {
            String corePluginsFolderRelativePath = CorePluginsUtils.getCorePluginsFolder(properties, CorePluginScanner.ScannerType.DSS);
            File workingDirectory = propertiesFile.getParentFile().getParentFile();
            File corePluginsFolder = new File(workingDirectory, corePluginsFolderRelativePath);
            File file = new File(corePluginsFolder, "core-plugins.properties");
            PropertyIOUtils.loadAndAppendProperties(properties, file);
            CorePluginsInjector injector = new CorePluginsInjector(CorePluginScanner.ScannerType.DSS, DssPluginType.values());
            injector.injectCorePlugins(properties, corePluginsFolder.getAbsolutePath());
        }
        return ExtendedProperties.createWith(properties);
    }

    private boolean isDSSPropertiesFile(File propertiesFile) {
        String grandParentName = propertiesFile.getParentFile().getParentFile().getName();
        if (grandParentName.equals("datastore_server")) {
            return true;
        }
        if (grandParentName.equals("jetty")) {
            return false;
        }
        throw new IllegalArgumentException("Neither DSS nor AS service.properties file: " + propertiesFile.getAbsolutePath());
    }

    String getResult() {
        StringBuilder builder = new StringBuilder();
        for (String description : this.result) {
            if (builder.length() > 0) {
                builder.append('\n');
            }
            builder.append(description);
        }
        return builder.toString();
    }

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            System.err.println("Please specify a list of properties files to be parsed.");
            System.exit(1);
        }
        try {
            System.out.println(BackupDatabaseDescriptionGenerator.getDescriptions(args));
        }
        catch (IOExceptionUnchecked e) {
            System.err.println(e.getMessage());
            System.exit(2);
        }
    }

    public static String getDescriptions(String[] args) {
        BackupDatabaseDescriptionGenerator generator = new BackupDatabaseDescriptionGenerator();
        generator.process(args);
        return generator.getResult();
    }
}

